#include <string.h>
#include <pwd.h>

extern char homedir[];

void expand_tilde (char *buf, char *str);

void
expand_tilde (char *buf, char *str)
{
	register char *p = str;
	register int len;

	if (*p == '~') {
		p++;
		if (*p == '/' || !*p) {
			len = strlen(homedir);
			strcpy(&(buf[len]), p);
			memcpy(buf, homedir, len);
		} else {
			char *rest;
			struct passwd *pwe;

			if ((rest = strchr(p, '/')))
				*rest++ = 0;
			if ((pwe = getpwnam(p))) {
				len = strlen(pwe->pw_dir);
				if (rest) {
					strcpy(&(buf[len + 1]), rest);
					buf[len] = '/';
				}
				memcpy(buf, pwe->pw_dir, len);
			}
		}
	} else
		strcpy(buf, str);
}
