#ifndef __GNOME_STUFF_H
#define __GNOME_STUFF_H

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#define GNOME_PROPERTY_BOX(a) GTK_WIDGET(a)
#define GNOME_DIALOG(a) GTK_DIALOG(a)
#define GNOME_APP(a) GTK_WIDGET(a)

#ifdef ENABLE_NLS
#    include <libintl.h>
#    define _(String) gettext (String)
#    ifdef gettext_noop
#        define N_(String) gettext_noop (String)
#    else
#        define N_(String) (String)
#    endif
#else
/* Stubs that do something close enough.  */
#    define textdomain(String) (String)
#    define gettext(String) (String)
#    define dgettext(Domain,Message) (Message)
#    define dcgettext(Domain,Message,Type) (Message)
#    define bindtextdomain(Domain,Directory) (Domain)
#    define _(String) (String)
#    define N_(String) (String)
#endif

typedef struct
{
    GtkDialog *dialog;

    GtkWidget *notebook;
    GtkWidget *ok_button;
    GtkWidget *apply_button;
    GtkWidget *close_button;

    GtkFunction applyfunc;
    gpointer applyfuncdata;
}
GnomePropertyBox;

/* config stuff */
gchar *gnome_config_get_string(gchar *path);
gint gnome_config_get_int(gchar *path);
gboolean gnome_config_get_bool(gchar *path);

void gnome_config_set_int(gchar *path, gint value);
void gnome_config_set_bool(gchar *path, gboolean value);
void gnome_config_set_string(gchar *path, gchar *value);
void gnome_config_sync(void);

/* property box stuff */
GtkWidget *gnome_property_box_new(void);
void gnome_property_box_changed(GtkWidget *box);
void gnome_property_box_set_apply_func(GtkWidget *box, GtkFunction func, gpointer data);
gint gnome_property_box_append_page(GtkWidget *box, GtkWidget *child, GtkWidget *tab_label);

typedef struct
{
    gint type;
    gchar *label;
    gchar *hint;
    gpointer moreinfo;
    gpointer user_data;
    gpointer unused;
    gint pixtype;
    gpointer pixmap;
    guint acceleration;
    guint ac_mods;
    GtkWidget *widget;
}
GnomeUIInfo;

typedef enum {
	GNOME_APP_UI_ENDOFINFO,		/* No more items, use it at the end of 
					   an array */
	GNOME_APP_UI_TOGGLEITEM,	/* Toggle (check box) item */
	GNOME_APP_UI_ITEM,		/* Normal item, or radio item if it is
					   inside a radioitems group */
	GNOME_APP_UI_SUBTREE,		/* Item that defines a 
					   subtree/submenu */
	GNOME_APP_UI_SEPARATOR,		/* Separator line (menus) or blank 
					   space (toolbars) */
} GnomeUIInfoType;

typedef enum {
	GNOME_APP_PIXMAP_NONE,		/* No pixmap specified */
	GNOME_APP_PIXMAP_STOCK,		/* Use a stock pixmap (GnomeStock) */
} GnomeUIPixmapType;

/* Used to terminate an array of GnomeUIInfo structures */
#define GNOMEUIINFO_END			{ GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,		\
					  0, NULL, 0, (GdkModifierType) 0, NULL }

/* Insert a separator line (on a menu) or a blank space (on a toolbar) */
#define GNOMEUIINFO_SEPARATOR		{ GNOME_APP_UI_SEPARATOR, NULL, NULL, NULL, NULL, NULL,		\
					  0, NULL, 0, (GdkModifierType) 0, NULL }

#define GNOME_STOCK_MENU_ABOUT        NULL
#define GNOME_STOCK_MENU_EXIT         NULL
#define GNOME_STOCK_MENU_NEW          NULL
#define GNOME_STOCK_MENU_CLOSE        NULL
#define GNOME_STOCK_MENU_OPEN         NULL
#define GNOME_STOCK_MENU_SAVE         NULL
#define GNOME_STOCK_MENU_PREF         NULL
#define GNOME_STOCK_MENU_SEARCH       NULL

GtkWidget *gnome_popup_menu_new(GnomeUIInfo *uiinfo);
void gnome_popup_menu_attach(GtkWidget *menu, GtkWidget *widget, gpointer data);
void gnome_popup_menu_do_popup(GtkWidget *menu, GtkMenuPositionFunc posfunc, gpointer posdata, GdkEventButton *event, gpointer data);

GtkWidget *gnome_app_new(gchar *id, gchar *title);
void gnome_app_set_contents(GtkWidget *window, GtkWidget *child);

void gnome_app_create_menus_with_data(GtkWidget *window, GnomeUIInfo *uiinfo, gpointer data);

#ifdef STABLE_GTK

/* Try to get this work with GTK 1.0.x... */
#define gtk_editable_get_position(a) (a->current_pos)
#define gtk_window_set_modal(a, b) gtk_grab_add(GTK_WIDGET(a))
#define gtk_scrolled_window_add_with_viewport(a, b) gtk_container_add(GTK_CONTAINER(a), b)
#define g_getenv(a) getenv(a)

#endif

#endif
