/*
 connect.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gmasqdialer.h"

static gboolean disconnect_now = FALSE;
gboolean quit_after_disconnect = FALSE;

static void clear_connection_list(void)
{
    GList *tmp;

    for (tmp = g_list_first(GTK_LIST(GTK_COMBO(combo)->list)->children); tmp != NULL; tmp = tmp->next)
    {
        g_free(gtk_object_get_data(GTK_OBJECT(tmp->data), "name"));
        g_free(gtk_object_get_data(GTK_OBJECT(tmp->data), "info"));
        g_free(gtk_object_get_data(GTK_OBJECT(tmp->data), "addrs"));
        g_free(gtk_object_get_data(GTK_OBJECT(tmp->data), "users"));
    }

    gtk_list_clear_items(GTK_LIST(GTK_COMBO(combo)->list), 0, -1);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), "");
}

static void disconnect(void)
{
    disconnect_now = FALSE;
    mserver_disconnect();

    gtk_timeout_remove(connection_timetag);
    clear_connection_list();
    set_dial_sensitive(FALSE, FALSE);
    set_connection_sensitive(FALSE);

    gtk_statusbar_pop(GTK_STATUSBAR(statusbar), 1);
    gtk_statusbar_push(GTK_STATUSBAR(statusbar), 1, "");
    status_connection_lost();

    if (quit_after_disconnect) gtk_main_quit();
}

static void delete_event(GtkWidget *widget, gpointer data)
{
    quit_after_disconnect = FALSE;
    gtk_widget_destroy(data);
}

static void hangup_yes(GtkWidget *widget, gpointer data)
{
    disconnect();
    gtk_widget_destroy(data);
}

static void callback_clientcount(CALLBACK_DATA *data)
{
    GtkWidget *dialog;
    GtkWidget *label;
#ifndef HAVE_GNOME
    GtkWidget *button;
#endif

    if (data->status == 0 || data->u.digit != 1)
    {
        /* Nope, not the last client (or old server which didn't understand..) */
        disconnect();
        return;
    }

#ifdef HAVE_GNOME
    dialog = gnome_dialog_new(_("Disconnecting.."), GNOME_STOCK_BUTTON_OK, GNOME_STOCK_BUTTON_CANCEL, NULL);
    gnome_dialog_button_connect(GNOME_DIALOG(dialog), 0,
                                GTK_SIGNAL_FUNC(hangup_yes), dialog);
    gnome_dialog_button_connect(GNOME_DIALOG(dialog), 1,
                                GTK_SIGNAL_FUNC(delete_event), dialog);
#else
    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(dialog), 5);

    button = gtk_button_new_with_label(_("OK"));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(hangup_yes), dialog);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 10);

    button = gtk_button_new_with_label(_("Cancel"));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
                       GTK_SIGNAL_FUNC(delete_event), dialog);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 10);
#endif
    label = gtk_label_new(_("The server will close internet connection if you quit\nDo you really want to do this?"));
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);

    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    gtk_widget_show_all(dialog);
}

static void callback_disconnectstatus(CALLBACK_DATA *data)
{
    /* If server is set to hang up after last client is disconnected, ask
       if user REALLY wants to disconnect ... */

    disconnect_now = FALSE;
    if (!lastone_hangup || data->status == 0 || data->u.connection.connection == NULL)
	disconnect();
    else
        mserver_clientcount(callback_clientcount);
}

void menu_disconnect(void)
{
    if (disconnect_now)
    {
	/* Connection lost, disconnect immediately */
	disconnect();
	return;
    }

    disconnect_now = TRUE;
    mserver_status(callback_disconnectstatus);
}
