/*
 * edit.h: header for edit.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: edit.h,v 1.6 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _EDIT_H_
#define _EDIT_H_

#include "irc_std.h"

/* flags used by e_away */
#define AWAY_ONE 0
#define AWAY_ALL 1

/* flags used by parse_line */
#define SECURITY_NO_VARIABLE_COMMAND	1
#define SECURITY_NO_NONINTERACTIVE_EXEC 2
#define SECURITY_NO_NONINTERACTIVE_SET	4

/* flags used by e_who */
#define WHO_OPS		0x0001
#define WHO_NAME	0x0002
#define WHO_ZERO	0x0004
#define WHO_CHOPS	0x0008
#define WHO_FILE	0x0010
#define WHO_HOST	0x0020
#define WHO_SERVER	0x0040
#define	WHO_HERE	0x0080
#define	WHO_AWAY	0x0100
#define	WHO_NICK	0x0200
#define	WHO_LUSERS	0x0400
#define	WHO_REAL	0x0800

extern	char	*sent_nick;
extern	char	*sent_body;
extern	char	*recv_nick;


/* commands and functions in edit.c that are used outside of edit.c */
extern  int	check_wait_command _((char *));
extern	void 	edit_char _((u_char));
extern	void	ExecuteTimers _((void));
extern	void	ison_ison _((char *, char *));
extern	void	oh_my_wait _((void));
extern	int	parse_command _((char *, int, char *));
extern	void	parse_line _((char *, char *, char *, int, int));
extern	void	destroy_call_stack _((void));
extern	void	panic_dump_call_stack _((void));

extern	void	load _((char *, char *, char *));
extern	void	query _((char *, char *, char *));
extern	void	send_text _((char *, char *, char *, int));
extern  void	e_clear _((char *, char *, char *));
extern	void	e_hostname _((char *, char *, char *));

#endif /* _EDIT_H_ */
