#ifndef DIALOGUES_H
#define DIALOGUES_H

GtkWidget *ConfirmationDialogue;
GtkWidget *ConfirmFrame;
GtkWidget *ConfirmLabel, *ConfirmButtonBox;
GtkWidget *ConfirmOk, *ConfirmCancel;

typedef struct _yesNoCancel {
    GtkWidget *Dialogue;
    GtkWidget *Frame;
    GtkWidget *Label, *ButtonBox;
    GtkWidget *Button1, *Button2, *Cancel;
} YesNoCancelInfo;

YesNoCancelInfo YesNoCancel;

GtkWidget *InputDialogue, *InputFrame;
GtkWidget *InputLabel, *InputEntry;
GtkWidget *InputButtonRow, *InputOk, *InputCancel;

GtkWidget *ViewDialogue, *ViewFrame, *ViewTextFrame;
GtkWidget *ViewText, *ViewScrollBar;
GtkWidget *ViewButtonRow, *ViewOk;

char InputBuffer[256];
 void (*ConfirmCallback)(void);
 void (*InputCallback)(const char *);
 void (*YesNoCancelCallback)(int);

void CreateConfirmationDialogue(void);
void CreateYesNoCancelDialogue(void);
void CreateInputDialogue(void);
void CreateViewDialogue(void);

void ConfirmAction(void (*callback)(void), const char *label);
void YesNoCancelShow(void (*callback)(int index),
                     const char *label, const char *text1, const char *text2);
char *GetInput(void (*callback)(const char *), const char *label,
               const char *entry_text);
void ViewFile(const char *file);

#endif
