/*
 * Copyright (C) 1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include "config.h"
#include "setup.h"
#define TIMER_INTERNAL_ACCESS
#ifdef STDC_HEADERS
# include <stdlib.h>
#else
# ifdef HAVE_MALLOC_H
#  include <malloc.h>
# endif
#endif
#include "list.h"
#include "connection.h"
#include "eventlog.h"
#include "timer.h"


static t_list * timerlist_head=NULL;


extern int timerlist_add_timer(t_connection * owner, time_t when, t_timer_cb cb, t_timer_data data)
{
    t_timer * timer;
    
    if (!owner)
    {
	eventlog(eventlog_level_error,"timerlist_all_events","got NULL owner");
	return -1;
    }
    
    if (!(timer = malloc(sizeof(t_timer))))
    {
	eventlog(eventlog_level_error,"timerlist_add_events","could not allocate memory for timer");
	return -1;
    }
    timer->owner = owner;
    timer->when  = when;
    timer->cb    = cb;
    timer->data  = data;
    
    /* We have to be careful here. Prepending can cause problems if a callback
       adds timers back into the list, and appending can make infinite loops
       possible. As long as nobody sets timers in the past we should be ok. */
    if (list_append_item(&timerlist_head,timer)<0)
    {
	pfree(timer,sizeof(t_timer));
	eventlog(eventlog_level_error,"timerlist_add_events","could not prepend temp");
	return -1;
    }
    
    return 0;
}


extern int timerlist_del_all_timers(t_connection * owner)
{
    t_list * * curr;
    t_timer *  timer;
    
    if (!owner)
    {
	eventlog(eventlog_level_error,"timerlist_del_all_events","got NULL owner");
	return -1;
    }
    
    for (curr=&timerlist_head; *curr; )
    {
	timer = list_get_item(*curr);
	if (!timer) /* should not happen */
	{
	    eventlog(eventlog_level_error,"timerlist_del_all_events","timerlist contains NULL item");
	    return -1;
	}
	if (timer->owner==owner)
	    if (list_remove(curr)<0)
	    {
		eventlog(eventlog_level_error,"timerlist_del_all_events","could not remove item");
		timer->owner = NULL;
	    }
	    else
	    {
		pfree(timer,sizeof(t_timer));
		continue; /* curr is already the next item */
	    }
	curr = list_get_next(*curr);
    }
    
    return 0;
}


extern int timerlist_check_timers(time_t when)
{
    t_list * * curr;
    t_timer *  timer;
    
    for (curr=&timerlist_head; *curr; )
    {
	timer = list_get_item(*curr);
	if (!timer) /* should not happen */
	{
	    eventlog(eventlog_level_error,"timerlist_check_timers","timerlist contains NULL item");
	    return -1;
	}
	if (timer->owner && timer->when<when)
	{
	    if (timer->cb)
		timer->cb(timer->owner,timer->when,timer->data);
	    if (list_remove(curr)<0)
	    {
		eventlog(eventlog_level_error,"timerlist_check_timers","could not remove item");
		timer->owner = NULL;
	    }
	    else
	    {
		pfree(timer,sizeof(t_timer));
		continue; /* curr is already the next item */
	    }
	}
	curr = list_get_next(*curr);
    }
    
    return 0;
}

