/*
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 * Copyright (C) 1999  Rob Crittenden (rcrit@greyoak.com)
 * Copyright (C) 1999  Mark Baysinger (mbaysing@ucsd.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_PREFS_TYPES
#define INCLUDED_PREFS_TYPES

#ifdef PREFS_INTERNAL_ACCESS
typedef enum
{
    conf_type_none,
    conf_type_int,
    conf_type_char,
    conf_type_bool
} conf_type_t;

typedef struct
{
    char const * directive;
    conf_type_t  type;
    char const * defcharval;
    unsigned int defintval; /* shared with bool */
    char const * charval;
    unsigned int intval;  /* shared with bool */
} Bconf_t;
#endif

#endif


#ifndef JUST_NEED_PROTOS
#ifndef INCLUDED_PREFS_PROTOS
#define INCLUDED_PREFS_PROTOS

extern char const * preffile;

extern int prefs_load(char const * filename);
extern void prefs_unload(void);
extern char const * prefs_get_userdir(void);
extern char const * prefs_get_filedir(void);
extern char const * prefs_get_logfile(void);
extern char const * prefs_get_loglevels(void);
extern char const * prefs_get_defacct(void);
extern char const * prefs_get_motdfile(void);
extern char const * prefs_get_newsfile(void);
extern char const * prefs_get_adfile(void);
extern unsigned int prefs_get_gameport(void);
extern unsigned int prefs_get_testport(void);
extern unsigned int prefs_get_user_sync_timer(void);
extern unsigned int prefs_get_user_flush_timer(void);
extern unsigned int prefs_get_track(void);
extern char const * prefs_get_location(void);
extern char const * prefs_get_description(void);
extern char const * prefs_get_url(void);
extern char const * prefs_get_contact_name(void);
extern char const * prefs_get_contact_email(void);
extern unsigned int prefs_get_latency(void);
extern unsigned int prefs_get_shutdown_delay(void);
extern unsigned int prefs_get_shutdown_decr(void);
extern unsigned int prefs_get_allow_new_accounts(void);
extern unsigned int prefs_get_kick_old_login(void);
extern char const * prefs_get_channelfile(void);
extern unsigned int prefs_get_ask_new_channel(void);
extern unsigned int prefs_get_hide_pass_games(void);
extern unsigned int prefs_get_hide_temp_channels(void);
extern char const * prefs_get_gametrans(void);
extern unsigned int prefs_get_extra_commands(void);
extern char const * prefs_get_reportdir(void);
extern unsigned int prefs_get_report_all_games(void);
extern char const * prefs_get_pidfile(void);
extern char const * prefs_get_iconfile(void);
extern char const * prefs_get_tosfile(void);
extern unsigned int prefs_get_allow_autoupdate(void);
extern char const * prefs_get_mpqfile(void);
extern unsigned int prefs_get_mpqversion(void);
extern char const * prefs_get_trackserv_addrs(void);
extern char const * prefs_get_bnetdserv_addrs(void);

#endif
#endif
