/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <glib.h>
#include <string.h>

#include "bezerk.h"
#include "dcc.h"
#include "debug.h"

int find_message_entry(GSList *msg_window_list, char *nick)
{
  BezMessageWindow *msg_window;
  GSList *glist_entry;
  int glist_num = 0;

  bs_function_enter();

  glist_entry = msg_window_list;

  while(glist_entry)  {
    msg_window = (BezMessageWindow *) glist_entry->data;
    if (strcasecmp(nick, msg_window->nick) == 0) {
      bs_function_leave();
      return(glist_num);
    }
    glist_entry = g_slist_next(glist_entry);
    glist_num++;
  }
  
  bs_function_leave();
  return(-1);
}

BezMessageWindow *find_message(GSList *msg_window_list, char *nick)
{
  BezMessageWindow *msg_window;
  GSList *glist_entry;
  int glist_num;

  bs_function_enter();

  glist_num = find_message_entry(msg_window_list, nick);

  if (glist_num >= 0) {
    glist_entry = g_slist_nth(msg_window_list, glist_num);
    msg_window = (BezMessageWindow *) glist_entry->data;
    bs_function_leave();
    return(msg_window);
  }
  
  bs_function_leave();
  return(NULL);
}


GSList *remove_message(GSList *message_list, char *nick)
{
  BezMessageWindow *message_window;
  GSList *gslist_entry;
  GList *glist_entry;
  int glist_num;

  bs_function_enter();

  glist_num = find_message_entry(message_list, nick);

  if (glist_num >= 0) {
    gslist_entry = g_slist_nth(message_list, glist_num);
    message_window = (BezMessageWindow *) gslist_entry->data;
    dcc_chat_finish(message_window->nick);
    if (message_window->nick) {
      g_free(message_window->nick);
    }
    if (message_window->incomplete_command) {
      g_free(message_window->incomplete_command);
    }
    message_list = g_slist_remove(message_list, message_window);

    glist_entry = message_window->recall_commands;
    while (glist_entry) {
      g_free(glist_entry->data);
      glist_entry = g_list_next(glist_entry);
    }
    g_list_free(message_window->recall_commands);

    g_free(message_window);
  }
  
  bs_function_leave();
  return(message_list);
}
