/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <fnmatch.h>

#include "icons.h"
#include "images.h"
#include "interface.h"

GtkWidget *xpm_label_box( GtkWidget *parent, char **xpm_filename, gchar *label_text )
{
    GtkWidget *box1;
    GtkWidget *label;
    GtkWidget *pixmapwid;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GtkStyle *style;

    /* Create box for xpm and label */
    box1 = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (box1), 2);
    style = gtk_widget_get_style(parent);
    pixmap = gdk_pixmap_create_from_xpm_d (parent->window, &mask, &style->bg[GTK_STATE_NORMAL], xpm_filename);
    pixmapwid = gtk_pixmap_new (pixmap, mask);
    label = gtk_label_new (label_text);
    gtk_box_pack_start (GTK_BOX (box1),	pixmapwid, FALSE, FALSE, 3);
    gtk_box_pack_start (GTK_BOX (box1), label, FALSE, FALSE, 3);
    gtk_widget_show(pixmapwid);
    gtk_widget_show(label);
    return(box1);
}



void load_icons(/*GtkWidget *window*/)
{
  DIR *dir;
  guchar *home;
  gchar *gtkadc_dir;
  gchar *file = " ";
  struct dirent *fichier;
  int i = 0;
  int nb_pixmaps;
  gchar temp[11];
  FILE *extensions;
  int j = 0;
  gchar *file_path = " ";



  folder_pixmap=gdk_pixmap_create_from_xpm_d((GdkWindow*) window->window,&folder_mask,NULL,folder_xpm);
  ofolder_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&ofolder_mask,NULL,ofolder_xpm);
  diskopen_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&diskopen_mask,NULL,diskopen_xpm);
  diskclose_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&diskclose_mask,NULL,diskclose_xpm);
  file_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&file_mask,NULL,file_xpm); 
  

 

 if ((home = getenv("HOME")) == NULL)
    {
//      rc_initialized = FALSE;
      return;
    }
  gtkadc_dir = g_strdup( home);
  if (gtkadc_dir[strlen(gtkadc_dir) - 1] != '/') gtkadc_dir = g_strconcat(gtkadc_dir,"/",NULL);
  gtkadc_dir = g_strconcat(gtkadc_dir,".gtktalog/icons/",NULL);

  base_pixmap[0] = gdk_pixmap_create_from_xpm_d((GdkWindow*) window->window,&base_mask[0],NULL,folder_xpm);
  base_pixmap[1] = gdk_pixmap_create_from_xpm_d((GdkWindow*) window->window,&base_mask[1],NULL,file_xpm);

  

 if ((dir = opendir(gtkadc_dir)) == NULL)
   {
     printf("Can't find local .gtktalog/icons directory for loading icons. \n Trying in %s.\n", g_strconcat(PREFIX, "/share/gtktalog/icons", NULL));
     gtkadc_dir = g_strconcat(PREFIX, "/share/gtktalog/icons/", NULL);
     
     if ((dir = opendir(gtkadc_dir)) == NULL)
       {
	 printf("Can't find icons directory, will use the default icon.\n");	 
	 return;
       }
   } 
  while((fichier = readdir(dir))!=NULL)
    {
      file = g_strconcat(gtkadc_dir,fichier->d_name,NULL); 
      if ((strcmp(fichier->d_name,".")!=0)&&(strcmp(fichier->d_name,"..")!=0)&&(fnmatch("*.xpm",fichier->d_name, (1 << 4)) == 0))
	{
	  if (i == 0) xpm_list=(gchar **)malloc(sizeof(gchar *));
	  else xpm_list = (gchar **)realloc(xpm_list,(i+1)*sizeof(gchar *));
	  xpm_list[i] = g_strdup(fichier->d_name);
	  i++;
	}
    }
  closedir(dir);
  nb_pixmaps = i;
  i = 0;
  for(i=0;i<nb_pixmaps;i++)
    {
      if (i == 0)
	{
	  pixmap_list=(GdkPixmap **)malloc(sizeof(GdkPixmap *));
	  mask_list=(GdkBitmap **)malloc(sizeof(GdkBitmap *));
	}
      else
	{
	  pixmap_list=(GdkPixmap **)realloc(pixmap_list,(i+1)*sizeof(GdkPixmap *));
	  mask_list=(GdkBitmap **)realloc(mask_list,(i+1)*sizeof(GdkBitmap *));
	} 
      
      file_path = g_strconcat(gtkadc_dir,xpm_list[i],NULL);
      pixmap_list[i]=gdk_pixmap_create_from_xpm((GdkWindow*) window->window,&mask_list[i],NULL,file_path);
      file_path[strlen(gtkadc_dir) + strlen(xpm_list[i]) - 4] ='\0';

      if((extensions = fopen(file_path,"r")) == NULL)
	{
	  printf("Error in:%s\n", file_path);
	  exit;
	}
      else
	{
	  fgets(temp,10,extensions);
	  temp[strlen(temp)-1] = '\0';
	  while(strlen(temp)>2)
	    {
	      if ((strlen(temp)>=3)&&(temp[0] == '*')&&(temp[1] == '.'))
		{
		  if (i == 0)
		    {
		      ext_list=(ext_type *)malloc(sizeof(ext_type));
		    }
		  else
		    {
		      ext_list=(ext_type*)realloc(ext_list,(j+1)*sizeof(ext_type));
		    }
		  ext_list[j].name = g_strdup(temp);
		  ext_list[j].pos = i;
		  j++;
		}
	      fgets(temp,10,extensions);
	      if (strlen(temp) > 0) temp[strlen(temp)-1] = '\0';
	    }
	  fclose(extensions);
	}
    }
  nb_extensions = j;
}
