/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "gstalker.h"
#include <time.h>


/**************************************************************************************
This routine just kills the quote window and updates the flag for it.
**************************************************************************************/
void 
destroy_quotes_window ()
{
  extern GtkWidget *update_quotes_window;
  extern struct record config;

  gtk_widget_destroy (update_quotes_window);
  
  /* don't forget to set the flag status */
  config.quotes_window_open = 0;
}
/**************************************************************************************
This routine adds a new symbol to the symbol list to download, used when you want to
download a new quote not in the database.
**************************************************************************************/
void 
add_quote ()
{
  GtkWidget *dialog;
  gchar *text, *line[4];
  extern gchar *mess_nothing_entered;
  extern GtkWidget *quote_entry, *quotes_clist, *main_window;


  /* get the symbol from the entry widget */
  text = gtk_entry_get_text (GTK_ENTRY (quote_entry));
  if (strlen (text) < 1)
  {
  	/* the entry widget is empty */
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_entered);
	gtk_widget_show(dialog);
	return;
  }

  /* append the new symbol into the list */
  line[0] = text;
  line[1] = NULL;
  line[2] = NULL;
  line[3] = NULL;
  gtk_clist_append (GTK_CLIST (quotes_clist), line);
}
/***************************************************************************************
This routine deletes a symbol selected from the symbol list.
****************************************************************************************/
void 
delete_quote ()
{
  GtkWidget *dialog;
  GList *list;
  gint tint;
  extern GtkWidget *quotes_clist, *main_window;
  extern gchar *mess_nothing_selected;


  /* get the selection from the symbol list */
  list = GTK_CLIST (quotes_clist)->selection;
  if (list)
    {
      /* get the list position and remove the list entry */
      tint = (int) list->data;
      gtk_clist_remove (GTK_CLIST (quotes_clist), tint);
    }
  else
  {
  	/* you didn't select anything from the list */
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }
}
/***************************************************************************************
This routine selects all the symbols in the symbol list.
**************************************************************************************/
void 
select_all_quote ()
{
  extern GtkWidget *quotes_clist;

  gtk_clist_select_all (GTK_CLIST (quotes_clist));
}
/*************************************************************************************
This routine deselects all the symbols in the symbol list.
*************************************************************************************/
void 
unselect_all_quote ()
{
  extern GtkWidget *quotes_clist;

  gtk_clist_unselect_all (GTK_CLIST (quotes_clist));
}
/**************************************************************************************
This routine reads the csv file downloaded from yahoo* and attempts to import the data
into the database. The symbol of the is passed to this routine.
**************************************************************************************/
void 
parse_quotes (gchar *symbol)
{
  glong filesize, tlong, bytecount;
  gfloat tfloat;
  gint tint;
  FILE *infile;
  gchar buffer[1024];
  GString *tstring;
  extern gchar *import_rule_yahoo_us;
  extern struct record config;
  extern GtkWidget *data_bar;


  tstring = g_string_new (NULL);
  
  /* open up the csv file */
  g_string_sprintf (tstring, "%s%s", config.home, "/download.txt");
  infile = fopen (tstring->str, "r");
  if (!infile)
  {
	/* there was no file downloaded, so get the hell out of here */
	g_string_free (tstring, TRUE);
    	return;
  }
  
  tlong = ftell(infile);
  fseek(infile, 0L, SEEK_END);
  filesize = ftell(infile) - tlong;
  bytecount = 0;
  rewind(infile);
  
  /* get the rule for the csv field format */
  g_string_assign (tstring, import_rule_yahoo_us);
  
  gnome_appbar_set_progress (GNOME_APPBAR(data_bar), 0.0);
  
  /* loop through the csv file and import the records */
  while (fgets (buffer, sizeof(buffer), infile) != NULL)
  {
  	tint = strlen (buffer);
  	bytecount = bytecount + tint;
  	if (tint > 0)
  		tint = import_record(tstring, buffer, symbol, 1);
  	
  	/* update the progress bar */  
	  tfloat = ((float) bytecount / filesize);
	  if (tfloat > 1.0)
	    tfloat = 1.0;
	  if (tfloat < 0.0)
	    tfloat = 0.0;
	  gnome_appbar_set_progress (GNOME_APPBAR(data_bar), tfloat);
	  while (gtk_events_pending ())
	  	gtk_main_iteration ();
  }
  	
  fclose (infile);
  gnome_appbar_set_progress (GNOME_APPBAR(data_bar), 0.0);
  g_string_free (tstring, TRUE);
}
/*****************************************************************************************
This routine does the download process.
*****************************************************************************************/
void 
ok_update_quotes ()
{
  FILE *url_file;
  GtkWidget *dialog;
  gfloat tfloat;
  GList *list = NULL;
  gint counter = 1, tint, tint2;
  gchar *text;
  GString *tstring, *syear, *smonth, *sday, *eyear, *emonth, *eday, *url;
  extern gchar *mess_nothing_selected, *yahoo_server, *label_downloading, *label_importing;
  extern gchar *mess_download_complete;
  extern GtkWidget *quotes_clist, *data_bar, *main_window, *quote_date_spinner;
  extern GtkWidget *quote_date_spinner2, *quote_date_spinner3, *quote_date_spinner4;
  extern GtkWidget *quote_date_spinner5, *quote_date_spinner6;
  extern struct record config;
  extern gint chartflag;
  extern GString *current_symbol;



  tstring = g_string_new (NULL);
  url = g_string_new (NULL);
  sday = g_string_new (NULL);
  smonth = g_string_new (NULL);
  syear = g_string_new (NULL);
  eday = g_string_new (NULL);
  emonth = g_string_new (NULL);
  eyear = g_string_new (NULL);
  
  tint = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(quote_date_spinner));
  g_string_sprintf (tstring, "%i", tint);
  g_string_assign (smonth, tstring->str);
  tint = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(quote_date_spinner2));
  g_string_sprintf (tstring, "%i", tint);
  g_string_assign (sday, tstring->str);
  tint = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(quote_date_spinner3));
  g_string_sprintf (tstring, "%i", tint);
  g_string_assign (syear, tstring->str);
  tint = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(quote_date_spinner4));
  g_string_sprintf (tstring, "%i", tint);
  g_string_assign (emonth, tstring->str);
  tint = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(quote_date_spinner5));
  g_string_sprintf (tstring, "%i", tint);
  g_string_assign (eday, tstring->str);
  tint = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(quote_date_spinner6));
  g_string_sprintf (tstring, "%i", tint);
  g_string_assign (eyear, tstring->str);
    
  /* here we loop through all selections in the symbol list and download the data */
  list = GTK_CLIST (quotes_clist)->selection;
  if (list)
    {
      gnome_appbar_set_progress (GNOME_APPBAR(data_bar), 0.0);
      
      /* get the total number of selections */
      tint2 = g_list_length (list);
      
      while (list)
	{
	  /* get the next list selection */
	  tint = (int) list->data;
	  gtk_clist_get_text (GTK_CLIST (quotes_clist), tint, 0, &text);
	  
	  /* update the message bar */
	  g_string_sprintf (tstring, "%s %s...", label_downloading, text);
	  gnome_appbar_set_status (GNOME_APPBAR(data_bar), N_(tstring->str));
	  while (gtk_events_pending ())
	  	gtk_main_iteration ();
	  
	  g_string_sprintf (tstring, "%s%s", config.home, "/wget_urlfile.txt");
	  url_file = fopen (tstring->str, "w");
	  
	  /* create the URL string to send to yahoo's server */
	  g_string_sprintf (tstring, "http://%s/table.csv?s=%s&a=%s&b=%s&c=%s&d=%s&e=%s&f=%s&g=d&q=q&y=0&z=%s&x=.csv\n", yahoo_server, text, smonth->str, sday->str, syear->str, emonth->str, eday->str, eyear->str, text);
	  
	  fputs (tstring->str, url_file);
	  fclose (url_file);
	  
	  /* ok make the call to wget and download */
	  g_string_sprintf (tstring,
	  	"wget --output-document=%s%s --output-file=%s%s --input-file=%s%s --timeout=30 --proxy=on",
	  				config.home, "/download.txt",
	  			    config.home, "/wget_logfile.txt",
	  			    config.home, "/wget_urlfile.txt");
	  			    
	  if (! system (tstring->str))
	  {
	  	g_string_sprintf (tstring, "%s %s...", label_importing, text);
	  	gnome_appbar_set_status (GNOME_APPBAR(data_bar), N_(tstring->str));
	  	while (gtk_events_pending ())
	    		gtk_main_iteration ();
	  	parse_quotes (text);
	  }
	    
	  /* update the progress bar */  
	  tfloat = ((float) counter / tint2);
	  if (tfloat > 1.0)
	    tfloat = 1.0;
	  if (tfloat < 0.0)
	    tfloat = 0.0;
	  gnome_appbar_set_progress (GNOME_APPBAR(data_bar), tfloat);
	  while (gtk_events_pending ())
	  	gtk_main_iteration ();
	    
	  /* move the pointer to the next selection in the list */
	  list = list->next;
	  
	  counter++;
	}
    }
  else
  {
  	/* we are here because nothing was selected for download */
  	dialog = gnome_app_error (GNOME_APP(main_window), mess_nothing_selected);
	gtk_widget_show(dialog);
	return;
  }

  show_chart_list (quotes_clist);
  
  if (chartflag)
  	load_file (current_symbol->str);

  /* we are done downloading, so update the message bar and progress bar */
  gnome_appbar_set_status (GNOME_APPBAR(data_bar), mess_download_complete);
  gnome_appbar_set_progress (GNOME_APPBAR(data_bar), 0.0);
  
  /* clean up */
  g_string_free(tstring, TRUE);
  g_string_free(url, TRUE);
  g_string_free(sday, TRUE);
  g_string_free(smonth, TRUE);
  g_string_free(syear, TRUE);
  g_string_free(eday, TRUE);
  g_string_free(emonth, TRUE);
  g_string_free(eyear, TRUE);
}
/*****************************************************************************************
This routine creates the quotes window.
****************************************************************************************/
void 
show_update_quotes ()
{
  gfloat tfloat;
  struct tm *tm_ptr;
  time_t the_time;
  GtkAdjustment *adj, *adj2, *adj3, *adj4, *adj5, *adj6;
  extern GList *source_list;
  gchar tstring[10], tstring2[5];
  GtkWidget *vbox, *vbox2, *hbox, *hbox2, *hbox3, *hbox6, *button, *button2, *frame;
  GtkWidget *hbox4, *frame2, *button4, *button5, *button6, *button7, *hbox5, *swindow;
  GtkWidget *frame3, *frame4, *label, *label2, *label3, *label4, *label5, *label6;
  extern GtkWidget *quotes_clist, *update_quotes_window, *quote_entry, *source_combo;
  extern GtkWidget *quote_date_spinner, *quote_date_spinner2, *quote_date_spinner6;
  extern GtkWidget *quote_date_spinner3, *quote_date_spinner4, *quote_date_spinner5;
  extern struct record config;
  extern gchar *label_update_quotes, *label_start, *label_end, *label_symbol, *label_name;
  extern gchar *label_download, *label_select, *label_unselect, *label_delete, *label_cancel;
  extern gchar *label_quote_source, *label_add_symbol, *label_add, *label_mm, *label_dd;
  extern gchar *label_yy;
  


  if (config.quotes_window_open)
	return;
  else
  {

	  update_quotes_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	  gtk_signal_connect (GTK_OBJECT (update_quotes_window), "destroy",
			      GTK_SIGNAL_FUNC (destroy_quotes_window), NULL);
	  gtk_window_position (GTK_WINDOW (update_quotes_window), GTK_WIN_POS_CENTER);
	  gtk_window_set_title (GTK_WINDOW (update_quotes_window), label_update_quotes);
	  gtk_widget_set_usize (GTK_WIDGET (update_quotes_window), 0, 400);

	  hbox = gtk_hbox_new (FALSE, 10);
	  gtk_container_add (GTK_CONTAINER (update_quotes_window), hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
	  gtk_widget_show (hbox);

	  vbox = gtk_vbox_new (FALSE, 10);
	  gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
	  gtk_widget_show (vbox);

	  vbox2 = gtk_vbutton_box_new ();
	  gtk_container_border_width (GTK_CONTAINER (vbox2), 5);
	  gtk_box_pack_start (GTK_BOX (hbox), vbox2, FALSE, TRUE, 0);
	  gtk_vbutton_box_set_spacing_default (5);
	  gtk_vbutton_box_set_layout_default (GTK_BUTTONBOX_START);
	  gtk_widget_show (vbox2);

	  button = gtk_button_new_with_label (label_download);
	  gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, TRUE, 0);
	  gtk_signal_connect (GTK_OBJECT (button), "clicked",
			      GTK_SIGNAL_FUNC (ok_update_quotes), NULL);
	  gtk_widget_show (button);
	  
	  button4 = gtk_button_new_with_label (label_select);
	  gtk_box_pack_start (GTK_BOX (vbox2), button4, FALSE, TRUE, 0);
	  gtk_signal_connect (GTK_OBJECT (button4), "clicked",
			      GTK_SIGNAL_FUNC (select_all_quote), NULL);
	  gtk_widget_show (button4);

	  button7 = gtk_button_new_with_label (label_unselect);
	  gtk_box_pack_start (GTK_BOX (vbox2), button7, FALSE, TRUE, 0);
	  gtk_signal_connect (GTK_OBJECT (button7), "clicked",
			      GTK_SIGNAL_FUNC (unselect_all_quote), NULL);
	  gtk_widget_show (button7);

	  button6 = gtk_button_new_with_label (label_delete);
	  gtk_box_pack_start (GTK_BOX (vbox2), button6, FALSE, TRUE, 0);
	  gtk_signal_connect (GTK_OBJECT (button6), "clicked",
			      GTK_SIGNAL_FUNC (delete_quote), NULL);
	  gtk_widget_show (button6);

	  button2 = gtk_button_new_with_label (label_cancel);
	  gtk_box_pack_start (GTK_BOX (vbox2), button2, FALSE, TRUE, 0);
	  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
			      GTK_SIGNAL_FUNC (destroy_quotes_window), NULL),
	  gtk_widget_show (button2);

	  hbox5 = gtk_hbox_new (FALSE, 10);
	  gtk_box_pack_start (GTK_BOX (vbox), hbox5, FALSE, TRUE, 0);
	  gtk_widget_show (hbox5);

	  frame = gtk_frame_new (label_quote_source);
	  gtk_box_pack_start (GTK_BOX (hbox5), frame, FALSE, TRUE, 0);
	  gtk_widget_show (frame);

	  source_combo = gtk_combo_new ();
	  gtk_combo_set_popdown_strings (GTK_COMBO (source_combo), source_list);
	  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (source_combo)->entry), config.source);
	  gtk_container_add (GTK_CONTAINER (frame), source_combo);
	  gtk_container_border_width (GTK_CONTAINER (source_combo), 5);
	  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (source_combo)->entry), "Yahoo-US");
	  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (source_combo)->entry), FALSE);
	  gtk_widget_show (source_combo);

	  frame2 = gtk_frame_new (label_add_symbol);
	  gtk_box_pack_start (GTK_BOX (hbox5), frame2, FALSE, TRUE, 0);
	  gtk_widget_show (frame2);

	  hbox4 = gtk_hbox_new (FALSE, 10);
	  gtk_container_add (GTK_CONTAINER (frame2), hbox4);
	  gtk_container_border_width (GTK_CONTAINER (hbox4), 5);
	  gtk_widget_show (hbox4);

	  quote_entry = gtk_entry_new ();
	  gtk_box_pack_start (GTK_BOX (hbox4), quote_entry, TRUE, TRUE, 0);
	  gtk_widget_show (quote_entry);

	  button5 = gtk_button_new_with_label (label_add);
	  gtk_box_pack_start (GTK_BOX (hbox4), button5, TRUE, TRUE, 0);
	  gtk_signal_connect (GTK_OBJECT (button5), "clicked",
			      GTK_SIGNAL_FUNC (add_quote), NULL);
	  gtk_widget_show (button5);
	  
	  hbox2 = gtk_hbox_new (FALSE, 10);
	  gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, TRUE, 0);
  	  gtk_widget_show (hbox2);
	  
	  frame3 = gtk_frame_new (label_start);
  	  gtk_box_pack_start (GTK_BOX (hbox2), frame3, FALSE, TRUE, 0);
  	  gtk_container_border_width (GTK_CONTAINER (frame3), 0);
  	  gtk_widget_show (frame3);
  
  	  frame4 = gtk_frame_new (label_end);
  	  gtk_box_pack_start (GTK_BOX (hbox2), frame4, FALSE, TRUE, 0);
  	  gtk_container_border_width (GTK_CONTAINER (frame4), 0);
  	  gtk_widget_show (frame4);
  
  	  adj = (GtkAdjustment *) gtk_adjustment_new (1, 1, 12, 1, 5, 0);
  	  adj2 = (GtkAdjustment *) gtk_adjustment_new (1, 1, 31, 1, 5, 0);
  	  adj3 = (GtkAdjustment *) gtk_adjustment_new (1, 1, 99, 1, 5, 0);
  	  adj4 = (GtkAdjustment *) gtk_adjustment_new (1, 1, 12, 1, 5, 0);
  	  adj5 = (GtkAdjustment *) gtk_adjustment_new (1, 1, 31, 1, 5, 0);
  	  adj6 = (GtkAdjustment *) gtk_adjustment_new (1, 1, 99, 1, 5, 0);
	  
  	  hbox3 = gtk_hbox_new (FALSE, 5);
  	  gtk_container_add (GTK_CONTAINER (frame3), hbox3);
  	  gtk_container_border_width (GTK_CONTAINER (hbox3), 5);
  	  gtk_widget_show (hbox3);
	  
  	  label = gtk_label_new (label_mm);
  	  gtk_box_pack_start (GTK_BOX (hbox3), label, TRUE, TRUE, 0);
  	  gtk_widget_show (label);
  
  	  quote_date_spinner = gtk_spin_button_new(adj ,0, 0);
  	  gtk_box_pack_start (GTK_BOX (hbox3), quote_date_spinner, TRUE, TRUE, 0);
  	  gtk_widget_show(quote_date_spinner);
  
  	  label2 = gtk_label_new (label_dd);
  	  gtk_box_pack_start (GTK_BOX (hbox3), label2, TRUE, TRUE, 0);
  	  gtk_widget_show (label2);
  
  	  quote_date_spinner2 = gtk_spin_button_new(adj2 ,0, 0);
  	  gtk_box_pack_start (GTK_BOX (hbox3), quote_date_spinner2, TRUE, TRUE, 0);
  	  gtk_widget_show(quote_date_spinner2);
  
  	  label3 = gtk_label_new (label_yy);
  	  gtk_box_pack_start (GTK_BOX (hbox3), label3, TRUE, TRUE, 0);
  	  gtk_widget_show (label3);
  
  	  quote_date_spinner3 = gtk_spin_button_new(adj3 ,0, 0);
  	  gtk_box_pack_start (GTK_BOX (hbox3), quote_date_spinner3, TRUE, TRUE, 0);
  	  gtk_widget_show(quote_date_spinner3);
	  
  	  hbox6 = gtk_hbox_new (FALSE, 5);
  	  gtk_container_add (GTK_CONTAINER (frame4), hbox6);
  	  gtk_container_border_width (GTK_CONTAINER (hbox6), 5);
  	  gtk_widget_show (hbox6);
  
  	  label4 = gtk_label_new (label_mm);
  	  gtk_box_pack_start (GTK_BOX (hbox6), label4, TRUE, TRUE, 0);
  	  gtk_widget_show (label4);
	  
  	  quote_date_spinner4 = gtk_spin_button_new(adj4 ,0, 0);
  	  gtk_box_pack_start (GTK_BOX (hbox6), quote_date_spinner4, TRUE, TRUE, 0);
  	  gtk_widget_show(quote_date_spinner4);
  
  	  label5 = gtk_label_new (label_dd);
  	  gtk_box_pack_start (GTK_BOX (hbox6), label5, TRUE, TRUE, 0);
  	  gtk_widget_show (label5);
  
  	  quote_date_spinner5 = gtk_spin_button_new(adj5, 0, 0);
  	  gtk_box_pack_start (GTK_BOX (hbox6), quote_date_spinner5, TRUE, TRUE, 0);
  	  gtk_widget_show(quote_date_spinner5);
  
  	  label6 = gtk_label_new (label_yy);
  	  gtk_box_pack_start (GTK_BOX (hbox6), label6, TRUE, TRUE, 0);
  	  gtk_widget_show (label6);
  
  	  quote_date_spinner6 = gtk_spin_button_new(adj6, 0, 0);
  	  gtk_box_pack_start (GTK_BOX (hbox6), quote_date_spinner6, TRUE, TRUE, 0);
  	  gtk_widget_show(quote_date_spinner6);
  
  	  time (&the_time);
  	  tm_ptr = localtime (&the_time);
  	  strftime (tstring, 9, "%Y%m%d", tm_ptr);
  	  tstring2[0] = tstring[4];
  	  tstring2[1] = tstring[5];
  	  tstring2[2] = 0;
  	  tfloat = atof(tstring2);
  	  gtk_spin_button_set_value (GTK_SPIN_BUTTON(quote_date_spinner4), tfloat);
  	  gtk_spin_button_set_value (GTK_SPIN_BUTTON(quote_date_spinner), tfloat);
  
  	  tstring2[0] = tstring[6];
  	  tstring2[1] = tstring[7];
  	  tstring2[2] = 0;
  	  tfloat = atof(tstring2);
  	  gtk_spin_button_set_value (GTK_SPIN_BUTTON(quote_date_spinner5), tfloat);
  	  gtk_spin_button_set_value (GTK_SPIN_BUTTON(quote_date_spinner2), tfloat);
  
  	  tstring2[0] = tstring[2];
  	  tstring2[1] = tstring[3];
  	  tstring2[2] = 0;
  	  tfloat = atof(tstring2);
  	  gtk_spin_button_set_value (GTK_SPIN_BUTTON(quote_date_spinner6), tfloat);
  	  gtk_spin_button_set_value (GTK_SPIN_BUTTON(quote_date_spinner3), tfloat);
	  
	  swindow = gtk_scrolled_window_new(NULL, NULL);
      	  gtk_box_pack_start (GTK_BOX (vbox), swindow, TRUE, TRUE, 0);
      	  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow),
  				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
          gtk_widget_show(swindow);

	  quotes_clist = gtk_clist_new_with_titles (4, NULL);
	  gtk_clist_set_selection_mode (GTK_CLIST (quotes_clist), GTK_SELECTION_MULTIPLE);
	  gtk_clist_set_column_width (GTK_CLIST (quotes_clist), 0, 100);
	  gtk_clist_set_column_width (GTK_CLIST (quotes_clist), 1, 150);
	  gtk_clist_set_column_width (GTK_CLIST (quotes_clist), 2, 80);
	  gtk_clist_set_column_width (GTK_CLIST (quotes_clist), 3, 80);
	  gtk_clist_set_column_justification (GTK_CLIST (quotes_clist), 0, GTK_JUSTIFY_LEFT);
	  gtk_container_add (GTK_CONTAINER (swindow), quotes_clist);
	  gtk_clist_set_column_title (GTK_CLIST(quotes_clist), 0, label_symbol);
	  gtk_clist_set_column_title (GTK_CLIST(quotes_clist), 1, label_name);
	  gtk_clist_set_column_title (GTK_CLIST(quotes_clist), 2, label_start);
	  gtk_clist_set_column_title (GTK_CLIST(quotes_clist), 3, label_end);
  	  gtk_clist_column_titles_show (GTK_CLIST(quotes_clist));
	  gtk_widget_show (quotes_clist);

	  /* fill the symbol list with all the gstalker symbols in the database */
	  show_chart_list (quotes_clist);
	  
	  gtk_widget_show (update_quotes_window);
	  
	  /* update the flag that the quotes window is visible */
	  config.quotes_window_open = 1;
    }
}
