/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */


#include "gstalker.h"



gchar *mess_cant_create_tempfile = N_("Hey! I can't create any temporary files! I'm outta here...");
gchar *mess_cant_create_chart = N_("Hey! I can't create any new chart files! I'm outta here...");
gchar *mess_error_notify = N_("Hey! There were some errors during the import. Check the error log for the details pal.");
gchar *mess_cant_open_errorlog = N_("Hey! I can't open my error log! I'm outta here...");
gchar *mess_cant_open_importfile = N_("Hey! I can't open the file to import! I'm outta here...");
gchar *mess_nothing_selected = N_("You gotta select something first pal...");
gchar *mess_invalid_selection = N_("Nope, try another selection...");
gchar *mess_already_exists = N_("No way, that selection is already there...");
gchar *mess_nothing_entered = N_("You gotta enter something first pal...");
gchar *mess_invalid_entry = N_("Whatever you entered was bogus, try again pal...");
gchar *mess_nothing_selected_edit = N_("You gotta select something to insert first pal...");
gchar *mess_cant_open_group = N_("Whoa! For some reason, I can't open that group...");
gchar *mess_group_empty = N_("The group you selected is empty, there's nothing to see here...");
gchar *mess_cant_open_chart = N_("Hey! For some reason, I can't open that chart...");
gchar *mess_cant_create = N_("Whoa! For some reason, I can't create that file...");
gchar *mess_invalid_date2 = N_("You gotta have at least 8 characters for the date pal...");
gchar *mess_invalid_date3 = N_("You gotta put a date in there first pal...");
gchar *mess_invalid_date4 = N_("The date you entered does not exist in the database, choose another one.");
gchar *mess_data_missing = N_("Hey, my data directory is either empty or mising! That's it, I'm outta here...");
gchar *mess_group_missing = N_("Hey, my group directory is either empty or missing! That's it, I'm outta here...");
gchar *mess_invalid_moving = N_("Whatever you entered for moving average value was bogus, try again pal...");
gchar *mess_invalid_pnc = N_("Whatever you entered for net change was bogus, try again pal...");
gchar *mess_invalid_pvc = N_("Whatever you entered for volume net change was bogus, try again pal...");
gchar *mess_invalid_threshold = N_("Whatever you entered for threshold was bogus, try again pal...");
gchar *mess_delete_confirm = N_("Are you sure you want to delete ");
gchar *mess_invalid_symbol_entry = N_("Invalid symbol entered.");
gchar *mess_scan_alert = N_("Scanning for alerts...");
gchar *mess_alert_scan_complete = N_("Alert scan complete.");
gchar *mess_save_changes = N_("Save changes ?");
gchar *mess_invalid_symbol = N_("invalid symbol field.");
gchar *mess_invalid_name = N_("invalid name field.");
gchar *mess_invalid_date = N_("invalid date field.");
gchar *mess_invalid_open = N_("invalid open field.");
gchar *mess_invalid_high = N_("invalid high field.");
gchar *mess_invalid_low = N_("invalid low field.");
gchar *mess_invalid_close = N_("invalid close field.");
gchar *mess_invalid_volume = N_("invalid volume field.");
gchar *mess_invalid_ointerest = N_("invalid open interest field.");
gchar *mess_enter_rule_name = N_("You must enter a name for this rule.");
gchar *mess_enter_date_field = N_("You must have a date field for this rule.");
gchar *mess_enter_close_field =  N_("You must have a close field for this rule.");
gchar *mess_rule_saved = N_("Import rule saved.");
gchar *mess_import_complete = N_("Import complete.");
gchar *mess_select_import_file = N_("Select file to import");
gchar *mess_download_complete = N_("Download complete.");


/*** constant labels ***/
gchar *label_open = N_("Open");
gchar *label_close = N_("Close");
gchar *label_cancel = N_("Cancel");
gchar *label_delete = N_("Delete");
gchar *label_select = N_("Select All");
gchar *label_unselect = N_("Unselect All");
gchar *label_save = N_("Save");
gchar *label_ok = N_("OK");
gchar *label_import = N_("Import");
gchar *label_scan = N_("Scan");
gchar *label_goto_chart = N_("Goto Chart");
gchar *label_date = N_("Date");
gchar *label_high = N_("High");
gchar *label_low = N_("Low");
gchar *label_volume = N_("Volume");
gchar *label_ointerest = N_("Open Interest");
gchar *label_start = N_("Start");
gchar *label_end = N_("End");
gchar *label_symbol = N_("Symbol");
gchar *label_name = N_("Name");
gchar *label_edit = N_("Edit");
gchar *label_insert = N_("Insert");
gchar *label_data = N_("Data");
gchar *label_new = N_("New");
gchar *label_rename = N_("Rename");
gchar *label_ignore = N_("Ignore");
gchar *label_jan = N_("Jan");
gchar *label_feb = N_("Feb");
gchar *label_mar = N_("Mar");
gchar *label_apr = N_("Apr");
gchar *label_may = N_("May");
gchar *label_jun = N_("Jun");
gchar *label_jul = N_("Jul");
gchar *label_aug = N_("Aug");
gchar *label_sep = N_("Sep");
gchar *label_oct = N_("Oct");
gchar *label_nov = N_("Nov");
gchar *label_dec = N_("Dec");
gchar *label_f = N_("F");
gchar *label_m = N_("M");
gchar *label_a = N_("A");
gchar *label_j = N_("J");
gchar *label_s = N_("S");
gchar *label_o = N_("O");
gchar *label_n = N_("N");
gchar *label_d = N_("D");
gchar *label_ma = N_("MA");
gchar *label_ma2 = N_("MA 2");
gchar *label_ma3 = N_("MA 3");
gchar *label_ma_gt_close = N_("MA => Close");
gchar *label_ma2_gt_close = N_("MA 2 => Close");
gchar *label_ma3_gt_close = N_("MA 3 => Close");
gchar *label_ma_lt_close = N_("MA <= Close");
gchar *label_ma2_lt_close = N_("MA 2 <= Close");
gchar *label_ma3_lt_close = N_("MA 3 <= Close");
gchar *label_closeroc = N_("Close ROC");
gchar *label_threshold = N_("Threshold");
gchar *label_close_gt_threshold = N_("Close >= Threshold");
gchar *label_close_lt_threshold = N_("Close <= Threshold");
gchar *label_close_gt_closeroc = N_("Close >= Closeroc");
gchar *label_close_lt_closeroc = N_("Close <= Closeroc");
gchar *label_alerts = N_("Alerts:");
gchar *label_alert_view = N_("Alert View");
gchar *label_edit_alerts = N_("Edit Alerts");
gchar *label_group_scan = N_("Select Groups To Scan");
gchar *label_simple = N_("Simple");
gchar *label_weighted = N_("Weighted");
gchar *label_exponential = N_("Exponential");
gchar *label_data_window = N_("Data Window:");
gchar *label_workwith_charts = N_("Work With Charts");
gchar *label_edit_chart_data = N_("Edit Chart Data");
gchar *label_edit_indicators = N_("Edit Indicators");
gchar *label_indicators = N_("Indicators");
gchar *label_edit_options = N_("Edit Options");
gchar *label_data_bar_fields = N_("Data Bar Fields");
gchar *label_status_bar = N_("Status Bar");
gchar *label_maximum_data_points = N_("Maximum data points");
gchar *label_charts = N_("Charts");
gchar *label_properties = N_("Properties");
gchar *label_background = N_("Background");
gchar *label_borders = N_("Borders");
gchar *label_grid = N_("Grid");
gchar *label_colors = N_("Colors");
gchar *label_new_group_name = N_("Enter new group name for");
gchar *label_new_group = N_("Enter New Group Name");
gchar *label_workwith_groups = N_("Work With Groups");
gchar *label_group_name = N_("Group Name");
gchar *label_edit_group = N_("Edit Group");
gchar *label_edit_rule = N_("Edit Rule");
gchar *label_rule_name = N_("Rule Name");
gchar *label_rule = N_("Rule");
gchar *label_rule_fields = N_("Rule Fields");
gchar *label_importing = N_("Importing");
gchar *label_skipped_line = N_("Skipped line");
gchar *label_enter_import_symbol = N_("Enter symbol for import.");
gchar *label_import_from = N_("Import from");
gchar *label_downloading = N_("Downloading");
gchar *label_update_quotes = N_("Update Quotes");
gchar *label_quote_source = N_("Quote Source");
gchar *label_add_symbol = N_("Add Symbol");
gchar *label_add = N_("Add");
gchar *label_mm = N_("MM");
gchar *label_dd = N_("DD");
gchar *label_yy = N_("YY");
gchar *label_download = N_("Download");


/*** flags,  0=off, 1=on ***/
gint chartflag = 0;		/* chart currently displayed */
gint open_file_flag = 0;		/* if a group is not currently loaded */
gint edit_chart_save_flag = 0;	/* on = change has been made to the data */
gint edit_options_save_flag = 0;	/* on = change has been made to the data */
gint edit_options_flag = 0;	/* on = the edit options window is visible */
gint header_changed = 0; /* this flag signals if any chart stats were updated */
gint import_rule_save_flag = 0; /* 1 = an import rule has been changed without saving */
gint import_current_rule = 0; /* the clist # of the rule being edited */


/*** int ***/
gint global_int, global_int2, global_int3, global_int4;	/* global scratch variables */
gint current_records; /* the total # of records of the displayed chart */
gint edit_records; /* the total number of records being edited */
gint current_line_pixelspace; /* the current pixel spacing for the line style */
gint current_ohlc_pixelspace; /* the current pixel spacing for the ohlc style */
gint grow, gcol; /* global variables used for row and col positions used by various routines */
gint array_size; /* used by weekly and monthly charts only for records in the chart arrays */


/*** char ***/
GString *gstring;	/* global scratch string */
GString *lastdir;			/* last directory used */
GString *error_message;		/* pointer to error message */
GString *edit_groupfilename;	/* filename of the group being edited */
GString *date_alert;		/* storage for date string when alert scans being done */
GString *edit_symbol;		/* filename of the chart being edited */
GString *current_symbol; /* symbol of the chart currently displayed */
GString *current_name; /* name of the current chart displayed */
GString *current_first_date; /* first date if the chart displyed in YYYYMMDD */
GString *current_last_date; /* last date if the chart displyed in YYYYMMDD */
GString *current_file_type; /* the type of the current chart displayed */
gchar *yahoo_server = "chart.yahoo.com"; /* base yahoo URL */
gchar *data_file = "/tmp/quotes.csv"; /* downloaded quote file path */
gchar *authors[] = {"Stefan S Stratigakos", NULL}; /* authors array used in the about box */
gchar *import_rule_yahoo_us = "Date,Open,High,Low,Close,Volume"; /* import rule field format */


/*** long ***/
gulong volume_high = 0;	/* highest volume in chart */


/*** float ***/
gfloat maxhigh;			/* highest trading price for chart */
gfloat maxlow;			/* lowest trading price for chart */
gfloat range;			/* the difference between maxhigh and maxlow */
gfloat current_threshold; /* the current threshold alert setting */

/*** lists ***/
GList *moving_type_list = NULL;	/* moving type list */
GList *source_list = NULL;	/* quote source list */
GList *currency_list = NULL;	/* currency list */

/*** date ***/
GDate *gdate;

/*** structs ***/
struct record config;
struct old_header oheader;
struct old_data odata;
gint config_size = sizeof (struct record); /* the size of the config file in memory */

/*** arrays ***/
GArray *date_array; /* where we keep all the dates of the current chart */
GArray *open_array; /*   "    "   "   "   "  open values "   "     " */
GArray *high_array; /*   "    "   "   "   "  high values "   "     " */
GArray *low_array; /*   "    "   "   "   "  low values "   "     " */
GArray *close_array; /*   "    "   "   "   "  close values "   "     " */
GArray *volume_array; /*   "    "   "   "   "  volume values "   "     " */
GArray *openint_array; /*   "    "   "   "   "  open interest values "   "     " */
GArray *ma_array; /*   "    "   "   "   "  moving average values "   "     " */
GArray *ma2_array; /*   "    "   "   "   "  moving2 average values "   "     " */
GArray *ma3_array; /*   "    "   "   "   "  moving3 average values "   "     " */
GPtrArray *group_array; /* where we keep the symbols for the current group loaded */

/*** widgets that need to be global for all functions ***/
GtkWidget *main_window;
GtkWidget *message_window;
GtkWidget *data_window;
GtkWidget *data_window_clist;
GtkWidget *alert_window;
GtkWidget *alert_window_clist;
GtkWidget *ticker_combo_box;
GdkPixmap *chart_pixmap = NULL, *scale_pixmap = NULL;
GtkWidget *chart, *scale;
GtkWidget *data_frame;
GtkWidget *scrolled_win;
GtkWidget *info_frame;
GtkWidget *info_bar;
GtkWidget *data_bar;
GtkWidget *openfile;


/*** workwith groups window ***/
GtkWidget *workwith_groups_window, *workwith_groups_clist;

/*** rename group window ***/
GtkWidget *rename_group_window, *rename_group_value_entry, *rename_group_old_entry;

/*** edit group window ***/
GtkWidget *edit_group_window, *edit_group_clist, *edit_group_clist2;

/*** edit indicator window ***/
GtkWidget *edit_indicator_window;
GtkWidget *ei_ma_check, *ei_ma2_check, *ei_ma3_check, *ei_ma_combo, *ei_ma2_combo;
GtkWidget *ei_ma3_combo, *ei_ma_spinner, *ei_ma2_spinner, *ei_ma3_spinner;

/*** show indicator2 window ***/
GtkWidget *edit_indicator2_window, *edit_indicator2_entry, *indicator_type_combo;

/*** new indicator window ***/
GtkWidget *new_indicator_window, *new_indicator_clist;

/*** edit alerts window ***/
GtkWidget *edit_alerts_window, *ea_ma_check, *ea_ma2_check, *ea_ma3_check;
GtkWidget *ea_ma_label, *ea_ma2_label, *ea_ma3_label, *ea_closeroc_spinner;
GtkWidget *ea_threshold_spinner, *ea_closeroc_check;
GtkWidget *ea_threshold_check, *ea_hbox2, *ea_hbox3, *ea_hbox4;

/*** edit options window ***/
GtkWidget *edit_options_window, *enable_date_check;
GtkWidget *enable_open_check, *enable_high_check, *enable_low_check;
GtkWidget *enable_close_check, *enable_volume_check, *enable_openi_check;
GtkWidget *bars_value_entry, *object_combo, *color_clist;
GtkWidget *cb_background, *cb_borders, *cb_grid, *cb_ma1, *cb_ma2, *cb_ma3;
GtkWidget *cb_price, *cb_volume, *currency_combo;

/*** goto chart window ***/
GtkWidget *goto_chart_window, *goto_chart_clist;

/*** workwith charts window ***/
GtkWidget *workwith_charts_window, *workwith_charts_clist;

/*** edit chart window ***/
GtkWidget *edit_chart_open_value_entry, *edit_chart_high_value_entry, *edit_chart_low_value_entry;
GtkWidget *edit_chart_close_value_entry, *edit_chart_clist;
GtkWidget *edit_chart_openi_value_entry, *edit_chart_date, *edit_chart_name_value_entry;
GtkWidget *edit_chart_window, *edit_chart_data_value;

/*** edit goto window ***/
GtkWidget *edit_goto_window, *edit_goto_entry;

/*** alert scan window ***/
GtkWidget *alert_scan_window, *alert_scan_clist, *alert_scan_check;

/*** import_window ***/
GtkWidget *import_window, *import_file_label, *import_rules_clist;


/*** update quotes window ***/
GtkWidget *update_quotes_window, *quotes_clist, *quote_entry, *source_combo;

/*** color selection ***/
GtkWidget *colorseldlg, *colorsel;

/*** file selector ***/
GtkWidget *fs;

/*** quote date window ***/
GtkWidget *quote_date_window, *quote_date_spinner, *quote_date_spinner2, *quote_date_spinner3;
GtkWidget *quote_date_spinner4, *quote_date_spinner5, *quote_date_spinner6;

/*** import edit rule window ***/
GtkWidget *import_edit_rule_window, *import_rule_name, *import_rule, *import_edit_rule_clist;
GtkWidget *import_rule_field_clist;


/* pulldown menu array for File */
GnomeUIInfo file_menu[] =
{
  {GNOME_APP_UI_ITEM, N_("_New Group..."), N_("Create a new group."),
   new_group, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
   'n', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ITEM, N_("Work With _Groups..."), N_("Open, edit, delete a group."),
 workwith_groups, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
   'g', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ITEM, N_("Work With _Charts..."), N_("Open, edit, delete a chart."),
 workwith_charts, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
   'c', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_SEPARATOR, NULL},

{GNOME_APP_UI_ITEM, N_("I_mport Data..."), N_("Import data to gstalker."),
import_options, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CONVERT,
 'm', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_SEPARATOR, NULL},

  {GNOME_APP_UI_ITEM, N_("_Quit"), N_("Quit gstalker."),
   exit_program, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
   'q', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ENDOFINFO, NULL} 
};

/* pulldown menu array for Edit */
GnomeUIInfo edit_menu[] =
{
  {GNOME_APP_UI_ITEM, N_("Edit Chart _Indicators..."), N_("Edit indicator properties."),
   edit_indicators, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
   'i', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ITEM, N_("Edit _Alerts..."), N_("Edit alert properties."),
edit_alerts, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
   'a', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ITEM, N_("Edit Pre_ferences..."), N_("Edit preferences."),
   edit_options, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
   'f', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ENDOFINFO, NULL}
};


/* pulldown menu array for View */
GnomeUIInfo view_menu[] =
{
  {GNOME_APP_UI_ITEM, N_("_Expand Chart"), N_("Increase chart density."),
   expand_chart, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FIRST,
   'e', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ITEM, N_("Compres_s Chart"), N_("Reduce chart density."),
   shrink_chart, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_LAST,
   's', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_SEPARATOR, NULL},

  {GNOME_APP_UI_ITEM, N_("_Previous Chart"), N_("Display the previous chart."),
   previous_chart, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK,
   'p', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ITEM, N_("Ne_xt Chart"), N_("Display the next chart."),
   next_chart, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
   'x', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_SEPARATOR, NULL},

  {GNOME_APP_UI_ITEM, N_("_Line Style"), N_("Display line chart style."),
   style_button_pressed, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXEC,
   'l', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ITEM, N_("_OHLC Style"), N_("Display OHLC chart style."),
   style_button_pressed, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXEC,
   'o', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ITEM, N_("Grid"), N_("Display the chart grid."),
   toggle_grid, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
   0, GDK_CONTROL_MASK, NULL},
   
  {GNOME_APP_UI_ITEM, N_("Chart Compression"), N_("Daily, weekly and monthly date compression."),
   set_chart_type, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CONVERT,
   'w', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_SEPARATOR, NULL},

  {GNOME_APP_UI_ITEM, N_("_Volume Indicator"), N_("Display the volume indicator."),
   toggle_volume, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_VOLUME,
   'v', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_SEPARATOR, NULL},

  {GNOME_APP_UI_ITEM, N_("_Data Window"), N_("Display the data window."),
   show_data_window, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
   'd', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_SEPARATOR, NULL},

  {GNOME_APP_UI_ITEM, N_("Goto Char_t..."), N_("Goto chart in current group."),
   goto_chart, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_JUMP_TO,
   't', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ENDOFINFO, NULL}
};


/* pulldown menu array for Tools */
GnomeUIInfo tools_menu[] =
{
  {GNOME_APP_UI_ITEM, N_("Ale_rt Scan..."), N_("Perform an alert scan."),
   alert_scan, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
   'r', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ITEM, N_("_Update Quotes..."), N_("Retrieve quotes from the WWW."),
   show_update_quotes, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_MAIL_RCV,
   'u', GDK_CONTROL_MASK, NULL},

  {GNOME_APP_UI_ENDOFINFO, NULL}
};


/* pulldown menu array for Help */
GnomeUIInfo help_menu[] =
{
  {GNOME_APP_UI_ITEM, N_("A_bout..."), N_("About gstalker."),
   about, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
   'b', GDK_CONTROL_MASK, NULL},

  GNOMEUIINFO_HELP ("gstalker"),

  GNOMEUIINFO_END
};

/* main pulldown menu array */
GnomeUIInfo main_menu[] =
{
  GNOMEUIINFO_SUBTREE (N_("_File"), file_menu),
  GNOMEUIINFO_SUBTREE (N_("_Edit"), edit_menu),
  GNOMEUIINFO_SUBTREE (N_("_View"), view_menu),
  GNOMEUIINFO_SUBTREE (N_("_Tools"), tools_menu),
  GNOMEUIINFO_SUBTREE (N_("_Help"), help_menu),
  GNOMEUIINFO_END
};


/* toolbar array */
GnomeUIInfo toolbar[] =
{
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Workwith Groups"), workwith_groups, GNOME_STOCK_PIXMAP_OPEN),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Workwith Charts"), workwith_charts, GNOME_STOCK_PIXMAP_NEW),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Previous Chart"), previous_chart, GNOME_STOCK_PIXMAP_BACK),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Goto Chart"), goto_chart, GNOME_STOCK_PIXMAP_JUMP_TO),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Next Chart"), next_chart, GNOME_STOCK_PIXMAP_FORWARD),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Compress Chart"), shrink_chart, GNOME_STOCK_PIXMAP_FIRST),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Expand Chart"), expand_chart, GNOME_STOCK_PIXMAP_LAST),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Edit Indicators"), edit_indicators,
  				  GNOME_STOCK_PIXMAP_PROPERTIES),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Edit Alerts"), edit_alerts, GNOME_STOCK_PIXMAP_PROPERTIES),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Alert Scan"), alert_scan, GNOME_STOCK_PIXMAP_SEARCH),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Download Quotes"), show_update_quotes,
  				  GNOME_STOCK_PIXMAP_MAIL_RCV),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Data Window"), show_data_window, GNOME_STOCK_PIXMAP_INDEX),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Toggle Grid"), toggle_grid, GNOME_STOCK_PIXMAP_TABLE_FILL),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Toggle Chart Style"), style_button_pressed,
  				  GNOME_STOCK_PIXMAP_EXEC),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Toggle Volume"), toggle_volume, GNOME_STOCK_PIXMAP_VOLUME),
  GNOMEUIINFO_ITEM_STOCK (NULL, N_("Daily, Weekly, Monthly Chart"), set_chart_type,
  				  GNOME_STOCK_PIXMAP_CONVERT),
  GNOMEUIINFO_END
};
/**********************************************************************************/
gint
main (gint argc, gchar *argv[])
{
  GnomeClient *client;
  GtkWidget *vbox, *vbox2, *hbox;


  /* set up the list moving average types */
  moving_type_list = g_list_append (moving_type_list, label_exponential);
  moving_type_list = g_list_append (moving_type_list, label_simple);
  moving_type_list = g_list_append (moving_type_list, label_weighted);

  /* set up the list of download data sources */
  source_list = g_list_append(source_list, "Yahoo-US");
  source_list = g_list_append(source_list, "Yahoo-SE");
  source_list = g_list_append(source_list, "Yahoo-DE");
  source_list = g_list_append(source_list, "Yahoo-UK");
  source_list = g_list_append(source_list, "Yahoo-IT");
  source_list = g_list_append(source_list, "Yahoo-ES");
  source_list = g_list_append(source_list, "Yahoo-NO");
  source_list = g_list_append(source_list, "Yahoo-FR");
  
  /* set up the list of currencies */
  currency_list = g_list_append(currency_list, "US");
  currency_list = g_list_append(currency_list, "CDN");
  
  
  /* create all the global strings */
  gstring = g_string_new(NULL);
  lastdir = g_string_new(NULL);
  error_message = g_string_new(NULL);
  edit_groupfilename = g_string_new(NULL);
  date_alert = g_string_new(NULL);
  edit_symbol = g_string_new(NULL);
  current_symbol = g_string_new(NULL);
  current_name = g_string_new(NULL);
  current_first_date = g_string_new(NULL);
  current_last_date = g_string_new(NULL);
  current_file_type = g_string_new(NULL);
  
  /* create the global date struct */
  gdate = g_date_new_dmy (1, 1, 1);

  gnome_init ("gstalker", NULL, argc, argv);

  /* set up the gnome client stuff */
  client = gnome_master_client ();
  gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
		      GTK_SIGNAL_FUNC (save_state), NULL);
  gtk_signal_connect (GTK_OBJECT (client), "die",
		      GTK_SIGNAL_FUNC (exit_program), NULL);

  /* read in the config file info */
  get_config ();

  /* check if is a config file */
  if (config.home[0] == 0)
    /* nope, no config file so create a new one and verify gstalker directories */
    new_init ();
  else
    /* yes, so just verify all the gstalker directories */
    init ();


  /* create the gstalker main window */
  main_window = gnome_app_new ("gstalker", "gstalker");
  gtk_widget_realize (main_window);
  gtk_signal_connect (GTK_OBJECT (main_window), "destroy",
			      GTK_SIGNAL_FUNC (exit_program), NULL);

  /* update geometry of the main window */
  gtk_widget_set_uposition (main_window, config.x, config.y);
  gtk_widget_set_usize (main_window, config.w, config.h);
  
  vbox = gtk_vbox_new (FALSE, 0);
  gnome_app_set_contents (GNOME_APP (main_window), vbox);
  gtk_widget_show (vbox);

/*** create the main menu ***/

  gnome_app_create_menus (GNOME_APP (main_window), main_menu);

/*** create the toolbar ***/

  gnome_app_create_toolbar (GNOME_APP (main_window), toolbar);

/**** create info bar ****/

  info_bar = gtk_statusbar_new ();
  gtk_box_pack_start (GTK_BOX (vbox), info_bar, FALSE, TRUE, 0);
  gtk_widget_show (info_bar);

/*** chart area ***/

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);
  
  scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			      	GTK_POLICY_AUTOMATIC, 
			      	GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (hbox), scrolled_win, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (scrolled_win), 0);
  gtk_widget_show (scrolled_win);
      	
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), vbox2);
  gtk_widget_show (vbox2);
      	
  chart = gtk_drawing_area_new();
  gtk_signal_connect (GTK_OBJECT(chart), "expose_event",
  		    (GtkSignalFunc) expose_event, NULL);
  gtk_signal_connect (GTK_OBJECT(chart), "configure_event",
  		    (GtkSignalFunc) configure_event, NULL);		    
  gtk_signal_connect (GTK_OBJECT(chart), "motion_notify_event",
  		    (GtkSignalFunc) motion_notify_event, NULL);
  gtk_signal_connect (GTK_OBJECT(chart), "button_press_event",
  		    (GtkSignalFunc) button_press_event, NULL);
  gtk_widget_set_events (chart, GDK_EXPOSURE_MASK
  		       | GDK_LEAVE_NOTIFY_MASK
  		       | GDK_BUTTON_PRESS_MASK
  		       | GDK_POINTER_MOTION_MASK
  		       | GDK_POINTER_MOTION_HINT_MASK);
  gtk_box_pack_start (GTK_BOX (vbox2), chart, TRUE, TRUE, 0);
  gtk_widget_show(chart);
     	
  scale = gtk_drawing_area_new();
  gtk_signal_connect (GTK_OBJECT(scale), "expose_event",
  		    (GtkSignalFunc) scale_expose_event, NULL);
  gtk_signal_connect (GTK_OBJECT(scale), "configure_event",
  		    (GtkSignalFunc) scale_configure_event, NULL);		    
  gtk_widget_set_events (scale, GDK_EXPOSURE_MASK);
  gtk_widget_set_usize(GTK_WIDGET (scale), WIDTH_OFFSET, 0);
  gtk_box_pack_end (GTK_BOX (hbox), scale, FALSE, FALSE, 0);
  gtk_widget_show(scale);
      	
/*** data_bar setup ***/

  data_bar = gnome_appbar_new (TRUE, TRUE, GNOME_PREFERENCES_NEVER);
  gnome_app_set_statusbar(GNOME_APP(main_window), data_bar);
  gtk_widget_show (data_bar);
  gnome_app_install_menu_hints(GNOME_APP(main_window), main_menu);

  gtk_widget_show (main_window);
  save_state();
  
  /* here we create any windows that were displayed last time gstalker was used */
  if (config.groupfile[0] != 0)
  {
    /* load previous group displayed if there was one */
    load_first_group ();
  }

  gtk_main ();
  return 0;
}
