/*
 *	grammar.c
 *
 *	1990/11/14/Wed	Yutaka MYOKI(Nagao Lab., KUEE)
 *	last modified by A.Kitauchi <akira-k@is.aist-nara.ac.jp>, Nov. 1996
 *
 */

#include "chadic.h"

#ifdef VGRAM
hinsi_t Hinsi[HINSI_MAX];
#else
class_t Class[CLASSIFY_NO][CLASSIFY_NO];
#endif

#ifdef VGRAM
/***********************************************************************
 * make_hinsi
 ***********************************************************************/
static int make_hinsi(cell, mother, idx)
    cell_t *cell;
    int mother, idx;
{
    char *name, *s;
    int depth, i, d;
    short *path;

    if (idx >= HINSI_MAX)
      cha_exit_file(1, "too many (over %d) parts of speech", HINSI_MAX);

    /* path */
    depth = Hinsi[mother].depth + 1;
    path = cha_malloc(sizeof(short) * (depth + 1));
    memcpy(path, Hinsi[mother].path, sizeof(short) * depth);
    path[depth - 1] = idx;
    path[depth] = 0;
    Hinsi[idx].depth = depth;
    Hinsi[idx].path = path;

    /* hinsi name and katsuyou */
    name = s_atom(car(cell));
#if 0
    printf("%2d:%*s%s\n",depth,depth*2,"",name);
    fflush(stdout);
#endif
    /* ʻϿΥå ޤ꤭줤ˡǤϤʤ */
    for (i = 0; Hinsi[mother].daughter[i + 1]; i++) {
	if (!strcmp(Hinsi[Hinsi[mother].daughter[i]].name, name))
	  cha_exit_file(1, "hinsi `%s' is already defined", name);
    }

    s = name + strlen(name) - 1;
    if (Hinsi[mother].kt == 1 || *s == '%') {
	Hinsi[idx].kt = 1;
	if (*s == '%')
	  *s = '\0';
    }
#ifdef KOCHA2
    if (Hinsi[mother].kt == 2 || *s == '+') {
	Hinsi[idx].kt = 2;
	if (*s == '+')
	  *s = '\0';
    }
#endif
    if ((s = strchr(name, '/')) != NULL) {
	*s++ = '\0';
	Hinsi[idx].bkugiri = *s ? cha_strdup(s) : JSTR_BKUGIRI;
    } else if (Hinsi[mother].bkugiri)
      Hinsi[idx].bkugiri = Hinsi[mother].bkugiri;

    if (*name == '\0')
      cha_exit_file(1, "an empty string for hinsi name");

    Hinsi[idx].name = cha_strdup(name);
#if 0
    s_print(stdout, car(cell));
    printf("[%d,%d,%s]\n",mother,idx,name);
    fflush(stdout);
#endif

    cell = cdr(cell);
    if (nullp(cell)) {
	static short daughter0 = 0;
	Hinsi[idx++].daughter = &daughter0;
    } else {
	short daughter[256];
	int ndaughter = 0;
	d = idx + 1;
	/* ʻϿΥåΤŪ daughter  */
	Hinsi[idx].daughter = daughter;
	for (; !nullp(cell); cell = cdr(cell)) {
	    daughter[ndaughter++] = d;
	    daughter[ndaughter] = 0;
	    d = make_hinsi(car(cell), idx, d);
	}
	daughter[ndaughter++] = 0;
	Hinsi[idx].daughter = cha_malloc(sizeof(short) * ndaughter);
	memcpy(Hinsi[idx].daughter, daughter, sizeof(short) * ndaughter);
	idx = d;
    }

    return idx;
}

/***********************************************************************
 * read_class
 ***********************************************************************/
void read_class(fp)
    FILE *fp;
{
    static short path0 = 0;
    cell_t *cell1;
    short daughter[256];
    int idx, ndaughter;

    /* root node */
    Hinsi[0].path = &path0;
    Hinsi[0].depth = 0;
    Hinsi[0].kt = 0;
    Hinsi[0].bkugiri = NULL;
    Hinsi[0].name = ESTR_BOS_EOS;

    idx = 1;
    ndaughter = 0;
    /* ʻϿΥåΤŪ daughter  */
    Hinsi[0].daughter = daughter;
    while (!s_feof(fp)) {
	if (!nullp(cell1 = s_read(fp))) {
	    daughter[ndaughter++] = idx;
	    daughter[ndaughter] = 0;
	    idx = make_hinsi(cell1, 0, idx);
	}
    }

#if 0
    {
	/* ʸڤɲ */
	cell_t *cell2 = cons(tmp_atom(JSTR_BUNSETSU_KUGIRI), NIL);
	daughter[ndaughter++] = idx;
	daughter[ndaughter] = 0;
	idx = make_hinsi(cell2, 0, idx);
    }
#endif

    daughter[ndaughter++] = 0;
    Hinsi[0].daughter = cha_malloc(sizeof(short) * ndaughter);
    memcpy(Hinsi[0].daughter, daughter, sizeof(short) * ndaughter);

    /* last node */
    Hinsi[idx].name = NULL;
}

/***********************************************************************
 * match_nhinsi - cellwildcardɽhinsiȥޥåƤ뤫ɤ
 ***********************************************************************/
int match_nhinsi(cell, hinsi)
    cell_t *cell;
    int hinsi;
{
    char *name;
    short *path;

    for (path = Hinsi[hinsi].path; !nullp(cell); path++, cell = cdr(cell)) {
	name = s_atom(car(cell));
	if (!*path) {
	    /*
	     * cell ĹȤϡǸϢ³ "*" ̵뤹
	     * ˤ cell:( *)  hinsi: ޥå
	     * chasenrc ʻ쥳Ȥλ ( *) ʤɤȤƤ
	     * connect.cha ǤȤǽ
	     */
	    if (strcmp(name, "*"))
	      return 0;
	    /* ʹߤ *path ͤ 0 ˤʤ褦ˤ */
	    path--;
	} else {
	    if (strcmp(name, "*") && strcmp(name, Hinsi[*path].name))
	      return 0;
	}
    }
    /* cell  hinsi Ƥʬʤޥå */
    return 1;
}

#else /* !VGRAM */

/***********************************************************************
 * make_class
 ***********************************************************************/
static int make_class(cell, hinsi, bunrui, katuyou)
    cell_t *cell;
    int hinsi, bunrui, katuyou;
{
    char *id;

    id = s_atom(car(cell));
    Class[hinsi][bunrui].id = cha_strdup(id);
    if (katuyou || !nullp(cdr(cell))) {
	katuyou = 1;
	Class[hinsi][bunrui].kt = 1;
    }

    return katuyou;
}

/***********************************************************************
 * read_class
 ***********************************************************************/
void read_class(fp)
    FILE *fp;
{
    cell_t *cell1, *cell2;
    int hinsi, bunrui;
    int katuyou = 0;

    Class[0][0].id = ESTR_BOS_EOS;
    hinsi = 1;
    while (!s_feof(fp)) {
	bunrui = 0;
	cell1 = s_read(fp);
	if (nullp(cell2 = car(cell1)))
	  cha_exit_file(1, "parse error");
	katuyou = make_class(cell2, hinsi, bunrui, 0);
	cell1 = car(cdr(cell1));
	bunrui++;

	for (; !nullp(cell2 = car(cell1)); cell1 = cdr(cell1)) {
	    make_class(cell2, hinsi, bunrui, katuyou);
	    if (++bunrui >= CLASSIFY_NO)
	      cha_exit_file(1, "too many sub-parts of speech");
	}
	if (++hinsi >= CLASSIFY_NO)
	  cha_exit_file(1, "too many parts of speech");
    }

#if 0
    Class[hinsi][0].id = BUNSETSU_KUGIRI;
    if (++hinsi >= CLASSIFY_NO)
      cha_exit_file(1, "too many parts of speech");
#endif
}

#endif /* !VGRAM */

/***********************************************************************
 * read_grammar - read GRAMMAR_FILE and set Class[][]
 *
 * inputs:
 *	dir - 0: read from current directory
 *	      1: read from grammar directory
 *	      2: read from current directory or grammar directory
 ***********************************************************************/
void read_grammar(fp_out, ret, dir)
    FILE *fp_out;
    int ret, dir;
{
    FILE *fp;
    char *filepath;

#ifdef VGRAM
    fp = cha_fopen_grammar(GRAMMAR_FILE, "r", ret, dir, &filepath);
#else
    fp = cha_fopen_grammar2(GRAMMAR_FILE, JM_GRAMMAR_FILE, "r", ret, dir, &filepath);
#endif

    if (fp_out != NULL)
      fprintf(fp_out, "parsing %s\n", filepath);

    read_class(fp);

    fclose(fp);
}
