
/* example2 : Show off some post processing to perform an implicit
 * plot of a 2d function.
 */

#include <stdio.h>
#include "triage.h"

#include "render.h"
#include "inliners.h"
#include "pixels.h"
#include "targagrabber.h"
#include "matrix.h"
#include "processing.h"
#include "geometry.h"
#include "materials.h"

#define NSTEPS 64

#define WIDTH  640
#define HEIGHT 480

CTexture2d texture(WIDTH,HEIGHT);
CTexture2d depth(WIDTH,HEIGHT);
CTriage    triage(texture,depth);

//PlatPixel const red   = Pixel(255,0,0,255);
//PlatPixel const black = Pixel(0,0,0,255);
#define red 0xff0000ff
#define black 0xff000000


int main(void)
{
    Clear(texture, Pixel(0,0,0,0));
    Clear(depth, 1000);

    triage.Transform().PushMatrix();

    // Tilt the camera slightly...
    triage.RotateX(10);

    triage.Transform().PushMatrix();
    triage.Translate(IntToFixed(170),IntToFixed(240),IntToFixed(200));
    triage.SetFlag(KFlagLessDepth);
    triage.SetFlag(KFlagBackFace);
    DrawSphere(triage,IntToFixed(64),CDiffuse<red>(triage),NSTEPS);
    triage.ClearFlag(KFlagBackFace);
    triage.Transform().PopMatrix();

    triage.Transform().PushMatrix();
    triage.Translate(IntToFixed(470),IntToFixed(240),IntToFixed(200));
    triage.SetFlag(KFlagBackFace);
    DrawSphere(triage,IntToFixed(64),CDiffuse<red>(triage),NSTEPS);
    triage.ClearFlag(KFlagBackFace);
    triage.Transform().PopMatrix();


    {
        CVector tt[4];
        int i,j;
        for (i=0;i<2;i++)
            for (j=0;j<2;j++)
            {
                tt[j+2*i].xf[0]=IntToFixed(-25+100*i);
                tt[j+2*i].xf[1]=IntToFixed(-100+200*j);
                tt[j+2*i].xf[2]=IntToFixed(-100+400*i);
                tt[j+2*i].xf[3] =FixedOne;
            }
        PlatPixel c=Pixel(0,255,0,255);

        triage.Transform().PushMatrix();
        triage.Translate(IntToFixed(170),IntToFixed(240),IntToFixed(200));
        triage.ClearFlag(KFlagLessDepth);
        triage.SetFlag(KFlagMoreDepth);
        triage.SetFlag(KFlagBackFace);
        triage.Quad(tt[2], c, tt[3], c, tt[0], c, tt[1], c);
        triage.ClearFlag(KFlagBackFace);
        triage.ClearFlag(KFlagMoreDepth);
        triage.SetFlag(KFlagLessDepth);
        triage.Transform().PopMatrix();

        triage.Transform().PushMatrix();
        triage.Translate(IntToFixed(170),IntToFixed(240),IntToFixed(200));
        triage.SetFlag(KFlagFrontFace);
        DrawSphere(triage,IntToFixed(64),CAmbient<black>(triage),NSTEPS);
        triage.ClearFlag(KFlagFrontFace);
        triage.Transform().PopMatrix();

        triage.Transform().PushMatrix();
        triage.Translate(IntToFixed(470),IntToFixed(240),IntToFixed(200));
        triage.SetFlag(KFlagBackFace);
        triage.Quad(tt[2], c, tt[3], c, tt[0], c, tt[1], c);
        triage.ClearFlag(KFlagBackFace);
        triage.Transform().PopMatrix();

    }
    triage.Transform().PopMatrix();

    SaveAsTarga("example3.tga",&texture[0],
                texture.Width(), texture.Height());

   system("xv example3.tga &");
   
    return 0;
}

