
#include "yacas.h"
#include "mathcommands.h"
#include "standard.h"

#ifdef LISP_DEBUGHEAP
long theNrDefinedBuiltIn=0;
long theNrDefinedUser=0;
#endif


#define InternalEval environment().iEvaluator->Eval


DefaultYacasEnvironment::~DefaultYacasEnvironment()
{
}

void DefaultYacasEnvironment::SetCommand(LispEvalCaller aEvaluatorFunc,
                                         LispCharPtr aString)
{
//If in debug mode, count this added command.
#ifdef LISP_DEBUGHEAP
    theNrDefinedBuiltIn++;
#endif

    commands.SetAssociation(LispEvaluator(aEvaluatorFunc),
                            hash.LookUp(aString,LispTrue));
}

DefaultYacasEnvironment::DefaultYacasEnvironment()
:infixprinter(prefixoperators,
             infixoperators,
             postfixoperators,
              bodiedoperators),
iEnvironment(commands,userFunctions,
                 globals,hash,&output,infixprinter,
                 prefixoperators,infixoperators,
                 postfixoperators,bodiedoperators,&input),
input(iEnvironment.iInputStatus)
{
    // Define the buitl-in functions by tying their string representation
    // to a kernel callable routine.

    SetCommand(LispQuote         ,"Hold");
    SetCommand(LispEval          ,"Eval");
    SetCommand(LispSetVar        ,"Set");
    SetCommand(LispMacroSetVar   ,"MacroSet");
    SetCommand(LispClearVar      ,"Clear");
    SetCommand(LispMacroClearVar ,"MacroClear");
    SetCommand(LispFullForm      ,"FullForm");

    SetCommand(LispHead          ,"Head");
    SetCommand(LispNth           ,"MathNth");
    SetCommand(LispTail          ,"Tail");
    SetCommand(LispDestructiveReverse       ,"DestructiveReverse");
    SetCommand(LispLength        ,"Length");
    SetCommand(LispList          ,"List");
    SetCommand(LispUnList        ,"UnList");
    SetCommand(LispListify       ,"Listify");
    SetCommand(LispConcatenate   ,"Concat");
    SetCommand(LispConcatenateStrings   ,"ConcatStrings");
    SetCommand(LispDelete        ,"Delete");
    SetCommand(LispInsert        ,"Insert");
    SetCommand(LispReplace       ,"Replace");
    SetCommand(LispNot           ,"MathNot");
    SetCommand(LispNot           ,"Not");
    SetCommand(LispLazyAnd       ,"MathAnd");
    SetCommand(LispLazyAnd       ,"And");
    SetCommand(LispLazyOr        ,"MathOr");
    SetCommand(LispLazyOr        ,"Or");
    SetCommand(LispEquals        ,"Equals");
    SetCommand(LispEquals        ,"=");
    SetCommand(LispWrite         ,"Write");
    SetCommand(LispSpace         ,"Space");
    SetCommand(LispNewLine       ,"NewLine");
    SetCommand(LispWriteString   ,"WriteString");
    SetCommand(LispProgBody      ,"Prog");
    SetCommand(LispNewLocal      ,"Local");
    SetCommand(LispMacroNewLocal ,"MacroLocal");
    SetCommand(LispWhile         ,"While");
    
    SetCommand(LispMultiply      ,"MathMultiply");

    SetCommand(LispAdd           ,"MathAdd");
    SetCommand(LispSubtract      ,"MathSubtract");
    SetCommand(LispDivide        ,"MathDivide");
    SetCommand(LispDiv           ,"MathDiv");
    SetCommand(LispMod           ,"MathMod");

    SetCommand(LispLessThan      ,"LessThan");
    SetCommand(LispGreaterThan   ,"GreaterThan");
    SetCommand(LispLessThan      ,"<");
    SetCommand(LispGreaterThan   ,">");

    SetCommand(LispPreFix        ,"PreFix");
    SetCommand(LispInFix         ,"InFix");
    SetCommand(LispPostFix       ,"PostFix");
    SetCommand(LispBodied        ,"Bodied");
    SetCommand(LispAtomize       ,"Atom");
    SetCommand(LispStringify     ,"String");
    SetCommand(LispLoad          ,"Load");

    SetCommand(LispRuleBase      ,"RuleBase");
    SetCommand(LispMacroRuleBase ,"MacroRuleBase");
    SetCommand(LispHoldArg       ,"HoldArg");
    SetCommand(LispNewRule       ,"Rule");
    SetCommand(LispMacroNewRule  ,"MacroRule");
    SetCommand(LispUnFence       ,"UnFence");
    SetCommand(LispTryRetract    ,"TryRetract");

    SetCommand(LispIsFunction    ,"IsFunction");
    SetCommand(LispIsAtom        ,"IsAtom");
    SetCommand(LispIsNumber      ,"IsNumber");
    SetCommand(LispIsInteger     ,"IsInteger");
    SetCommand(LispIsList        ,"IsList");
    SetCommand(LispIsString      ,"IsString");
    SetCommand(LispIsBound       ,"IsBound");

    SetCommand(LispIf    ,"If");

    SetCommand(LispSin   ,"MathSin");
    SetCommand(LispCos   ,"MathCos");
    SetCommand(LispTan   ,"MathTan");
    SetCommand(LispArcSin   ,"MathArcSin");
    SetCommand(LispArcCos   ,"MathArcCos");
    SetCommand(LispArcTan   ,"MathArcTan");
    SetCommand(LispLog   ,"MathLog");
    SetCommand(LispExp   ,"MathExp");
    SetCommand(LispPower ,"MathPower");

    SetCommand(LispFastSin   ,"FastSin");
    SetCommand(LispFastCos   ,"FastCos");
    SetCommand(LispFastTan   ,"FastTan");
    SetCommand(LispFastArcSin,"FastArcSin");
    SetCommand(LispFastArcCos,"FastArcCos");
    SetCommand(LispFastArcTan,"FastArcTan");
    SetCommand(LispFastLog   ,"FastLog");
    SetCommand(LispFastExp   ,"FastExp");
    SetCommand(LispFastPower ,"FastPower");

    SetCommand(LispPrecision ,"Precision");

    SetCommand(LispSqrt   ,"MathSqrt");
    SetCommand(LispFloor  ,"MathFloor");
    SetCommand(LispCeil   ,"MathCeil");
    SetCommand(LispAbs   ,"MathAbs");
    SetCommand(LispMod   ,"MathMod");
    SetCommand(LispDiv   ,"MathDiv");
    SetCommand(LispPi    ,"Pi");
    SetCommand(LispGcd   ,"MathGcd");


    SetCommand(LispDefaultDirectory   ,"DefaultDirectory");
    SetCommand(LispFromFile   ,"FromFile");
    SetCommand(LispFromString ,"FromString");
    SetCommand(LispToFile   ,"ToFile");
    SetCommand(LispToString ,"ToString");
    SetCommand(LispRead   ,"Read");
    SetCommand(LispReadToken   ,"ReadToken");
    SetCommand(LispDestructiveDelete,"DestructiveDelete");
    SetCommand(LispDestructiveInsert,"DestructiveInsert");
    SetCommand(LispDestructiveReplace,"DestructiveReplace");
    SetCommand(LispFlatCopy       ,"FlatCopy");

    SetCommand(LispCheck       ,"Check");

    SetCommand(LispSystemCall  ,"SystemCall");


    SetCommand(LispShiftLeft       ,"ShiftLeft");
    SetCommand(LispShiftRight       ,"ShiftRight");
    SetCommand(LispFromBase       ,"FromBase");
    SetCommand(LispToBase       ,"ToBase");

    SetCommand(LispMaxEvalDepth   ,"MaxEvalDepth");

    SetCommand(LispDefLoad   ,"DefLoad");
    SetCommand(LispUse   ,"Use");

    SetCommand(LispRightAssociative   ,"RightAssociative");
    SetCommand(LispLeftPrecedence     ,"LeftPrecedence");
    SetCommand(LispRightPrecedence    ,"RightPrecedence");

    SetCommand(LispIsInFix      ,"IsInFix");
    SetCommand(LispIsPreFix     ,"IsPreFix");
    SetCommand(LispIsPostFix    ,"IsPostFix");
    SetCommand(LispGetPrecedence,"OpPrecedence");
    SetCommand(LispGetLeftPrecedence,"OpLeftPrecedence");
    SetCommand(LispGetRightPrecedence,"OpRightPrecedence");
    SetCommand(LispGetPrecision ,"GetPrecision");

    SetCommand(LispBitAnd,"BitAnd");
    SetCommand(LispBitOr ,"BitOr");
    SetCommand(LispBitXor,"BitXor");

    SetCommand(LispSecure,"Secure");
    SetCommand(LispFindFile,"FindFile");
    SetCommand(LispFindFunction,"FindFunction");
    
    SetCommand(LispIsGeneric,"IsGeneric");
    SetCommand(LispGenericTypeName,"GenericTypeName");

    SetCommand(GenArrayCreate,"ArrayCreate");
    SetCommand(GenArraySize,"ArraySize");
    SetCommand(GenArrayGet,"ArrayGet");
    SetCommand(GenArraySet,"ArraySet");

    SetCommand(LispTrace,"TraceExp");
    SetCommand(LispTraceRule,"TraceRule");
    SetCommand(LispReadLisp,"LispRead");
    SetCommand(LispType,"Type");

    SetCommand(LispStringMid,"StringMid");
    SetCommand(LispSetStringMid,"SetStringMid");

    SetCommand(GenPatternCreate,"PatternCreate");
    SetCommand(GenPatternMatches,"PatternMatches");

    SetCommand(LispRuleBaseDefined,"RuleBaseDefined");
    SetCommand(LispRuleBaseArgList,"RuleBaseArgList");
    bodiedoperators.SetOperator(0,hash.LookUp("While"));
    bodiedoperators.SetOperator(0,hash.LookUp("Rule"));
    bodiedoperators.SetOperator(0,hash.LookUp("MacroRule"));
    bodiedoperators.SetOperator(0,hash.LookUp("FromFile"));
    bodiedoperators.SetOperator(0,hash.LookUp("FromString"));
    bodiedoperators.SetOperator(0,hash.LookUp("ToFile"));
    bodiedoperators.SetOperator(0,hash.LookUp("ToString"));
    bodiedoperators.SetOperator(0,hash.LookUp("TraceRule"));

    prefixoperators.SetOperator(0,hash.LookUp("_"));
    infixoperators.SetOperator(0,hash.LookUp("_"));
}






LISPEXPORT CYacas* CYacas::NewL()
{
  CYacas* self = new CYacas;
  return self;
}

LISPEXPORT CYacas::~CYacas()
{
}


CYacas::CYacas()
: iResultOutput(iResult), iErrorOutput(iError)
{
}



void CYacas::Evaluate(LispCharPtr aExpression)
{

  iResult.SetNrItems(1);
  iResult[0]='\0';
  iError.SetNrItems(1);
  iError[0]='\0';
  
  LispInt error;
    LispPtr result;
    LispTrap(error,
     {
         LispString full(aExpression);
         full[full.NrItems()-1] = ';';
         full.Append('\0');
         StringInput input(full,environment().iInputStatus);
         environment().iInputStatus.SetTo("CommandLine");
         LispPtr lispexpr;
         LispTokenizer tok;
         InfixParser parser(tok, input,
                            environment().HashTable(),
                            environment().PreFix(),
                            environment().InFix(),
                            environment().PostFix(),
                            environment().Bodied());
         parser.Parse(lispexpr);

         environment().iEvalDepth=0;

         InternalEval(environment(), result, lispexpr);
         // If no error encountered, print result
         InfixPrinter infixprinter(environment().PreFix(),
                                   environment().InFix(),
                                   environment().PostFix(),
                                   environment().Bodied());

         infixprinter.Print(result, iResultOutput);
         iResultOutput.Write(";");
         environment().SetVariable(environment().HashTable().LookUp("%"),result);
     },iErrorOutput,environment());

}

LispCharPtr CYacas::Result()
{
  return iResult.String();
}

LispCharPtr CYacas::Error()
{
  return iError.String();
}



