
#include <F32FILE.H>
#include "stringio.h"


class LispLocalFile : public LispBase
{
public:
    LispLocalFile(LispEnvironment& aEnvironment,
                  LispCharPtr aFileName, LispBoolean aRead,
                  InputDirectories& aInputDirectories);
    virtual ~LispLocalFile();
    virtual void Delete();

    RFs fs;
    RFile iFile;
    LispEnvironment& iEnvironment;
    LispInt iOpened;
};


class StdFileInput : public LispInput
{
public:
    StdFileInput(LispLocalFile& aFile);
    ~StdFileInput();
    virtual LispChar Next();
    virtual LispChar Peek();
    virtual LispBoolean EndOfStream();
    void Rewind();
protected:
    RFile &iFile;
    LispCharPtr iBuffer;
    LispInt iCurrentPos;
    LispInt iNrBytes;
};



#define FILEINPUT StdFileInput


class StdFileOutput : public LispOutput
{
public:
    StdFileOutput(LispLocalFile& aFile);
    virtual void PutChar(LispChar aChar);
public:
    RFile &iFile;
};

class StdUserOutput : public StringOutput
{
public:
    StdUserOutput() : StringOutput(iString) {};
    LispString iString;
};


// Epoc input : for now none...
class StdUserInput : public LispInput
{
public:
    StdUserInput();
    virtual LispChar Next();
    virtual LispChar Peek();
    virtual LispBoolean EndOfStream();
};






