/** \file mathenvironment.h
 *  math language specific version of environment. Currently experimental.
 *
 */

#ifndef __mathenvironment_h__
#define __mathenvironment_h__

#include "lispenvironment.h"
#include "lispevalhash.h"
#include "lispobject.h"
#include "lispatom.h"
#include "lispglobals.h"

class MathEnvironment : public LispEnvironment
{
public:
    MathEnvironment(LispCommands& aCommands,
                    LispUserFunctions& aUserFunctions,
                    LispGlobal& aGlobals,
                    LispHashTable& aHashTable,
                    LispOutput* aOutput,
                    LispPrinter& aPrinter,
                    LispOperators &aPreFixOperators,
                    LispOperators &aInFixOperators,
                    LispOperators &aPostFixOperators,
                    LispOperators &aBodiedOperators,
                    LispInput*    aCurrentInput)
        : iCommands(aCommands),
          iUserFunctions(aUserFunctions),
          iHashTable(aHashTable),
          iPrinter(aPrinter),
          iCurrentOutput(aOutput),
          iGlobals(aGlobals),
          iPreFixOperators(aPreFixOperators),
          iInFixOperators(aInFixOperators),
          iPostFixOperators(aPostFixOperators),
          iBodiedOperators(aBodiedOperators),
          iCurrentInput(aCurrentInput),
          theUserError(NULL)

    {
        iTrue = HashTable().LookUp("True");
        iFalse = HashTable().LookUp("False");
        iTrueAtom.Set(LispAtom::New(iTrue));
        iFalseAtom.Set(LispAtom::New(iFalse));
        PushLocalFrame(LispTrue);
    }
    virtual void SetVariable(LispStringPtr aString, LispPtr& aValue);
    virtual LispPtr* GetVariable(LispStringPtr aString);
    virtual void UnsetVariable(LispStringPtr aString);
    virtual LispCommands& Commands();
    virtual LispHashTable& HashTable();
    virtual LispUserFunction* UserFunction(LispPtr& aArguments);
    virtual LispUserFunction* UserFunction(LispStringPtr aName,LispInt aArity);
    virtual LispMultiUserFunction* MultiUserFunction(LispStringPtr aOperator);
    virtual LispDefFiles& DefFiles();
    virtual void DeclareRuleBase(LispStringPtr aOperator, LispPtr& aParameters);
    virtual void DefineRule(LispStringPtr aOperator,LispInt aArity,
                            LispInt aPrecedence, LispPtr& aPredicate,
                            LispPtr& aBody);
    virtual void UnFenceRule(LispStringPtr aOperator,LispInt aArity);
    virtual void TryRetract(LispStringPtr aOperator,LispInt aArity);
    virtual void HoldArgument(LispStringPtr  aOperator,LispStringPtr aVariable);

    virtual LispPrinter& CurrentPrinter();

    virtual void PushLocalFrame(LispBoolean aFenced);
    virtual void PopLocalFrame();
    virtual void NewLocal(LispStringPtr aVariable,LispObject* aValue);

    virtual LispOperators& PreFix();
    virtual LispOperators& InFix();
    virtual LispOperators& PostFix();
    virtual LispOperators& Bodied();

    virtual LispInput* CurrentInput();
    virtual void SetCurrentInput(LispInput* aInput);

    virtual LispOutput* CurrentOutput();
    virtual void SetCurrentOutput(LispOutput* aOutput);

    virtual void SetUserError(LispCharPtr aErrorString);
    virtual LispCharPtr ErrorString(LispInt aError);

private:
    LispPtr *FindLocal(LispStringPtr aVariable);
    
private:
    LispCommands&  iCommands;
    LispUserFunctions& iUserFunctions;
    LispHashTable& iHashTable;
    LispDefFiles   iDefFiles;
    LispPrinter&   iPrinter;
    LispOutput*    iCurrentOutput;

    LispGlobal&    iGlobals;
    LispPtr        iLocals;

    LispOperators& iPreFixOperators;
    LispOperators& iInFixOperators;
    LispOperators& iPostFixOperators;
    LispOperators& iBodiedOperators;

    LispInput* iCurrentInput;

    LispCharPtr theUserError;

};






#endif

