/*
   Pathetic Writer
   Copyright (C) 1997-1999  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include "../siod/siod.h"
#include "../pw/pw.h"
#include "../common/cmalloc.h"
#include "../common/common.h"
#include "../xcommon/xfonts.h"
#include "../xcommon/dialogs.h"
#include "../xcommon/embed.h"
#include "../xcommon/plugin.h"
#include "../xcommon/filesel.h"
#include "../xcommon/xcommon.h"
#include "xpw.h"

/* ---
*/
int ask_for_str_comp(char *prompt, char *buffr, int (*comp)(char *))
{
	return dialog_input(topLevel, prompt, buffr, comp);
}

static int nocomp(char *b)
{
	return TRUE;
}

/* ---
*/
int ask_for_str(char *prompt, char *buffr)
{
	return ask_for_str_comp(prompt, buffr, nocomp);
}

/* ---
*/
int select_file(char *path, char *name, char *patterns[], char *fmt)
{
	char extra[1024];
	sprintf(extra, "Home=%s:Examples=%s/pw/examples",
		getenv("HOME"), docdir);
	return fsel_input(topLevel, path, name, patterns, fmt, extra);
}

/* ---
*/
int alert_box(char *text, char *buttons[], int nbuttons)
{
	return alertbox(topLevel, text, buttons, nbuttons);
}

/* ---
*/
int select_from_list(char *text, char *choices[], int nchoices)
{
	return listsel(topLevel, text, choices, nchoices);
}

/* ---
*/
void error_box(char *message)
{
	errorbox(topLevel, message);
}

/* ---
The interpretation of this is changed so that the return value
is the width of the col:th character in row. All places
where cell_width is called must be changed to char_width.

Precondition: col *must* be a legal position within the line
*/

int char_width(buffer *buf, int s, int row, int col)
{
        rich_char *line = buf->sht[s].text[row].p;
        int w;

        if (line == NULL) return 0;     /* do not dump core */

	w = rc_width(line[col]);
        return w;
}

/* ---
width of the line up to but not including col
*/

int line_width(buffer *buf, int s, int row, int col)
{
        rich_char *line;
        char *p;
        int i, l;
        unsigned int width;

        if (row > buf->sht[s].used_lines) return 0;
        line = buf->sht[s].text[row].p;
        if (line == NULL) return 0;     /* do not dump core */
        p = (char *)rc_makeplain(line);

        if (buf->sht[s].text[row].sty == STY_EMBED) {
                if (col == 0) return 0;
                embed_size(p, &width, NULL);
                return width;
        }

        l = rc_strlen(line);
        if (col > l) col = l;
        width = 0;      /* accumulated width */
        for (i = 0; i < col && line[i].c; i++) {
                if (line[i].c == '\t') {
                        width += buf->tab_distance;
                        width -= (width % tab_distance);
                } else {
			width += rc_width(line[i]);
                }
        }
        cfree(p);
        return width;
}

#ifdef GUILE
static void execute_guile_action(Widget w, XEvent * event,
                           String * params, Cardinal * num_params)
{
        char b[256];
        int i;

        strcpy(b, "(");
        strncat(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
        strncat(b, ")", 255);

        exec_expr(name2interpreter("guile"), b);
}
#endif	/* GUILE */

static void execute_siod_action(Widget w, XEvent * event,
                           String * params, Cardinal * num_params)
{
        char b[256];
        int i;

        strcpy(b, "(");
        strncat(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
        strncat(b, ")", 255);
        exec_expr(siod_interpreter, b);
}

#ifdef TCL
static void execute_tcl_action(Widget w, XEvent *event,
                           String *params, Cardinal *num_params)
{
        char b[256];
        int i;

        strncpy(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
        exec_expr(name2interpreter("tcl"), b);
}
#endif	/* TCL */

static XtActionsRec actions[] =
{
#ifdef GUILE
        {"guile", execute_guile_action},
#endif
	{"execute", execute_siod_action},
#ifdef TCL
	{"tcl", execute_tcl_action}
#endif
};

/* ---
move point inside visible area
*/

static void fix_point(int width, int height)
{
        int cur_x, cur_y;
        buffer *buf = w_list->buf;
	int s = w_list->sht;
	sheet *st = buf->sht;

        /* do the easy stuff first */
        if (st[s].point_pos.row < st[s].top.row)
                st[s].point_pos.row = st[s].top.row;

        get_char_coords(w_list, st[s].top.row, st[s].top.col,
                        st[s].point_pos.row, st[s].point_pos.col,
                        &cur_x, &cur_y);
        while (cur_y < 0) {
                st[s].point_pos.row++;
                cur_y += cell_height(buf, s, st[s].point_pos.row);
        }
        while (cur_y > height - cell_height(buf, s, st[s].point_pos.row)) {
                st[s].point_pos.row--;
                cur_y -= cell_height(buf, s, st[s].point_pos.row);
        }
}

static LISP scroll_up(void)
{
        Window root, char_win = XtWindow(w_list->ui->grid);
        int x, y, new_y, new_row;
        unsigned int width, height, border_width, depth;
        buffer *buf = w_list->buf;
	int s = w_list->sht;
	sheet *st = buf->sht;

        XGetGeometry(display, char_win, &root, &x, &y, &width, &height,
                     &border_width, &depth);
        new_y = -height + cell_height(buf, s, st[s].point_pos.row);
        new_row = st[s].top.row;
        while (new_y < 0) {
                new_y += cell_height(buf, s, st[s].point_pos.row);
                new_row--;
        }
        if (new_row < 1)
                new_row = 1;
        st[s].top.row = new_row;
        fix_point(width, height);
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP scroll_char_up(void)
{
        Window root, char_win = XtWindow(w_list->ui->grid);
        int x, y, new_y, new_row;
        unsigned int width, height, border_width, depth;
        buffer *buf = w_list->buf;
	int s = w_list->sht;
	sheet *st = buf->sht;

        XGetGeometry(display, char_win, &root, &x, &y, &width, &height,
                     &border_width, &depth);
        new_y = -cell_height(buf, s, st[s].point_pos.row);
        new_row = st[s].top.row;
        while (new_y < 0) {
                new_y += cell_height(buf, s, st[s].point_pos.row);
                new_row--;
        }
        if (new_row < 1)
                new_row = 1;
        st[s].top.row = new_row;
        fix_point(width, height);
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP scroll_down(void)
{
        Window root, char_win = XtWindow(w_list->ui->grid);
        int x, y, new_y, new_row;
        unsigned int width, height, border_width, depth;
        buffer *buf = w_list->buf;
	int s = w_list->sht;
	sheet *st = buf->sht;

        XGetGeometry(display, char_win, &root, &x, &y, &width, &height,
                     &border_width, &depth);
        new_y = height - cell_height(buf, s, st[s].point_pos.row);
        new_row = st[s].top.row;
        while (new_y > 0) {
                new_y -= cell_height(buf, s, st[s].point_pos.row);
                new_row++;
        }
        if (new_row > max_lines)
                new_row = max_lines;
        st[s].top.row = new_row;
        fix_point(width, height);
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP scroll_char_down(void)
{
        Window root, char_win = XtWindow(w_list->ui->grid);
        int x, y, new_y, new_row;
        unsigned int width, height, border_width, depth;
        buffer *buf = w_list->buf;
	int s = w_list->sht;
	sheet *st = buf->sht;

        XGetGeometry(display, char_win, &root, &x, &y, &width, &height,
                     &border_width, &depth);
        new_y = cell_height(buf, s, st[s].point_pos.row);
        new_row = st[s].top.row;
        while (new_y > 0) {
                new_y -= cell_height(buf, s, st[s].point_pos.row);
                new_row++;
        }
        if (new_row > max_lines)
                new_row = 1;
        st[s].top.row = new_row;
        fix_point(width, height);
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP set_block(void)
{
        position p = get_point(w_list);
        position m = get_mark(w_list);
	int s = w_list->sht;
	sheet *st = w_list->buf->sht;

        if (p.row < m.row) {
                st[s].blkl.row = p.row;
                st[s].blkl.row = m.row;
        } else {
                st[s].blku.row = m.row;
                st[s].blkl.row = p.row;
        }
        if (p.col < m.col) {
                st[s].blku.col = p.col;
                st[s].blkl.col = m.col;
        } else {
                st[s].blku.col = m.col;
                st[s].blkl.col = p.col;
        }

        if (XtOwnSelection(w_list->ui->grid, XA_PRIMARY,
			CurrentTime, convert_proc,
                lose_ownership_proc, transfer_done_proc) == False) {
                        XtWarning("Siag: failed to become selection owner\n");
                        st[s].blku.row = st[s].blku.col = -1;
                        st[s].blkl.row = st[s].blkl.col = -1;
        }

        pr_scr_flag = TRUE;
        return NIL;
}

static LISP bell(void)
{
        XBell(display, 100);
        return NIL;
}

static LISP lembed_object(void)
{
        char file[256], *tag;
        unsigned int width, height;
        buffer *buf = w_list->buf;
	int s = w_list->sht;
	sheet *st = buf->sht;
        int row = st[s].point_pos.row;

        if (ret_style(buf, s, row) == STY_EMBED) {
                llpr("Can't overwrite embedded object");
                return NIL;
        }

        file[0] = '\0';
        if (!ask_for_str("Object file:", file)) return NIL;

        tag = embed_load(file);
        if (tag == NULL) return NIL;

        embed_size(tag, &width, &height);
        buf->sht[s].text[row].height = height;
        ins_text(buf, s, make_position(row, 0), (unsigned char *)tag,
                        0);
        buf->sht[s].text[row].sty = STY_EMBED;
        w_list->buf->change = TRUE;
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP lembed_remove(void)
{
        buffer *buf = w_list->buf;
	int s = w_list->sht;
	sheet *st = buf->sht;
        int row = st[s].point_pos.row;
        if (buf->sht[s].text[row].sty == STY_EMBED) {
                st[s].point_pos.col = 0;
                del_char(buf, s, row, 0);
        }
        w_list->buf->change = TRUE;
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP lembed_open(void)
{
        buffer *buf = w_list->buf;
	int s = w_list->sht;
	sheet *st = buf->sht;
        int row = st[s].point_pos.row;
        if (buf->sht[s].text[row].sty == STY_EMBED) {
                char *p = (char *)rc_makeplain(buf->sht[s].text[row].p);
                embed_open(p);
                embed_load(p);
                cfree(p);
        }
        w_list->buf->change = TRUE;
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP lembed_save(void)
{
        char cmd[1024];
        char file[256];
        buffer *buf = w_list->buf;
        Pixmap bitmap;

        file[0] = '\0';
        if (!ask_for_str("Object file:", file)) return NIL;

        bitmap = draw_snapshot();
        sprintf(cmd, "pw %s", buf->path);
        embed_save(file, cmd, bitmap);
        XFreePixmap(display, bitmap);
        return NIL;
}

/* ---
*/
void interp_startup(void)
{
        XtAppContext app_context = XtWidgetToApplicationContext(topLevel);

        XtAppAddActions(app_context, actions, XtNumber(actions));
	init_subr_0("scroll-up", scroll_up);
	init_subr_0("scroll-char-up", scroll_char_up);
	init_subr_0("scroll-down", scroll_down);
	init_subr_0("scroll-char-down", scroll_char_down);
	init_subr_0("set-block", set_block);
	init_subr_0("bell", bell);
	init_subr_0("embed-object", lembed_object);
	init_subr_0("embed-remove", lembed_remove);
	init_subr_0("embed-open", lembed_open);
	init_subr_0("embed-save", lembed_save);
}

/* ---
Postscript font handling. Metrics are taken from X
*/

int ps_text_width(int index, char *s)
{
	return font_width(index, s);
}

/* ---
*/
int ps_font_descent(int index)
{
	return font_descent(index);
}

/* ---
*/
int ps_font_height(long font)
{
	return font_height(font);
}

/* ---
*/
int ps_embed_print(FILE *fp, char *tag, int x_base, int y_base)
{
	return embed_print(fp, tag, x_base, y_base);
}


/* ---
	A dialog for spelling checkers. This should probably be in xcommon.

	The dialog has the following components:

	A label with the word "Original:"
	A text widget (non-editable) with the incorrect word
	A label with the word "Replacement:"
	A text widget (editable) with the replacement word
	A command button with the word "Replace"
	A command button with the word "Accept"
	A command button with the word "Insert"
	A command button with the word "Skip"
	A command button with the word "Cancel"
	A command button with the word "Help"

	The dialog terminates when any of the buttons other than Help
	is pressed. Help pops up Siaghelp with the file pw/spell.html.

	The function accepts these parameters:

	A text buffer with the original word
	A text buffer for the replacement word. This must be large enough.

	The replacement buffer may already contain a suggested word,
	so it must not be cleared by the dialog.

	The function returns the number of the button pressed, with
	1 for Replace and so on.

	Lots of code swiped from forminput.c, which is where this
	really belongs.
--- */

spell_state state;

static Widget vert = None, horiz = None;

#define ANYWHERE 0
#define LEFT 1
#define RIGHT 2

static Widget place(Widget w, Widget vert, Widget horiz, int chain)
{
        if (vert != None)
                XtVaSetValues(w,
                        XtNfromVert, vert, (char *)0);
        if (horiz != None)
                XtVaSetValues(w,
                        XtNfromHoriz, horiz, (char *)0);
        switch (chain) {
        case LEFT:
                XtVaSetValues(w,
                        XtNtop, XawChainTop,
                        XtNbottom, XawChainTop,
                        XtNleft, XawChainLeft,
                        XtNright, XawChainLeft, (char *)0);
                break;
        case RIGHT:
                XtVaSetValues(w,
                        XtNtop, XawChainTop,
                        XtNbottom, XawChainTop,
                        XtNleft, XawChainLeft,  /* this is not a bug */
                        XtNright, XawChainRight, (char *)0);
                break;
        default:        /* nothing to do */
                break;
        }
        return w;
}

static void spell_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
	spell_state data = (spell_state)client_data;

	if (data == SPELL_HELP) {
		char b[256];

		sprintf(b, "file://localhost%s/pw/spell.html", docdir);
		if (!fork()) {
			execlp(siaghelp, "Siaghelp", b, (char *)0);
			exit(0);
		}
	} else {
		state = data;
	}
}

static Widget new_label(Widget pw, char *name, char *text)
{
	Widget w = XtVaCreateManagedWidget(name,
		labelWidgetClass, pw,
		XtNwidth, 100,
		(char *)0);
	horiz = place(w, vert, horiz, LEFT);
	label_set(w, text);
	return w;
}

static Widget new_textw(Widget pw, char *name, char *text)
{
	Widget w = XtVaCreateManagedWidget(name,
		asciiTextWidgetClass, pw,
		XtNwidth, 400,
		XtNeditType, XawtextEdit,
		XtNdisplayCaret, False,
		XtNstring, translate(text),
		(char *)0);
	horiz = place(w, vert, horiz, RIGHT);
	return w;
}

static Widget new_command(Widget pw, char *name, char *text, int data)
{
	Widget w = XtVaCreateManagedWidget(name,
		commandWidgetClass, pw,
		XtNwidth, 80,
		XtNheight, 20,
		(char *)0);
	horiz = place(w, vert, horiz, LEFT);
	XtAddCallback(w, XtNcallback, spell_cb, (XtPointer)data);
	label_set(w, text);
	return w;
}

static void new_line(void)
{
	vert = horiz;
	horiz = None;
}

extern void center(Widget, Widget);

/* ---
*/
spell_state spell_select(char *original, char *replacement)
{
	Widget spell_shell, spell_form, spell_label1, spell_text1,
		spell_label2, spell_text2,
		spell_replace, spell_accept, spell_insert,
		spell_skip, spell_cancel, spell_help;
	String string;
	state = SPELL_WAIT;

	vert = None, horiz = None;
	spell_shell = XtVaCreateManagedWidget("spell_shell",
		transientShellWidgetClass, topLevel,
		XtNtitle, "Replacement",
		XtNwidth, 520,
		XtNheight, 80,
		(char *)0);
	spell_form = XtVaCreateManagedWidget("spell_form",
		formWidgetClass, spell_shell, (char *)0);
	spell_label1 = new_label(spell_form, "spell_label", "Original:");
	spell_text1 = new_textw(spell_form, "spell_text1", original);
	new_line();
	spell_label2 = new_label(spell_form, "spell_label2", "Replacement:");
	spell_text2 = new_textw(spell_form, "spell_text2", replacement);
	new_line();
	spell_replace = new_command(spell_form, "spell_replace",
		"Replace", SPELL_REPLACE);
	spell_accept = new_command(spell_form, "spell_accept",
		"Accept", SPELL_ACCEPT);
	spell_insert = new_command(spell_form, "spell_insert",
		"Insert", SPELL_INSERT);
	spell_skip = new_command(spell_form, "spell_skip",
		"Skip", SPELL_SKIP);
	spell_cancel = new_command(spell_form, "spell_cancel",
		"Cancel", SPELL_CANCEL);
	spell_help = new_command(spell_form, "spell_help",
		"Help", SPELL_HELP);

	center(topLevel, spell_shell);
	XtPopup(spell_shell, XtGrabNonexclusive);

	XtSetKeyboardFocus(spell_shell, spell_text2);

	while (state == SPELL_WAIT) {
		XEvent event_return;

		XtAppNextEvent(XtWidgetToApplicationContext(spell_shell),
				&event_return);
		XtDispatchEvent(&event_return);
	}
	XtVaGetValues(spell_text2,
		XtNstring, &string, (char *)0);
	strcpy(replacement, string);
	XtPopdown(spell_shell);
	XtDestroyWidget(spell_shell);
	return state;
}

