\name{tempfile}
\title{Create Unique Names for (Temporary) Files}
\usage{
tempfile(pattern = "file")
}
\alias{tempfile}
\arguments{
  \item{pattern}{a character vector giving the initial part of the name.}
}
\value{
  A character vector giving the names of possible (temporary) files.  The
  names are guaranteed to be unique among calls to \code{tempfile} in an \R
  session.  Note that no files are generated by \code{tempfile}.
}
#ifdef windows
\details{
  The filenames will be in the directory given by the first found of
  the environment variables \code{TMP}, \code{TEMP} and \code{R\_USER}
  (see \code{\link{Rconsole}}). If the path to the directory contains
  a space in any of the components, the path returned will use the
  shortnames version of the path. 
}
#endif
\seealso{\code{\link{unlink}} for deleting files.}
#ifdef unix
\examples{
## One possibility of getting ALL environment variables;
## compare with `getenv':
fun <- function() {
  FILE <- tempfile("fun")
  on.exit(unlink(FILE))
  system(paste("printenv >", FILE))
  x <- strsplit(scan(FILE, what = ""), "=")
  v <- n <- character(LEN <- length(x))
  for (i in 1:LEN) {
    n[i] <- x[[i]][1]
    v[i] <- paste(x[[i]][-1], collapse = "=")
  }
  structure(v, names = n)
}
\testonly{str(fun())}
\dontrun{fun()}
}
#endif
\keyword{file}
