%%NAME
%%  eparam  -  print parameter text in two columns under plots 
%%
%%SYNOPSIS
%%  eparam(text1,text2[,x,y])
%%
%%PARAMETER(S)
%%  text1        text of the left column
%%  text2        text of the right column
%%  x            x-coordinate of start position
%%  y            y-coordinate of start position
%% 
%%GLOBAL PARAMETER(S)
%%  eParamPos
%%  eParamFontSize
%%  eParamTextValueDistance
%%  eParamTextFont
%%  eParamValueFont
%%  eParamLineDistance
% written by Stefan Mueller stefan.mueller@fgan.de

function eparam(text1,text2,x,y)
  if nargin~=2 & nargin~=4
    usage('eparam(text1,text2[,x,y])');
  end
  eglobpar;
  if nargin==4 
    eParamPos(1)=x;
    eParamPos(2)=y;
  else
    x=eParamPos(1);
    y=eParamPos(2);
  end
  etext(text1,x,y,...
        eParamFontSize,1,eParamTextFont,0); 
  etext(':',x+eParamTextValueDistance-10,y,...
        eParamFontSize,1,eParamTextFont,0); 
  etext(text2,x+eParamTextValueDistance,y,...
        eParamFontSize,1,eParamValueFont,0); 
  eParamPos(2)=eParamPos(2)-eParamLineDistance;
