% standard plot
eopen('demo2.eps')                      % open eps-file and write eps-head

eglobpar                                % get access to global parameters
ePlotTitleText='Standard Plot';         % set title
eXAxisSouthLabelText='Angle [rad]';     % set South Label of XAxis
eYAxisWestLabelText='Range [km]';       % set West Label of YAxis
eYAxisEastLabelText='Outlook';          % set East Label of YAxis
eXAxisNorthVisible=0;                   % switch North-XAxis off
eYAxisEastValueVisible=0;               % switch East-YAxis Values off
eXGridVisible=1;                        % switch x-Grid on
eYGridVisible=1;                        % switch y-Grid on

etext('only demo',eWinWidth/2,eWinHeight/2,40,0,1,...   %print text
     atan(eWinHeight/eWinWidth)*180/pi,[0.8 0.8 0.8])
eaxes([0 0 6],[0 10 50])               % scale axes

% 1. plot street 
x=0:0.1:2*pi;
eplot(x,sin(x)*15+30,'street',0,[1 0 0]) %solid line 
eplot(x,sin(x)*15+33,'',1,[1 0 0]) % dash plot
eplot(x,sin(x)*15+36,'',0,[1 0 0]) % solid line

% 2. plot trees
x=0:0.5:2*pi;
edsymbol('star','star.psd',0.5,0.5)     % define symbol with name 'tree',r=5 mm
eplot(x,cos(x)*10+20,'tree','star',[0 0.7 0])

% 3. plot lake
lake=[1 30;1.3 35;1.5 32;2 40;2.5 25;1.6 15;1.4 17;1.2 24;1 30];
eplot(lake(:,1),lake(:,2),'water',-1,[0 0 1]); % filled area,dash<0

eParamPos=[30,50];
eparam('Altitude','232 m')     % print parameter
eparam('Power','100 W')

eclose                                  % close ps output
eview                                   % start ghostview with eps-file
