## Copyright (C) 1996, 1997  Kurt Hornik
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## Given a date string in the pseudo ISO form
##	"year month day hour min sec tz",
## where only the first three are necessary, return the corresponding
## time structure ts.

## This is only necessary as long as strptime () does not exist.

## Author:  KH <Kurt.Hornik@ci.tuwien.ac.at>
## Description:  Convert ISO date to time structure
  
function ts = ts_from_ISO_date (d)

  [year mon day hour min sec tz] \
      = sscanf (d, "%d %d %d %d %d %d %s", "C");
  ts = gmtime (0);
  ts.year = year - 1900;
  ts.mon = mon - 1;
  ts.mday = day;
  if (!isempty (hour)) ts.hour = hour; endif
  if (!isempty (min)) ts.min = min; endif
  if (!isempty (sec)) ts.sec = sec; endif
  if (!isempty (tz)) ts.zone = tz; endif

  ts = gmtime (mktime (ts));

endfunction
