/* Copyright (C) 1999 Aaron Lehmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#include <stdio.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include "gtkplot.h"
#include "gtksheet.h"

#include "app.h"
#include "gtkplot.h"
#include "callbacks.h"
#include "calc.h"
#include "data.h"
#include "menus.h"
#include "version.h"

void get_main_menu (GtkWidget *window, GtkWidget **menubar)
{

    
    /* Menu layout struct */
    GtkItemFactoryEntry menu_items[] =
    {
	{ _("/_File"),                                NULL,         NULL,                0, "<Branch>"    },
	/*{ _("/_File/L_oad function set..."),          "<control>O", callback_load,       0, NULL          },
	{ _("/_File/S_ave function set..."),          "<control>A",  callback_save,      0, NULL          },
	{ _("/_File/sep0"),                           NULL,         NULL,                0, "<Separator>" },*/
	{ _("/_File/_Export graph to image..."),      "<control>E", callback_export,     0, NULL          },
	{ _("/_File/E_xport graph to PostScript..."), "<control>X", callback_export_ps,  0, NULL          },
	{ _("/_File/sep1"),                           NULL,         NULL,                0, "<Separator>" },
	{ _("/_File/_Print graph..."),                "<control>P", callback_print,      0, NULL          },
	{ _("/_File/sep2"),                           NULL,         NULL,                0, "<Separator>" },
	{ _("/_File/_Quit"),                          "<control>Q", gtk_main_quit,       0, NULL          },
	{ _("/_View"),                                NULL,         NULL,                0, "<Branch>"    },
	{ _("/_View/_Zoom In"),                       "<control>Z", callback_zoom_in,    0, NULL          },
	{ _("/_View/_Zoom Out"),                      "<alt>Z",     callback_zoom_out,   0, NULL          },
	{ _("/_View/sep3"),                           NULL,         NULL,                0, "<Separator>" },
	{ _("/_View/Scroll _Left"),                   "<control>L", callback_scroll_l,   0, NULL          },
	{ _("/_View/Scroll _Right"),                  "<control>R", callback_scroll_r,   0, NULL          },
	{ _("/_View/Scroll _Up"),                     "<control>U", callback_scroll_u,   0, NULL          },
	{ _("/_View/Scroll _Down"),                   "<control>D", callback_scroll_d,   0, NULL          },
	{ _("/_Labels"),                              NULL,         NULL,                0, "<Branch>"    },
	{ _("/_Labels/Set X label..."),               NULL,         callback_label_x,    0, NULL          },
	{ _("/_Labels/Set Y label..."),               NULL,         callback_label_y,    0, NULL          },
	/*{ _("/_Calculation"),                         NULL,         NULL,                0, "<Branch>"    },
	  { _("/_Calculation/Find Y for X value..."),   NULL,         callback_value,      0, NULL          },*/
	{ _("/_Labels/Set plot title..."),            NULL,         callback_label_title,0, NULL          },
	/*{ _("/_Data"),                                NULL,         NULL,                0, "<Branch>"    },
	  { _("/_Data/Edit..."),                        NULL,         data_edit,           0, NULL          },*/
	/*{ _("/_Data/sep4"),                           NULL,         NULL,                0, "<Separator>" },*/
	{ _("/S_ettings"),                            NULL,         NULL,                0, "<Branch>"    },
	{ _("/S_ettings/Pre_ferences"),               "<control>F", callback_prefs,      0, NULL          },
	{ _("/_Windows"),                             NULL,         NULL,                0, "<Branch>"    },
	{ _("/_Windows/_Show calculator"),            "<control>S", calc_show,           0, NULL          },
	{ _("/_Windows/_Hide calculator"),            "<control>H", (GtkSignalFunc)calc_hide,0, NULL      },
	{ _("/_Windows/sep5"),                        NULL,         NULL,                0, "<Separator>" },
	{ _("/_Windows/Show range selection"),        "<alt>S",     callback_ctl_show,   0, NULL          },
	{ _("/_Windows/Hide range selection"),        "<alt>H",    (GtkSignalFunc)callback_ctl_hide,0,NULL},
	{ _("/_Windows/sep5"),                        NULL,         NULL,                0, "<Separator>" },
	{ _("/_Windows/Show data"),                   NULL,         data_edit,           0, NULL          },
	{ _("/_Windows/Hide data"),                   NULL,         (GtkSignalFunc)data_hide,0,NULL       },
	{ _("/Help"),                                 NULL,         NULL,                0, "<Branch>"    },
	{ _("/Help/About GtkGraph"),                  NULL,         callback_about,      0, NULL          }
    };
    
    
    GtkItemFactory *item_factory;
    GtkAccelGroup *accel_group;
    gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
    
    
    accel_group = gtk_accel_group_new ();
    
    item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", accel_group);
    
    gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);
    
    gtk_window_add_accel_group (GTK_WINDOW(window), item_factory->accel_group);
    
    if (menubar)
	*menubar = gtk_item_factory_get_widget (item_factory, "<main>");
}

