/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"
#include <math.h>

/*-----------------------------------------------------------------------
 * Function:	Tm3Copy
 * Description:	copy a transform
 * Args:	Tsrc: source transform  (INPUT)
 *		Tdst: destination transform (OUTPUT)
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 15:40:09 1991
 * Notes:	
 */
void
Tm3Copy( Tsrc, Tdst )
    Transform3 Tsrc, Tdst;
{
    memcpy( (char *)Tdst, (char *)Tsrc, sizeof(Transform3) );
}

/*-----------------------------------------------------------------------
 * Function:	Tm3Compare
 * Description:	compare 2 transforms
 * Args:	T1, T2: the two transforms
 *		tol: tolerance
 * Returns:	1 if equal, 0 if not
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 15:40:09 1991
 * Notes:	"equal" means corresponding elements are within tol of
 *		each other.
 */
int
Tm3Compare( Transform3 T1, Transform3 T2, float tol )
{
    int i,j;
    double d;
    for (i=0; i<4; ++i)
      for (j=0; j<4; ++j) {
	d = T1[i][j] - T2[i][j];
	if (fabs(d) > tol) {
	  return 0;
	}
      }
    return 1;
}

