#
# save.tcl
#

proc save(go) {} {
    global Save Load

    # check file for output
    set filename $Save(Directory)/$Save(Filename)
    if { [iswritable $filename] == 0 } { return 0 }

    tcl_to_pm Load
    tcl_to_pm Save

  # Format: 2 = DsTool 2.0 format, 3 = DsTool_Tk format
    switch $Load(Format_Flag) {
        2 {pm EXEC Save.Go}
        3 {
            set f [open $filename w]
            save(header) $f
            if { $Save(Settings) } { save(model) $f }
            if { $Save(Config)   } { save(config) $f }
            if { $Save(Settings) } { save(settings) $f }
	    if { $Save(Traj) } { save(traj) $f }
	    if { $Save(Fixpt) } { save(fixpt) $f }
	    if { $Save(Cont) } { save(cont) $f }
	    if { $Save(Param) } { save(cont) $f }
	    if { $Save(Select) } { save(select) $f }
	    if { $Save(Funct) } { save(funct) $f }
            close $f
          }
        default {return 0}
        }
    return 1
}

proc save(header) f {
    puts $f "\#"
    puts $f "\# DsTool Tk"
    puts $f "\# [exec whoami]"
    puts $f "\# [exec date]"
    puts $f "\#\n"
}

proc save(config) f {
    global window

    puts $f "\# Open and position windows"
    foreach w $window(names) {
	if {[string compare $w save] != 0} {
	    puts $f "window(open) $w"
	    set geom [wm geometry .$w]
	    regsub {^[0-9]+\x[0-9]+\+} $geom "+" geom_pos
	    puts $f "window(geometry) $w $geom_pos"
	}
    }
    puts $f ""
}

proc save(config_2) filename {
    global window

    set f [open $filename w]
    foreach w $window(names) {
        if {[string compare $w save] != 0} {
            puts $f "pm PUT Win.Current $w"
            set geom [wm geometry .$w]
	    regsub {\x} $geom " " geom_1
            regsub {\+} $geom_1 " " geom_2
            regsub {\+} $geom_2 " " geom_pos
            puts $f "pm PUT_LIST Win.Locn.$w 0 3 $geom_pos"
            puts $f "pm EXEC Win.Open_Current"
            puts $f ""
        }
    }
    close $f

}


proc save(model) f {
    global Model

    puts $f "\# Load model"
    puts $f "load_model_by_name \{$Model(Name)\}\n"

}

proc save(settings) f {
    
    puts $f "\# Settings save not enabled yet\n\n"
}

proc save(traj) f {

    puts $f "\# Trajectories save not enabled yet\n\n"
}

proc save(fixpt) f {

    puts $f "\# Fixed Points save not enabled yet\n\n"
}

proc save(cont) f {

    puts $f "\# Continuation points save not enabled yet\n\n"
}

proc save(param) f {
 
    puts $f "\# Parameter points save not enabled yet\n\n"
}

proc save(select) f {
 
    puts $f "\# Selected points save not enabled yet\n\n"
}

proc save(funct) f {
  
    puts $f "\# Function values save not enabled yet\n\n"
}




proc iswritable fname {

    # if directory does not exist or is not writable return error
    set dir [file dirname $fname]
    if { ![file isdirectory $dir] } {return 0}
    if { ![file writable $dir] } {return 0}
   
    # if file does not exist then it is writable!
    if {![file exists $fname]} {return 1}

    # if file exists then check we can write over it
    if {![file writable $fname]} {return 0}

    return 1
}
