/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * control.c
 *
 * Procedures:
 *   control_install_init()
 *
 * Create and initialize CONTROL postmaster object
 *
 */
#include <stdio.h>

#include "constants.h"
#include "defaults.h"
#include "utilities.h"
#include "pm.h"
#include "version.h"

static char *CONTROL_OBJ_NAME = "Control";

static char *CONTROL[] = { 
  "Control.Argc", "Control.Argv",
  "Control.Program_Name",
  "Control.Infile", "Control.Outfile",
  "Control.Dump_PM", "Control.Dump_PMHash",
  "Control.Set_Interrupt",
  "Control.Title", "Control.Version", "Control.Build_Info",
  "Control.Large"
};

typedef enum {
  ARGC=0, ARGV, PROGRAM_NAME, INFILE, OUTFILE,
  DUMP_PM, DUMP_PMHASH, SET_INTERRUPT,
  TITLE_STR, VERSION_STR, BUILD_INFO_STR,
  LARGE_TYPE
  } CONTROL_t;

void
  control_install()
{
  extern void 
    pm_dump(), pm_hash_dump();

  /* create CONTROL object and elements */
  pm(CREATE_OBJ, CONTROL_OBJ_NAME,
     CREATE_ELEM, CONTROL[ARGC], INT,
     CREATE_ELEM, CONTROL[ARGV], STRNG_LIST,
     CREATE_ELEM, CONTROL[PROGRAM_NAME], STRNG,
     CREATE_ELEM, CONTROL[INFILE], STRNG,
     CREATE_ELEM, CONTROL[OUTFILE], STRNG,
     CREATE_ELEM, CONTROL[DUMP_PM], FNCT,
     CREATE_ELEM, CONTROL[DUMP_PMHASH], FNCT, 
     CREATE_ELEM, CONTROL[SET_INTERRUPT], FNCT,
     CREATE_ELEM, CONTROL[TITLE_STR], STRNG,
     CREATE_ELEM, CONTROL[VERSION_STR], STRNG,
     CREATE_ELEM, CONTROL[BUILD_INFO_STR], STRNG,
     CREATE_ELEM, CONTROL[LARGE_TYPE], INT,
     NULL);

  /* initialize elements */
  pm(INIT, CONTROL[DUMP_PM],
     INIT, CONTROL[DUMP_PMHASH],
     INIT, CONTROL[INFILE],1,
     INIT, CONTROL[OUTFILE],1,
     INIT, CONTROL[TITLE_STR], MAX_LONG_STR,
     INIT, CONTROL[VERSION_STR], MAX_LONG_STR,
     INIT, CONTROL[BUILD_INFO_STR], MAX_LONG_STR,
     PUT, CONTROL[DUMP_PM], pm_dump,
     PUT, CONTROL[DUMP_PMHASH], pm_hash_dump, 
     PUT, CONTROL[SET_INTERRUPT], set_interrupt,
     PUT, CONTROL[TITLE_STR], PROGRAM_TITLE,
     PUT, CONTROL[VERSION_STR], VERSION,
     PUT, CONTROL[BUILD_INFO_STR], BUILD_INFO,
     PUT, CONTROL[LARGE_TYPE], FALSE,
     NULL);
}
