/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "segment.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *font_gc;

// Common methods for segment objects
void segment_c::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this segment %1"));
  strinsmsg (nom_type, nom, "%1");
}
void segment_c::
dessine (GdkPixmap * ecran, char force)
{
  droite_s co;
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || !existe)
    return;
  co = coordonnees ();
  switch (epaisseur)
    {
    case 0:
      dotted_line (ecran, ECRx (co.a.x), ECRy (co.a.y), ECRx (co.b.x), ECRy (co.b.y), couleur, 1);
      break;
    case 1:
      dotted_line (ecran, ECRx (co.a.x), ECRy (co.a.y), ECRx (co.b.x), ECRy (co.b.y), couleur, 2);
      break;
    case 2:
      line_good_clip (ecran, ECRx (co.a.x), ECRy (co.a.y), ECRx (co.b.x), ECRy (co.b.y), couleur);
      break;
    case 3:
      thick_line (ecran, ECRx (co.a.x), ECRy (co.a.y), ECRx (co.b.x), ECRy (co.b.y), couleur, EPAIS);
      break;
    }
}
char segment_c::
appartient (int xm, int ym)
{
  droite_s co;
  vecteur_s n, ab, mb;
  double x, y;
  n = normal ();
  if (n.x == 0 && n.y == 0)
    return M1->appartient (xm, ym);
  co = coordonnees ();
  x = MONx (xm);
  y = MONy (ym);
  mb.x = co.b.x - x;
  mb.y = co.b.y - y;
  x -= co.a.x;
  y -= co.a.y;
  ab.x = co.b.x - co.a.x;
  ab.y = co.b.y - co.a.y;
  if (ABS (x * n.x + y * n.y) >= RI || (x * ab.x + y * ab.y) < 0 || (mb.x * ab.x + mb.y * ab.y) < 0)
    return FALSE;
  return TRUE;
}
// Segment defined by two points
void segment1::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this segment %1"));
  if ((strlen (M1->nom) + strlen (M2->nom) + 3) <= LONGUEUR_NOM && strlen (M1->nom) != 0 && strlen (M2->nom) != 0)
    sprintf (nom, "[%s%s]", M1->nom, M2->nom);
  strinsmsg (nom_type, nom, "%1");
}
char segment1::
dependance (figure_c * fig)
{
  return (M1 == fig || M2 == fig);
}
droite_s segment1::
coordonnees (void)
{
  p.a = M1->p;
  p.b = M2->p;
  return p;
}
void segment1::
actualise (void)
{
  if (!M1->existe || !M2->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p.a = M1->coordonnees ();
  p.b = M2->coordonnees ();
  if (ECRx (p.a.x) == ECRx (p.b.x) && ECRy (p.a.y) == ECRy (p.b.y))
    existe = FALSE;
}
liste_elem *segment1::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) M1);
  liste_parent->ajoute ((void *) M2);
  return liste_parent;
}
void segment1::
move (int xm, int ym)
{
  M1->move (xm, ym);
  M2->move (xm, ym);
  actualise ();
}
void segment1::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) M1);
  fwrite (&pos, 1, sizeof (pos), f);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) M2);
  fwrite (&pos, 1, sizeof (pos), f);
}
void segment1::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  M1 = (point_c *) liste_figure.lire (pos);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  M2 = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// Transformed segment
// By reflexion
char reflexion_segment::
dependance (figure_c * fig)
{
  return (axe == fig || segment == fig);
}
droite_s reflexion_segment::
coordonnees (void)
{
  droite_s co, co1;
  co = segment->coordonnees ();
  co1.a = reflexion_p (axe, co.a);
  co1.b = reflexion_p (axe, co.b);
  return co1;
}
void reflexion_segment::
actualise (void)
{
  if (!segment->existe || !axe->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s reflexion_segment::
normal (void)
{
  return reflexion_v (axe, segment->normal ());
}
vecteur_s reflexion_segment::
directeur (void)
{
  return reflexion_v (axe, segment->directeur ());
}
void reflexion_segment::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) axe);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) segment);
  fwrite (&pos, 1, sizeof (pos), f);
}
void reflexion_segment::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  axe = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  segment = (segment_c *) liste_figure.lire (pos);
  init_nom ();
}
// By symetry
char symetrie_segment::
dependance (figure_c * fig)
{
  return (symetrie == fig || segment == fig);
}
droite_s symetrie_segment::
coordonnees (void)
{
  droite_s co, co1;
  point_s c;
  c = 2 * (symetrie->coordonnees ());
  co = segment->coordonnees ();
  co1.a = c - co.a;
  co1.b = c - co.b;
  return co1;
}
void symetrie_segment::
actualise (void)
{
  if (!segment->existe || !symetrie->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s symetrie_segment::
normal (void)
{
  return segment->normal ();
}
vecteur_s symetrie_segment::
directeur (void)
{
  return segment->directeur ();
}
void symetrie_segment::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) symetrie);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) segment);
  fwrite (&pos, 1, sizeof (pos), f);
}
void symetrie_segment::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  symetrie = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  segment = (segment_c *) liste_figure.lire (pos);
  init_nom ();
}
// By translation
char translation_segment::
dependance (figure_c * fig)
{
  return (v == fig || segment == fig);
}
droite_s translation_segment::
coordonnees (void)
{
  droite_s co, co1;
  vecteur_s t;
  t = v->vecteur ();
  co = segment->coordonnees ();
  co1.a = co.a + t;
  co1.b = co.b + t;
  return co1;
}
void translation_segment::
actualise (void)
{
  if (!segment->existe || !v->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s translation_segment::
normal (void)
{
  return segment->normal ();
}
vecteur_s translation_segment::
directeur (void)
{
  return segment->directeur ();
}
liste_elem *translation_segment::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) segment);
  liste_parent->ajoute ((void *) v);
  return liste_parent;
}
void translation_segment::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) segment);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
}
void translation_segment::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  segment = (segment_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (vecteur_c *) liste_figure.lire (pos);
  init_nom ();
}
// By rotation
char rotation_segment::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || segment == fig);
}
droite_s rotation_segment::
coordonnees (void)
{
  droite_s co, co1;
  co = segment->coordonnees ();
  co1.a = rotation_p (c, v, co.a);
  co1.b = rotation_p (c, v, co.b);
  return co1;
}
void rotation_segment::
actualise (void)
{
  if (!segment->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s rotation_segment::
normal (void)
{
  return rotation_v (v, segment->normal ());
}
vecteur_s rotation_segment::
directeur (void)
{
  return rotation_v (v, segment->directeur ());
}
void rotation_segment::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) segment);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void rotation_segment::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  segment = (segment_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// By homothetie
char homothetie_segment::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || segment == fig);
}
droite_s homothetie_segment::
coordonnees (void)
{
  droite_s co, co1;
  co = segment->coordonnees ();
  co1.a = c->p + (co.a - c->p) * v->val;
  co1.b = c->p + (co.b - c->p) * v->val;
  return co1;
}
void homothetie_segment::
actualise (void)
{
  if (!segment->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s homothetie_segment::
normal (void)
{
  return (segment->normal ());
}
vecteur_s homothetie_segment::
directeur (void)
{
  return (segment->directeur ());
}
void homothetie_segment::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) segment);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void homothetie_segment::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  segment = (segment_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
