/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1998
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Geoeral Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef mode_obj_h
#define mode_obj_h

//Caracteristiques du tableau de codage des modes de creation d'une figure
#define NB_MODE_MAX 100
#define NB_OBJET_PAR_MODE_MAX 5
// Description des modes de creations
extern char mode1[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible1[6];
//
extern char mode2[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible2[4];
//
extern char mode3[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible3[1];
//
extern char mode4[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible4[1];
//
extern char mode5[3][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible5[3];
//
extern char mode6[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible6[15];
//
extern char mode7[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible7[5];
//
extern char mode8[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible8[5];
//
extern char mode9[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible9[7];
//
extern char mode10[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible10[6];
//
extern char mode11[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible11[7];
//
extern char mode12[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible12[7];
//
extern char mode13[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible13[7];
//
extern char mode14[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible14[2];
//
extern char mode15[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible15[4];
//
extern char mode16[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible16[1];
//
extern char mode17[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible17[2];
//
extern char mode18[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible18[85];
//
extern char mode19[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible19[1];
//
extern char mode20[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX];
extern char cas_possible20[7];
//
// Declarations des classes de creation d'objets
// Classe de base de creation de figure
class creer_figure_c
{
  public:
  creer_figure_c (char tmode[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX], char *tcas_possible)
  {
    init_class (tmode, tcas_possible);
  }
  init_class (char tmode[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX], char *tcas_possible)
  {
    int a, b;
    for (a = 0; a < NB_MODE_MAX; a++)
      {
	for (b = 0; b < NB_OBJET_PAR_MODE_MAX; b++)
	  {
	    mode[0][a][b] = tmode[0][a][b];
	    mode[1][a][b] = tmode[1][a][b];
	  }
	cas_possible[a] = tcas_possible[a];
      }
    detail = FALSE;		// valeur par defaut

  }
  char inserer_figure (liste_elem & selection, figure_c * new_fig);
  char utilisable (figure_c * fig);
  char utilisable1 (figure_c * fig, liste_elem & selection, figure_c * new_fig);
  char mode[2][NB_MODE_MAX][NB_OBJET_PAR_MODE_MAX], cas_possible[NB_MODE_MAX];
  char nb_mode, detail;
// detail==TRUE alors on utilise l'element classe pour comparer les objets (POINT_DR,..)
  // /sinon on utilise le type groupe de classes(FIG_POINT,...)
};
// Classe de creation de point libre sur objet
#define NB_MOD 6
class creer_point_c:public creer_figure_c
{
  public:
  creer_point_c ():creer_figure_c (mode1, cas_possible1)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode1, cas_possible1);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de droite
#undef NB_MOD
#define NB_MOD 4
class creer_droite_c:public creer_figure_c
{
  public:
  creer_droite_c ():creer_figure_c (mode2, cas_possible2)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode2, cas_possible2);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de demi-droite
#undef NB_MOD
#define NB_MOD 1
class creer_demi_droite_c:public creer_figure_c
{
  public:
  creer_demi_droite_c ():creer_figure_c (mode3, cas_possible3)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode3, cas_possible3);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de segment
#undef NB_MOD
#define NB_MOD 1
class creer_segment_c:public creer_figure_c
{
  public:
  creer_segment_c ():creer_figure_c (mode4, cas_possible4)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode4, cas_possible4);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de cercle
#undef NB_MOD
#define NB_MOD 3
class creer_cercle_c:public creer_figure_c
{
  public:
  creer_cercle_c ():creer_figure_c (mode5, cas_possible5)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode5, cas_possible5);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de point_inter
#undef NB_MOD
#define NB_MOD 15
class creer_point_inter_c:public creer_figure_c
{
  public:
  creer_point_inter_c ():creer_figure_c (mode6, cas_possible6)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode6, cas_possible6);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de droite_parallele
#undef NB_MOD
#define NB_MOD 5
class creer_droite_parallele_c:public creer_figure_c
{
  public:
  creer_droite_parallele_c ():creer_figure_c (mode7, cas_possible7)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode7, cas_possible7);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de droite_orthogonale
#undef NB_MOD
#define NB_MOD 5
class creer_droite_orthogonale_c:public creer_figure_c
{
  public:
  creer_droite_orthogonale_c ():creer_figure_c (mode8, cas_possible8)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode8, cas_possible8);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de transforme par reflexion
#undef NB_MOD
#define NB_MOD 7
class creer_reflexion_c:public creer_figure_c
{
  public:
  creer_reflexion_c ():creer_figure_c (mode9, cas_possible9)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode9, cas_possible9);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de transforme par symetrie
#undef NB_MOD
#define NB_MOD 6
class creer_symetrie_c:public creer_figure_c
{
  public:
  creer_symetrie_c ():creer_figure_c (mode10, cas_possible10)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode10, cas_possible10);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de transforme par translation
#undef NB_MOD
#define NB_MOD 7
class creer_translation_c:public creer_figure_c
{
  public:
  creer_translation_c ():creer_figure_c (mode11, cas_possible11)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode11, cas_possible11);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de transforme par rotation
#undef NB_MOD
#define NB_MOD 7
class creer_rotation_c:public creer_figure_c
{
  public:
  creer_rotation_c ():creer_figure_c (mode12, cas_possible12)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode12, cas_possible12);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de valeur numerique
#undef NB_MOD
#define NB_MOD 7
class creer_numerique_c:public creer_figure_c
{
  public:
  creer_numerique_c ():creer_figure_c (mode13, cas_possible13)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode13, cas_possible13);
    nb_mode = NB_MOD;
  }
};
// Classe de creation d'angle
#undef NB_MOD
#define NB_MOD 2
class creer_angle_c:public creer_figure_c
{
  public:
  creer_angle_c ():creer_figure_c (mode14, cas_possible14)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode14, cas_possible14);
    nb_mode = NB_MOD;
  }
};
// Classe de creation de coordonnees de points,vecteur, equation de droite et cercle
#undef NB_MOD
#define NB_MOD 4
class creer_coordonnees_c:public creer_figure_c
{
  public:
  creer_coordonnees_c ():creer_figure_c (mode15, cas_possible15)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode15, cas_possible15);
    nb_mode = NB_MOD;
  }
};
// Classe de creation d'un point a partir de ces coordonnees
#undef NB_MOD
#define NB_MOD 1
class creer_point_repere_c:public creer_figure_c
{
  public:
  creer_point_repere_c ():creer_figure_c (mode16, cas_possible16)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode16, cas_possible16);
    nb_mode = NB_MOD;
  }
};
// Classe de creation d'un point milieu d'un segemnt
#undef NB_MOD
#define NB_MOD 2
class creer_point_milieu_c:public creer_figure_c
{
  public:
  creer_point_milieu_c ():creer_figure_c (mode17, cas_possible17)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode17, cas_possible17);
    nb_mode = NB_MOD;
  }
};
// Classe de creation d'un lieu geometrique d'un point
#undef NB_MOD
#define NB_MOD 85
class creer_lieu_point_c:public creer_figure_c
{
  public:
  creer_lieu_point_c ():creer_figure_c (mode18, cas_possible18)
  {
    nb_mode = NB_MOD;
    detail = TRUE;
  }
  void reset (void)
  {
    init_class (mode18, cas_possible18);
    nb_mode = NB_MOD;
    detail = TRUE;
  }
};
// Classe de creation d'un arc de cercle
#undef NB_MOD
#define NB_MOD 1
class creer_arc_cercle_c:public creer_figure_c
{
  public:
  creer_arc_cercle_c ():creer_figure_c (mode19, cas_possible19)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode19, cas_possible19);
    nb_mode = NB_MOD;
  }
};
// Class of creation of scaled object
#undef NB_MOD
#define NB_MOD 7
class creer_homothetie_c:public creer_figure_c
{
  public:
  creer_homothetie_c ():creer_figure_c (mode20, cas_possible20)
  {
    nb_mode = NB_MOD;
  }
  void reset (void)
  {
    init_class (mode20, cas_possible20);
    nb_mode = NB_MOD;
  }
};
#endif
