/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or mdify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <libintl.h>
#include <stdlib.h>

// The main menu icones
#include "icones/point_menu.xpm"
#include "icones/line_menu.xpm"
#include "icones/transformation_menu.xpm"
#include "icones/numeric_menu.xpm"
#include "icones/macro_menu.xpm"
#include "icones/tools_menu.xpm"
// The point sub menu icones
#include "icones/free_point.xpm"
#include "icones/middle.xpm"
#include "icones/intersection_point.xpm"
#include "icones/point_coordinate.xpm"
// The line sub menu icones
#include "icones/line.xpm"
#include "icones/half_line.xpm"
#include "icones/segment.xpm"
#include "icones/vectrex.xpm"
#include "icones/circle.xpm"
#include "icones/circle_arc.xpm"
#include "icones/locus.xpm"
// The transformation sub menu icones
#include "icones/parallel.xpm"
#include "icones/perpendicular.xpm"
#include "icones/axial_symetry.xpm"
#include "icones/central_symetry.xpm"
#include "icones/translation.xpm"
#include "icones/rotation.xpm"
#include "icones/homothetie.xpm"
// The numeric sub menu icones
#include "icones/distance.xpm"
#include "icones/angle.xpm"
#include "icones/coordinates.xpm"
// The numeric sub menu icones
#include "icones/build_macro.xpm"
#include "icones/run_macro.xpm"
// The numeric sub menu icones
#include "icones/move.xpm"
#include "icones/styles.xpm"
#include "icones/preferences.xpm"
#include "icones/eraser.xpm"
#include "icones/new_figure.xpm"
#include "icones/save.xpm"
#include "icones/load.xpm"
#include "icones/quit.xpm"
// The style line for the style dialog box
#include "icones/dotline.xpm"
#include "icones/dashline.xpm"
#include "icones/normalline.xpm"
#include "icones/largeline.xpm"
// The style point shape for the style dialog box
#include "icones/square.xpm"
#include "icones/round.xpm"
#include "icones/cross.xpm"
#include "icones/fill.xpm"

#include "gui.h"
#include "geoclass.h"
#include "mode_obj.h"
#include "main.h"
#include "traite.h"
#include "define.h"

#define EVENT_METHOD(i, x) GTK_WIDGET_CLASS(GTK_OBJECT(i)->klass)->x

extern liste_elem selection, sous_souris, liste_figure, liste_figure_libre,
  liste_i, liste_f;
extern liste_elem *flashing_list, liste_macro;
extern macro *selected_macro;
extern int mode, w_ecran, h_ecran;
extern double ECHELLE, ORIGIN_W, ORIGIN_H, MON_L, MON_R, MON_T, MON_B;
extern char trouve, moving_object, erasing;
extern int oldx, oldy, mx, my;
extern GdkGC *figure_gc;
extern GdkColor tab_couleur[];
extern char nom_fichier[];

// Where to draw the figure, next this buffer is copied to the drawin area
GdkPixmap *current_screen = NULL;

GtkWidget *main_window, *main_menu, *toolbar_menu, *iconw, *figure_drawing_area;
GtkWidget *hrule, *vrule, *statusbar;
GtkObject *hadjustment, *vadjustment;
GtkWidget *menu = NULL;

GtkWidget *point_button, *line_button, *trans_button, *value_button, *macro_button,
 *other_button;

GtkWidget *point_menu, *line_menu, *trans_menu, *value_menu, *macro_menu,
 *other_menu;
GtkWidget *point_toolbar, *line_toolbar, *trans_toolbar, *value_toolbar,
 *macro_toolbar, *other_toolbar;

GtkWidget *free_point_but, *middle_point_but, *intersection_point_but,
 *point_coordinate_but;
GtkWidget *line_but, *half_line_but, *segment_but, *vectrex_but, *circle_but,
 *arc_circle_but, *locus_but;
GtkWidget *parallel_but, *perpendicular_but, *asymetry_but, *csymetry_but,
 *translation_but, *rotation_but, *homothetie_but;
GtkWidget *distance_but, *angle_but, *coordinates_but;
GtkWidget *bmacro_but, *rmacro_but;
GtkWidget *move_but, *styles_but, *preferences_but, *eraser_but, *new_but,
 *save_but, *load_but, *quit_but;

GdkPixmap *icon;
GdkPixmap *buffer_affichage;
GdkBitmap *mask;

GdkFont *fontbulle, *fontobject;
GdkGC *font_gc, *object_gc;

// the button on the style dialog box
GtkWidget *dialog_style, *table_style, *color_button[12], *size_button[4];
GtkWidget *shape_button[3], *fill_button, *entry_change_name, *entry_change_expression;
GtkStyle *color_style[12];
GSList *group_color, *group_size, *group_shape;
guint statusbar_context_id;

/* 
   dark       dark white       light white       white
   green      light green      blue              light green
   dark red   red              orange            yellow
 */

// erase dialog
GtkWidget *erase_dialog, *erase_label, *erase_ok, *erase_cancel;
//new figure dialog
GtkWidget *newfigure_dialog;
//fileselector to save a figure
GtkWidget *savefigure;
//fileselector to load a figure
GtkWidget *loadfigure;
// Builder Macro-construction dialog
GtkWidget *buildmacro_dialog, *input_buildmacro, *output_buildmacro, *macroname_dialog;
GtkWidget *macroname_entry;
GSList *group_buildmacro;
// Execution/load/save/delete/info macro-construction window
GtkWidget *execmacro_window, *macrolist, *macrotextinfo;
static int macro_selected_row = -1;	// in the macrolist
//Enter/change Value Dialog

GtkWidget *value_dialog, *value_entry;
// Class variable for the selection scheme of the constructable object
creer_point_c creer_point;
creer_point_milieu_c creer_point_milieu;
creer_point_inter_c creer_point_inter;
creer_point_repere_c creer_point_repere;
creer_droite_c creer_droite;
creer_demi_droite_c creer_demi_droite;
creer_segment_c creer_segment;
creer_demi_droite_c creer_vecteur;
creer_cercle_c creer_cercle;
creer_arc_cercle_c creer_arc_cercle;
creer_lieu_point_c creer_lieu_point;
creer_droite_parallele_c creer_droite_parallele;
creer_droite_orthogonale_c creer_droite_orthogonale;
creer_reflexion_c creer_reflexion;
creer_symetrie_c creer_symetrie;
creer_translation_c creer_translation;
creer_rotation_c creer_rotation;
creer_homothetie_c creer_homothetie;
creer_numerique_c creer_numerique;
creer_angle_c creer_angle;
creer_coordonnees_c creer_coordonnees;

// the bubble text area
int hb = -1, yb, xb, wb;
// hb==-1 means there was no previsious dispayed bubble text



// Dfinitions des fonctions
void 
set_tool_bar (void)
{
  /* une boite horizontale pour les icnes */

  // the window to put the vertical toolbar
  main_menu = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (main_menu), _ ("Tools"));
  gtk_widget_set_usize (GTK_WIDGET (main_menu), 48 + 6, (48 + 6) * 6);
  gtk_widget_realize (GTK_WIDGET (main_menu));
  gtk_window_position (GTK_WINDOW (main_menu), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (main_menu), FALSE, FALSE, FALSE);
  gtk_signal_connect (GTK_OBJECT (main_menu), "delete_event",
		      GTK_SIGNAL_FUNC (click_on_figure_event), NULL);


  toolbar_menu = gtk_toolbar_new (GTK_ORIENTATION_VERTICAL, GTK_TOOLBAR_ICONS);

  gtk_container_border_width (GTK_CONTAINER (toolbar_menu), 0);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (toolbar_menu), 0);

  gtk_container_add (GTK_CONTAINER (main_menu), toolbar_menu);


  /* The Point button menu */
  icon = gdk_pixmap_create_from_xpm_d (main_menu->window, &mask,
				       &main_menu->style->white,
				       point_menu_xpm);

  iconw = gtk_pixmap_new (icon, mask);
  point_button = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar_menu),
					  "point",
					  _ ("Point"),
					  "",
					  iconw,
					  GTK_SIGNAL_FUNC (point_event),
					  NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_menu));

  /* The Line button menu */
  icon = gdk_pixmap_create_from_xpm_d (main_menu->window, &mask,
				       &main_menu->style->white,
				       line_menu_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  line_button = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar_menu),
					 "shape",
					 _ ("Shape"),
					 "",
					 iconw,
					 GTK_SIGNAL_FUNC (lines_event),
					 NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_menu));

  /* The Transformation button menu */
  icon = gdk_pixmap_create_from_xpm_d (main_menu->window, &mask,
				       &main_menu->style->white,
				       transformation_menu_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  trans_button = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar_menu),
					  "transformation",
					  _ ("Transformation"),
					  "",
					  iconw,
				     GTK_SIGNAL_FUNC (transformation_event),
					  NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_menu));

  /* The Value button menu */
  icon = gdk_pixmap_create_from_xpm_d (main_menu->window, &mask,
				       &main_menu->style->white,
				       numeric_menu_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  value_button = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar_menu),
					  "value",
					  _ ("Numeric value"),
					  "",
					  iconw,
					  GTK_SIGNAL_FUNC (value_event),
					  NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_menu));

  /* The Macro-Construction button menu */
  icon = gdk_pixmap_create_from_xpm_d (main_menu->window, &mask,
				       &main_menu->style->white,
				       macro_menu_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  macro_button = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar_menu),
					  "macroconstruction",
					  _ ("Macro-construction"),
					  "",
					  iconw,
					  GTK_SIGNAL_FUNC (macro_event),
					  NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_menu));

  /* The Other button menu */
  icon = gdk_pixmap_create_from_xpm_d (main_menu->window, &mask,
				       &main_menu->style->white,
				       tools_menu_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  other_button = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar_menu),
					  "misc",
					  _ ("Misc"),
					  "",
					  iconw,
					  GTK_SIGNAL_FUNC (other_event),
					  NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar_menu));

  /* display the toolbar */
  gtk_widget_show (toolbar_menu);

}
void 
set_sub_menu (void)
{
  /* the horizontal sub menu toolbars */

  // The point sub menu toolbar
  point_menu = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_realize (GTK_WIDGET (point_menu));
  gtk_widget_set_usize (GTK_WIDGET (point_menu), (48 + 6) * 4, 48 + 6);
  gtk_window_position (GTK_WINDOW (point_menu), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (point_menu), FALSE, FALSE, FALSE);
  point_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);

  gtk_container_border_width (GTK_CONTAINER (point_toolbar), 0);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (point_toolbar), 0);

  gtk_container_add (GTK_CONTAINER (point_menu), point_toolbar);

  // free point
  icon = gdk_pixmap_create_from_xpm_d (point_menu->window, &mask,
				       &point_menu->style->white,
				       free_point_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  free_point_but = gtk_toolbar_append_item (GTK_TOOLBAR (point_toolbar),
					    "freepoint",
					    _ ("Free point"),
					    "",
					    iconw,
					 GTK_SIGNAL_FUNC (free_point_event),
					    NULL);
  // middle point
  icon = gdk_pixmap_create_from_xpm_d (point_menu->window, &mask,
				       &point_menu->style->white,
				       middle_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  middle_point_but = gtk_toolbar_append_item (GTK_TOOLBAR (point_toolbar),
					      "middle",
					      _ ("Middle"),
					      "",
					      iconw,
				       GTK_SIGNAL_FUNC (middle_point_event),
					      NULL);
  // intersection point
  icon = gdk_pixmap_create_from_xpm_d (point_menu->window, &mask,
				       &point_menu->style->white,
				       intersection_point_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  intersection_point_but = gtk_toolbar_append_item (GTK_TOOLBAR (point_toolbar),
						    "intersection",
						    _ ("Intersection point"),
						    "",
						    iconw,
				 GTK_SIGNAL_FUNC (intersection_point_event),
						    NULL);
  // point coordinates
  icon = gdk_pixmap_create_from_xpm_d (point_menu->window, &mask,
				       &point_menu->style->white,
				       point_coordinate_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  point_coordinate_but = gtk_toolbar_append_item (GTK_TOOLBAR (point_toolbar),
						  "coord",
				     _ ("Point defines by its coordinates"),
						  "",
						  iconw,
			     GTK_SIGNAL_FUNC (point_coordinate_point_event),
						  NULL);

  gtk_widget_show (point_toolbar);

  // The line sub menu toolbar
  line_menu = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_realize (GTK_WIDGET (line_menu));
  gtk_widget_set_usize (GTK_WIDGET (line_menu), (48 + 6) * 7, 48 + 6);
  gtk_window_position (GTK_WINDOW (line_menu), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (line_menu), FALSE, FALSE, FALSE);
  line_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);

  gtk_container_border_width (GTK_CONTAINER (line_toolbar), 0);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (line_toolbar), 0);

  gtk_container_add (GTK_CONTAINER (line_menu), line_toolbar);

  // line
  icon = gdk_pixmap_create_from_xpm_d (line_menu->window, &mask,
				       &line_menu->style->white,
				       line_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  line_but = gtk_toolbar_append_item (GTK_TOOLBAR (line_toolbar),
				      "line",
				      _ ("Line"),
				      "",
				      iconw,
				      GTK_SIGNAL_FUNC (line_event),
				      NULL);
  // half-line
  icon = gdk_pixmap_create_from_xpm_d (line_menu->window, &mask,
				       &line_menu->style->white,
				       half_line_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  half_line_but = gtk_toolbar_append_item (GTK_TOOLBAR (line_toolbar),
					   "halfline",
					   _ ("Half-line"),
					   "",
					   iconw,
					   GTK_SIGNAL_FUNC (half_line_event),
					   NULL);
  // segment
  icon = gdk_pixmap_create_from_xpm_d (line_menu->window, &mask,
				       &line_menu->style->white,
				       segment_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  segment_but = gtk_toolbar_append_item (GTK_TOOLBAR (line_toolbar),
					 "segment",
					 _ ("Segment"),
					 "",
					 iconw,
					 GTK_SIGNAL_FUNC (segment_event),
					 NULL);
  // vectrex
  icon = gdk_pixmap_create_from_xpm_d (line_menu->window, &mask,
				       &line_menu->style->white,
				       vectrex_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  vectrex_but = gtk_toolbar_append_item (GTK_TOOLBAR (line_toolbar),
					 "vector",
					 _ ("Vector"),
					 "",
					 iconw,
					 GTK_SIGNAL_FUNC (vectrex_event),
					 NULL);
  // circle
  icon = gdk_pixmap_create_from_xpm_d (line_menu->window, &mask,
				       &line_menu->style->white,
				       circle_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  circle_but = gtk_toolbar_append_item (GTK_TOOLBAR (line_toolbar),
					"circle",
					_ ("Circle"),
					"",
					iconw,
					GTK_SIGNAL_FUNC (circle_event),
					NULL);
  // arc circle
  icon = gdk_pixmap_create_from_xpm_d (line_menu->window, &mask,
				       &line_menu->style->white,
				       circle_arc_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  arc_circle_but = gtk_toolbar_append_item (GTK_TOOLBAR (line_toolbar),
					    "arc",
					    _ ("Arc circle"),
					    "",
					    iconw,
					 GTK_SIGNAL_FUNC (arc_circle_event),
					    NULL);
  // locus
  icon = gdk_pixmap_create_from_xpm_d (line_menu->window, &mask,
				       &line_menu->style->white,
				       locus_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  locus_but = gtk_toolbar_append_item (GTK_TOOLBAR (line_toolbar),
				       "locus",
				       _ ("Geometric locus"),
				       "",
				       iconw,
				       GTK_SIGNAL_FUNC (locus_event),
				       NULL);

  gtk_widget_show (line_toolbar);

  // The transformation sub menu toolbar
  trans_menu = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_realize (GTK_WIDGET (trans_menu));
  gtk_widget_set_usize (GTK_WIDGET (trans_menu), (48 + 6) * 7, 48 + 6);
  gtk_window_position (GTK_WINDOW (trans_menu), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (trans_menu), FALSE, FALSE, FALSE);
  trans_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);

  gtk_container_border_width (GTK_CONTAINER (trans_toolbar), 0);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (trans_toolbar), 0);

  gtk_container_add (GTK_CONTAINER (trans_menu), trans_toolbar);

  // parallel line
  icon = gdk_pixmap_create_from_xpm_d (trans_menu->window, &mask,
				       &trans_menu->style->white,
				       parallel_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  parallel_but = gtk_toolbar_append_item (GTK_TOOLBAR (trans_toolbar),
					  "Parallel",
					  _ ("Parallel line"),
					  "",
					  iconw,
					  GTK_SIGNAL_FUNC (parallel_event),
					  NULL);
  // perpendicular line
  icon = gdk_pixmap_create_from_xpm_d (trans_menu->window, &mask,
				       &trans_menu->style->white,
				       perpendicular_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  perpendicular_but = gtk_toolbar_append_item (GTK_TOOLBAR (trans_toolbar),
					       "perpendicular",
					       _ ("Perpendicular line"),
					       "",
					       iconw,
				      GTK_SIGNAL_FUNC (perpendicular_event),
					       NULL);
  // axial symetry
  icon = gdk_pixmap_create_from_xpm_d (trans_menu->window, &mask,
				       &trans_menu->style->white,
				       axial_symetry_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  asymetry_but = gtk_toolbar_append_item (GTK_TOOLBAR (trans_toolbar),
					  "asymetry",
					  _ ("Axial symetry"),
					  "",
					  iconw,
					  GTK_SIGNAL_FUNC (asymetry_event),
					  NULL);
  // central symetry
  icon = gdk_pixmap_create_from_xpm_d (trans_menu->window, &mask,
				       &trans_menu->style->white,
				       central_symetry_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  csymetry_but = gtk_toolbar_append_item (GTK_TOOLBAR (trans_toolbar),
					  "csymetrie",
					  _ ("Central symetry"),
					  "",
					  iconw,
					  GTK_SIGNAL_FUNC (csymetry_event),
					  NULL);
  // translation
  icon = gdk_pixmap_create_from_xpm_d (trans_menu->window, &mask,
				       &trans_menu->style->white,
				       translation_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  translation_but = gtk_toolbar_append_item (GTK_TOOLBAR (trans_toolbar),
					     "translation",
					     _ ("Translation"),
					     "",
					     iconw,
					GTK_SIGNAL_FUNC (translation_event),
					     NULL);
  // rotation
  icon = gdk_pixmap_create_from_xpm_d (trans_menu->window, &mask,
				       &trans_menu->style->white,
				       rotation_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  rotation_but = gtk_toolbar_append_item (GTK_TOOLBAR (trans_toolbar),
					  "rotation",
					  _ ("Rotation"),
					  "",
					  iconw,
					  GTK_SIGNAL_FUNC (rotation_event),
					  NULL);
  // homothetie
  icon = gdk_pixmap_create_from_xpm_d (trans_menu->window, &mask,
				       &trans_menu->style->white,
				       homothetie_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  homothetie_but = gtk_toolbar_append_item (GTK_TOOLBAR (trans_toolbar),
					    "scale",
					    _ ("Scale"),
					    "",
					    iconw,
					 GTK_SIGNAL_FUNC (homothetie_event),
					    NULL);
  gtk_widget_show (trans_toolbar);

  // The numeric sub menu toolbar
  value_menu = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_realize (GTK_WIDGET (value_menu));
  gtk_widget_set_usize (GTK_WIDGET (value_menu), (48 + 6) * 3, 48 + 6);
  gtk_window_position (GTK_WINDOW (value_menu), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (value_menu), FALSE, FALSE, FALSE);
  value_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);

  gtk_container_border_width (GTK_CONTAINER (value_toolbar), 0);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (value_toolbar), 0);

  gtk_container_add (GTK_CONTAINER (value_menu), value_toolbar);

  // distance
  icon = gdk_pixmap_create_from_xpm_d (value_menu->window, &mask,
				       &value_menu->style->white,
				       distance_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  distance_but = gtk_toolbar_append_item (GTK_TOOLBAR (value_toolbar),
					  "distance",
					  _ ("Distance & length"),
					  "",
					  iconw,
					  GTK_SIGNAL_FUNC (distance_event),
					  NULL);
  // angle
  icon = gdk_pixmap_create_from_xpm_d (value_menu->window, &mask,
				       &value_menu->style->white,
				       angle_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  angle_but = gtk_toolbar_append_item (GTK_TOOLBAR (value_toolbar),
				       "angle",
				       _ ("Angle"),
				       "",
				       iconw,
				       GTK_SIGNAL_FUNC (angle_event),
				       NULL);
  // coordinates
  icon = gdk_pixmap_create_from_xpm_d (value_menu->window, &mask,
				       &value_menu->style->white,
				       coordinates_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  coordinates_but = gtk_toolbar_append_item (GTK_TOOLBAR (value_toolbar),
					     "coordonnea",
					     _ ("Coordonnea & equation"),
					     "",
					     iconw,
					 GTK_SIGNAL_FUNC (coordinate_event),
					     NULL);
  gtk_widget_show (value_toolbar);

  // The macro-construction sub menu toolbar
  macro_menu = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_realize (GTK_WIDGET (macro_menu));
  gtk_widget_set_usize (GTK_WIDGET (macro_menu), (48 + 6) * 2, 48 + 6);
  gtk_window_position (GTK_WINDOW (macro_menu), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (macro_menu), FALSE, FALSE, FALSE);
  macro_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);

  gtk_container_border_width (GTK_CONTAINER (macro_toolbar), 0);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (macro_toolbar), 0);

  gtk_container_add (GTK_CONTAINER (macro_menu), macro_toolbar);

  // build a macro
  icon = gdk_pixmap_create_from_xpm_d (macro_menu->window, &mask,
				       &macro_menu->style->white,
				       build_macro_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  bmacro_but = gtk_toolbar_append_item (GTK_TOOLBAR (macro_toolbar),
					"bmacro",
					_ ("Build a macro-construction"),
					"",
					iconw,
					GTK_SIGNAL_FUNC (bmacro_event),
					NULL);
  // run a macro
  icon = gdk_pixmap_create_from_xpm_d (macro_menu->window, &mask,
				       &macro_menu->style->white,
				       run_macro_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  rmacro_but = gtk_toolbar_append_item (GTK_TOOLBAR (macro_toolbar),
					"rmacro",
					_ ("Execute a macro-construction"),
					"",
					iconw,
					GTK_SIGNAL_FUNC (rmacro_event),
					NULL);
  gtk_widget_show (macro_toolbar);
  // The others sub menu toolbar
  other_menu = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_realize (GTK_WIDGET (other_menu));
  gtk_widget_set_usize (GTK_WIDGET (other_menu), (48 + 6) * 8, 48 + 6);
  gtk_window_position (GTK_WINDOW (other_menu), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (other_menu), FALSE, FALSE, FALSE);
  other_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);

  gtk_container_border_width (GTK_CONTAINER (other_toolbar), 0);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (other_toolbar), 0);

  gtk_container_add (GTK_CONTAINER (other_menu), other_toolbar);

  // move
  icon = gdk_pixmap_create_from_xpm_d (other_menu->window, &mask,
				       &other_menu->style->white,
				       move_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  move_but = gtk_toolbar_append_item (GTK_TOOLBAR (other_toolbar),
				      "move",
				      _ ("Move an object"),
				      "",
				      iconw,
				      GTK_SIGNAL_FUNC (move_event),
				      NULL);
  // style
  icon = gdk_pixmap_create_from_xpm_d (other_menu->window, &mask,
				       &other_menu->style->white,
				       styles_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  styles_but = gtk_toolbar_append_item (GTK_TOOLBAR (other_toolbar),
					"style",
					_ ("Change the style of an object"),
					"",
					iconw,
					GTK_SIGNAL_FUNC (styles_event),
					NULL);
  // preference
  icon = gdk_pixmap_create_from_xpm_d (other_menu->window, &mask,
				       &other_menu->style->white,
				       preferences_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  preferences_but = gtk_toolbar_append_item (GTK_TOOLBAR (other_toolbar),
					     "preferences",
					     _ ("Preferences"),
					     "",
					     iconw,
					GTK_SIGNAL_FUNC (preferences_event),
					     NULL);
  // eraser
  icon = gdk_pixmap_create_from_xpm_d (other_menu->window, &mask,
				       &other_menu->style->white,
				       eraser_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  preferences_but = gtk_toolbar_append_item (GTK_TOOLBAR (other_toolbar),
					     "eraser",
					     _ ("Erase an object"),
					     "",
					     iconw,
					     GTK_SIGNAL_FUNC (eraser_event),
					     NULL);
  // new figure
  icon = gdk_pixmap_create_from_xpm_d (other_menu->window, &mask,
				       &other_menu->style->white,
				       new_figure_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  new_but = gtk_toolbar_append_item (GTK_TOOLBAR (other_toolbar),
				     "new",
				     _ ("New figure"),
				     "",
				     iconw,
				     GTK_SIGNAL_FUNC (new_event),
				     NULL);
  // save
  icon = gdk_pixmap_create_from_xpm_d (other_menu->window, &mask,
				       &other_menu->style->white,
				       save_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  save_but = gtk_toolbar_append_item (GTK_TOOLBAR (other_toolbar),
				      "save",
				      _ ("Save the figure"),
				      "",
				      iconw,
				      GTK_SIGNAL_FUNC (save_event),
				      NULL);
  // load
  icon = gdk_pixmap_create_from_xpm_d (other_menu->window, &mask,
				       &other_menu->style->white,
				       load_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  load_but = gtk_toolbar_append_item (GTK_TOOLBAR (other_toolbar),
				      "load",
				      _ ("Load a figure"),
				      "",
				      iconw,
				      GTK_SIGNAL_FUNC (load_event),
				      NULL);
  // quit
  icon = gdk_pixmap_create_from_xpm_d (other_menu->window, &mask,
				       &other_menu->style->white,
				       quit_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  quit_but = gtk_toolbar_append_item (GTK_TOOLBAR (other_toolbar),
				      "quit",
				      _ ("Quit"),
				      "",
				      iconw,
				      GTK_SIGNAL_FUNC (quit_event),
				      NULL);
  gtk_widget_show (other_toolbar);


}
// hide the sub menu called from the menu bar
void 
hide_sub_menu (void)
{
  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (point_menu)))
    gtk_widget_hide (GTK_WIDGET (point_menu));
  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (line_menu)))
    gtk_widget_hide (GTK_WIDGET (line_menu));
  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (trans_menu)))
    gtk_widget_hide (GTK_WIDGET (trans_menu));
  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (value_menu)))
    gtk_widget_hide (GTK_WIDGET (value_menu));
  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (macro_menu)))
    gtk_widget_hide (GTK_WIDGET (macro_menu));
  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (other_menu)))
    gtk_widget_hide (GTK_WIDGET (other_menu));
}

void 
motion_on_figure_area_event (GtkWidget * widget, GdkEventMotion * event, gpointer data)
{
  int x1, y1;
  GdkModifierType state;

  if (event->is_hint)
    gdk_window_get_pointer (event->window, &x1, &y1, &state);
  else
    {
      x1 = (int) event->x;
      y1 = (int) event->y;
      state = (GdkModifierType) event->state;
    }
  if (moving_object && (state & GDK_BUTTON1_MASK))
    souris_select (x1, y1, (figure_c *) selection.lire (1));
  else
    moving_object = FALSE;
  oldx = x1;
  oldy = y1;

  // we don't want bubble text while we move an object
  if (moving_object)
    return;

  // the valids selectable object depend on the mode we are
  switch (mode)
    {
    case POINT_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_point, &selection);
      break;
    case POINT_MILIEU_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_point_milieu, &selection);
      break;
    case POINT_INTER_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_point_inter, &selection);
      break;
    case POINT_REPERE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_point_repere, &selection);
      break;
    case DROITE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_droite, &selection);
      break;
    case DEMI_DROITE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_demi_droite, &selection);
      break;
    case SEGMENT_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_segment, &selection);
      break;
    case VECTEUR_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_vecteur, &selection);
      break;
    case CERCLE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_cercle, &selection);
      break;
    case ARC_CERCLE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_arc_cercle, &selection);
      break;
    case LIEU_POINT_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_lieu_point, &selection);
      break;
    case DROITE_PARALLELE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_droite_parallele, &selection);
      break;
    case DROITE_ORTHOGONALE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_droite_orthogonale, &selection);
      break;
    case REFLEXION_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_reflexion, &selection);
      break;
    case SYMETRIE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_symetrie, &selection);
      break;
    case TRANSLATION_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_translation, &selection);
      break;
    case ROTATION_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_rotation, &selection);
      break;
    case HOMOTHETIE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_homothetie, &selection);
      break;
    case NUMERIQUE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_numerique, &selection);
      break;
    case ANGLE_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_angle, &selection);
      break;
    case COORDONNEES_MODE:
      trouve = fig_sous_souris (&sous_souris, &creer_coordonnees, &selection);
      break;
    case MACRO_ENREGISTRE_MODE:
      trouve = fig_du_plan_sous_souris (&sous_souris, &liste_figure, TRUE);
      break;
    case MACRO_PLAY_MODE:
      if (selected_macro != NULL)
	trouve = fig_sous_souris (&sous_souris, selected_macro->lire (selection.nb_elem + 1)->type);
      else
	trouve = FALSE;
      break;
    case SOURIS_SELECT_MODE:
      trouve = fig_du_plan_sous_souris (&sous_souris, &liste_figure_libre, FALSE);
      break;
    case MISE_EN_FORME_MODE:
      trouve = fig_du_plan_sous_souris (&sous_souris, &liste_figure, TRUE);
      break;
    case EFFACE_OBJET_MODE:
      trouve = fig_du_plan_sous_souris (&sous_souris, &liste_figure, FALSE);
      break;
    }

  // do we need to remove the bubble text ?
  if ((xb != x1 || yb != y1 || !trouve) && hb != -1)
    {
      gdk_draw_pixmap (figure_drawing_area->window,
		       figure_drawing_area->style->fg_gc[GTK_WIDGET_STATE
						     (figure_drawing_area)],
		       current_screen,
		       xb, yb - hb,
		       xb, yb - hb,
		       wb, hb + 3);
      hb = -1;
    }
  // check if there is objects under the mouse pointer
  if (trouve && (xb != x1 || yb != y1) && hb == -1)
    {
      if (sous_souris.nb_elem > 1)
	{
	  xb = x1;
	  yb = y1;
	  wb = gdk_string_width (fontbulle, "???");
	  hb = gdk_string_height (fontbulle, "???");
	  gdk_draw_string (figure_drawing_area->window, fontbulle, font_gc, xb, yb, "???");
	}
      else
	{
	  gchar *nom;
	  xb = x1;
	  yb = y1;
	  nom = ((figure_c *) sous_souris.lire (1))->nom_type;
	  wb = gdk_string_width (fontbulle, nom);
	  hb = gdk_string_height (fontbulle, nom);
	  gdk_draw_string (figure_drawing_area->window, fontbulle, font_gc, xb, yb, nom);
	}
    }
}
void 
delete_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  gtk_main_quit ();
}
gint 
click_on_figure_event (GtkWidget * widget, GdkEventButton * event, gpointer data)
{
  if (event->button == 3)
    {
      if (GTK_WIDGET_VISIBLE (GTK_WIDGET (main_menu)))
	{
	  gtk_widget_hide (GTK_WIDGET (main_menu));
	  hide_sub_menu ();
	}
      else
	{
	  gtk_widget_show (GTK_WIDGET (main_menu));
	  // do we need to make some cleaning when we call the vertical menu bar ?
	  if (mode == EFFACE_OBJET_MODE)
	    erase_event (erase_dialog, (gpointer) 2);	// close the erase dialog and make some cleaning

	  else if (mode == MACRO_ENREGISTRE_MODE && GTK_WIDGET_VISIBLE (buildmacro_dialog))
	    buildmacro_delete_event (buildmacro_dialog, NULL);
	  else if (mode == MACRO_PLAY_MODE)
	    {
	      gtk_clist_unselect_row (GTK_CLIST (macrolist), macro_selected_row, 0);
	      gtk_widget_hide (execmacro_window);
	    }
	  else if (mode == MISE_EN_FORME_MODE)
	    {
	      fin_clignote (&selection);
	      tapisser (current_screen);
	      dessine_figure ();
	      swap ();
	    }
	}
    }
  else if (event->button == 1)
    {
      gtk_widget_hide (GTK_WIDGET (main_menu));
      hide_sub_menu ();
      // draw(figure_drawing_area,current_screen);
      // in wich mode are we ?
      switch (mode)
	{
	case POINT_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_point, &selection);
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    point_libre ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case POINT_MILIEU_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_point_milieu, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    point_milieu ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case POINT_INTER_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_point_inter, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    point_inter ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case POINT_REPERE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_point_repere, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    point_repere ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case DROITE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_droite, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    droite ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case DEMI_DROITE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_demi_droite, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    demi_droite ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case SEGMENT_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_segment, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    segment ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case VECTEUR_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_vecteur, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    vecteur ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case CERCLE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_cercle, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    cercle ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case ARC_CERCLE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_arc_cercle, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    arc_cercle ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case LIEU_POINT_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_lieu_point, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    lieu_objet ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case DROITE_PARALLELE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_droite_parallele, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    droite_parallele ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case DROITE_ORTHOGONALE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_droite_orthogonale, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    droite_orthogonale ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case REFLEXION_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_reflexion, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    reflexion ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case SYMETRIE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_symetrie, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    symetrie ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case TRANSLATION_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_translation, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    translation ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case HOMOTHETIE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_homothetie, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    homothetie ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case NUMERIQUE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_numerique, &selection);
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    numerique ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case ANGLE_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_angle, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    angle ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case COORDONNEES_MODE:
	  trouve = fig_sous_souris (&sous_souris, &creer_coordonnees, &selection);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    coordonnees ((int) event->x, (int) event->y, (figure_c *) sous_souris.lire (1));
	  break;
	case MACRO_ENREGISTRE_MODE:
	  trouve = fig_du_plan_sous_souris (&sous_souris, &liste_figure, TRUE);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    macro_enregistre ((figure_c *) sous_souris.lire (1), gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (input_buildmacro)) ? 0 : 1);
	  break;
	case MACRO_PLAY_MODE:
	  if (selected_macro != NULL)
	    trouve = fig_sous_souris (&sous_souris, selected_macro->lire (selection.nb_elem + 1)->type);
	  else
	    trouve = FALSE;
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    macro_play ((figure_c *) sous_souris.lire (1));
	  break;
	case SOURIS_SELECT_MODE:
	  if (moving_object == TRUE)
	    break;
	  trouve = fig_du_plan_sous_souris (&sous_souris, &liste_figure_libre, FALSE);
	  if (selection.nb_elem == 1 && sous_souris.position (selection.lire (1)) != 0)
	    moving_object = TRUE;
	  else if (sous_souris.nb_elem > 1)
	    {
	      //fin_clignote(&selection);
	      selection.vide ();
	      choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	    }
	  else if (sous_souris.nb_elem == 1)
	    {
	      selection.vide ();
	      fin_clignote (&selection);
	      selection.ajoute (sous_souris.lire (1));
	      moving_object = TRUE;
	    }
	  else
	    fin_clignote (&selection);
	  break;
	case MISE_EN_FORME_MODE:
	  if (moving_object == TRUE)
	    break;
	  dessine_tout ();
	  swap ();
	  trouve = fig_du_plan_sous_souris (&sous_souris, &liste_figure, TRUE);
	  if (sous_souris.nb_elem > 1)
	    {
	      //fin_clignote(&selection);
	      selection.vide ();
	      choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	    }
	  else if (sous_souris.nb_elem == 1)
	    {
	      selection.vide ();
	      //fin_clignote(&selection);
	      selection.ajoute (sous_souris.lire (1));
	      moving_object = TRUE;
	    }
	  else
	    fin_clignote (&selection);
	  break;
	case EFFACE_OBJET_MODE:
	  trouve = fig_du_plan_sous_souris (&sous_souris, &liste_figure, FALSE);
	  if (!trouve)
	    break;
	  if (sous_souris.nb_elem > 1)
	    choisir_elem (&sous_souris, (int) event->x, (int) event->y, event->time);
	  else
	    efface_objet ((figure_c *) sous_souris.lire (1), 0);
	  break;
	}
      // adjust the style of the box regarding the first element selected
      adjust_style_dialog ();
    }
  return TRUE;
}

gint 
expose_event (GtkWidget * widget, GdkEventExpose * event, gpointer data)
{
  gdk_draw_pixmap (widget->window,
		   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		   current_screen,
		   event->area.x, event->area.y,
		   event->area.x, event->area.y,
		   event->area.width, event->area.height);
  return FALSE;
}
gint 
configure_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  if (current_screen)
    gdk_pixmap_unref (current_screen);

  current_screen = gdk_pixmap_new (figure_drawing_area->window,
				   figure_drawing_area->allocation.width,
				   figure_drawing_area->allocation.height,
				   -1);
  /* clear the current_screen */
  gdk_draw_rectangle (current_screen,
		      figure_drawing_area->style->white_gc,
		      TRUE,
		      0, 0,
		      figure_drawing_area->allocation.width,
		      figure_drawing_area->allocation.height);

  dessine_figure ();
  swap ();

  return TRUE;
}

//Event from the main toolbar
void 
point_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  hide_sub_menu ();
  gtk_widget_show (GTK_WIDGET (point_menu));
}
void 
lines_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  hide_sub_menu ();
  gtk_widget_show (GTK_WIDGET (line_menu));
}
void 
transformation_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  hide_sub_menu ();
  gtk_widget_show (GTK_WIDGET (trans_menu));
}
void 
value_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  hide_sub_menu ();
  gtk_widget_show (GTK_WIDGET (value_menu));
}
void 
macro_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  hide_sub_menu ();
  gtk_widget_show (GTK_WIDGET (macro_menu));
}
void 
other_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  hide_sub_menu ();
  gtk_widget_show (GTK_WIDGET (other_menu));
}

// Event from the point sub menu toolbar
void 
free_point_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_point.reset ();

  mode = POINT_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (point_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
middle_point_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_point_milieu.reset ();

  mode = POINT_MILIEU_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (point_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
intersection_point_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_point_inter.reset ();

  mode = POINT_INTER_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (point_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
point_coordinate_point_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_point_repere.reset ();

  mode = POINT_REPERE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (point_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
// line sub menu
void 
line_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_droite.reset ();

  mode = DROITE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (line_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
half_line_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_demi_droite.reset ();

  mode = DEMI_DROITE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (line_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
segment_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_segment.reset ();

  mode = SEGMENT_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (line_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
vectrex_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_vecteur.reset ();

  mode = VECTEUR_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (line_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
circle_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_cercle.reset ();

  mode = CERCLE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (line_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
arc_circle_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_arc_cercle.reset ();

  mode = ARC_CERCLE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (line_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
locus_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_lieu_point.reset ();

  mode = LIEU_POINT_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (line_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}

// transformation sub menu
void 
parallel_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_droite_parallele.reset ();

  mode = DROITE_PARALLELE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (trans_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
perpendicular_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_droite_orthogonale.reset ();

  mode = DROITE_ORTHOGONALE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (trans_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
asymetry_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_reflexion.reset ();

  mode = REFLEXION_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (trans_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
csymetry_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_symetrie.reset ();

  mode = SYMETRIE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (trans_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
translation_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_translation.reset ();

  mode = TRANSLATION_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (trans_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
rotation_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_rotation.reset ();

  mode = ROTATION_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (trans_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
homothetie_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_homothetie.reset ();

  mode = HOMOTHETIE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (trans_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
// numeric sub menu
void 
distance_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_numerique.reset ();

  mode = NUMERIQUE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (value_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
angle_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_angle.reset ();

  mode = ANGLE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (value_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
coordinate_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  // when we enter a creation mode : clear the list of selected object 
  fin_clignote (&selection);
  creer_coordonnees.reset ();

  mode = COORDONNEES_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (value_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
// macro sub menu
void 
bmacro_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  fin_clignote (&selection);
  mode = MACRO_ENREGISTRE_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (macro_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
  gtk_widget_show (buildmacro_dialog);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (input_buildmacro), TRUE);
  flashing_list = &liste_i;
}
void 
rmacro_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  fin_clignote (&selection);
  mode = MACRO_PLAY_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (macro_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));

  // select a macro if any
  selected_macro = NULL;
  if (liste_macro.nb_elem > 0)
    gtk_clist_select_row (GTK_CLIST (macrolist), 0, 0);
  else
    macro_selected_row = -1;
  gtk_widget_show (execmacro_window);
}
// other sub menu
void 
move_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  fin_clignote (&selection);
  selection.vide ();
  mode = SOURIS_SELECT_MODE;
  set_statusbar_msg (mode);
  tapisser (current_screen);
  dessine_figure ();
  swap ();
  gtk_widget_hide (GTK_WIDGET (other_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
styles_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  fin_clignote (&selection);
  selection.vide ();
  mode = MISE_EN_FORME_MODE;
  set_statusbar_msg (mode);
  tapisser (current_screen);
  dessine_tout ();
  swap ();
  gtk_widget_hide (GTK_WIDGET (other_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
  gtk_widget_show (GTK_WIDGET (dialog_style));
}
void 
preferences_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  fin_clignote (&selection);
  mode = OPTION_DRGEO_MODE;
  gtk_widget_hide (GTK_WIDGET (other_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
eraser_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  fin_clignote (&selection);
  mode = EFFACE_OBJET_MODE;
  set_statusbar_msg (mode);
  gtk_widget_hide (GTK_WIDGET (other_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
}
void 
new_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  fin_clignote (&selection);
  mode = NOUVEAU_MODE;
  gtk_widget_hide (GTK_WIDGET (other_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
  gtk_widget_show (GTK_WIDGET (newfigure_dialog));
}
void 
save_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  fin_clignote (&selection);
  //  mode = SAUVEGARDE_MODE;
  gtk_widget_hide (GTK_WIDGET (other_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));

  // destroy the other handers (from macro, figure)
  gtk_signal_handlers_destroy (GTK_OBJECT (GTK_FILE_SELECTION (savefigure)->ok_button));
  // connect the needed handler to save a geo figure
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (savefigure)->ok_button),
		      "clicked", (GtkSignalFunc) sauver_figure, 0);

  // set a default path to the home directory or previsious save
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (savefigure), nom_fichier);
  gtk_widget_show (savefigure);
}
void 
load_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  fin_clignote (&selection);
  //mode = OUVERTURE_MODE;
  gtk_widget_hide (GTK_WIDGET (other_menu));
  gtk_widget_hide (GTK_WIDGET (main_menu));
  mode = SOURIS_SELECT_MODE;
  set_statusbar_msg (mode);
  // set a default path to the home directory or previsious loading
  // destroy the other handers (from macro, figure)
  gtk_signal_handlers_destroy (GTK_OBJECT (GTK_FILE_SELECTION (loadfigure)->ok_button));
  // let's load a figure
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (loadfigure)->ok_button),
		      "clicked", (GtkSignalFunc) lire_figurefs, 0);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (loadfigure), nom_fichier);
  gtk_widget_show (loadfigure);
}
void 
quit_event (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  gtk_main_quit ();
}

/*
   This is the move event :
   1. check in wich mode we are (corresponding to the last selected menu)
   2. jump to the apropriate mode function regarding to the mode
   Actually only :
   - the move mode is interested by this event - when the user is moving an object
   - to display info buble about object under the mouse
 */

int 
init_gui (void)
{
  int a;
  GtkWidget *table, *widget;
  // init some global variable
  set_tool_bar ();
  set_sub_menu ();

  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  /*  main_window = gtk_scrolled_window_new */
  gtk_window_set_title (GTK_WINDOW (main_window), "GTK Dr Geo");
  //  gtk_widget_set_usize (GTK_WIDGET (main_window), 640,480);
  gtk_window_set_policy (GTK_WINDOW (main_window), FALSE, FALSE, FALSE);
  gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
		      GTK_SIGNAL_FUNC (quit_event), NULL);
  gtk_widget_realize (main_window);

  // Create the table to place rulers, status bar, area, etc.
  table = gtk_table_new (4, 3, FALSE);
  gtk_container_add (GTK_CONTAINER (main_window), table);
  gtk_widget_show (table);

  /* adjsutments for the scrollbars */
  hadjustment = gtk_adjustment_new (0, -32000, 32000, 5, 20, w_ecran);
  vadjustment = gtk_adjustment_new (0, -32000, 32000, 5, 20, h_ecran);
  gtk_signal_connect (GTK_OBJECT (hadjustment), "value_changed",
		   GTK_SIGNAL_FUNC (figure_adjustment_event), (gpointer) 0);
  gtk_signal_connect (GTK_OBJECT (vadjustment), "value_changed",
		   GTK_SIGNAL_FUNC (figure_adjustment_event), (gpointer) 1);

  /* the scrollbars themselves */
  widget = gtk_hscrollbar_new (GTK_ADJUSTMENT (hadjustment));
  gtk_table_attach (GTK_TABLE (table), widget, 1, 2, 2, 3,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), GTK_FILL, 0, 0);
  gtk_widget_show (widget);

  widget = gtk_vscrollbar_new (GTK_ADJUSTMENT (vadjustment));
  gtk_table_attach (GTK_TABLE (table), widget, 2, 3, 1, 2,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), GTK_FILL, 0, 0);
  gtk_widget_show (widget);


  /* drawing area for the Dr Geo figure */
  figure_drawing_area = gtk_drawing_area_new ();
  gtk_widget_set_events (figure_drawing_area, GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_EXPOSURE_MASK);
  //                              | GDK_POINTER_MOTION_HINT_MASK);
  gtk_drawing_area_size (GTK_DRAWING_AREA (figure_drawing_area), w_ecran, h_ecran);

  gtk_table_attach (GTK_TABLE (table), figure_drawing_area, 1, 2, 1, 2,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), GTK_FILL, 0, 0);

  // set the horizontal ruler
  hrule = gtk_hruler_new ();
  gtk_ruler_set_metric (GTK_RULER (hrule), GTK_PIXELS);
  gtk_signal_connect_object (GTK_OBJECT (figure_drawing_area), "motion_notify_event",
		  (GtkSignalFunc) EVENT_METHOD (hrule, motion_notify_event),
			     GTK_OBJECT (hrule));
  gtk_table_attach (GTK_TABLE (table), hrule, 1, 2, 0, 1,
   (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL), GTK_FILL, 0, 0);
  gtk_widget_show (hrule);
  // set the vertical ruler
  vrule = gtk_vruler_new ();
  gtk_ruler_set_metric (GTK_RULER (vrule), GTK_PIXELS);
  gtk_signal_connect_object (GTK_OBJECT (figure_drawing_area), "motion_notify_event",
		  (GtkSignalFunc) EVENT_METHOD (vrule, motion_notify_event),
			     GTK_OBJECT (vrule));
  gtk_table_attach (GTK_TABLE (table), vrule, 0, 1, 1, 2,
   (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL), GTK_FILL, 0, 0);
  gtk_widget_show (vrule);

  set_range_rules ();

  // set a status bar
  statusbar = gtk_statusbar_new ();
  gtk_table_attach (GTK_TABLE (table), statusbar, 1, 2, 3, 4,
   (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL), GTK_FILL, 0, 0);
  gtk_widget_show (statusbar);
  statusbar_context_id = gtk_statusbar_get_context_id (GTK_STATUSBAR (statusbar), "drgeo");
  gtk_signal_connect (GTK_OBJECT (figure_drawing_area), "button_press_event",
		      GTK_SIGNAL_FUNC (click_on_figure_event), NULL);
  gtk_signal_connect (GTK_OBJECT (figure_drawing_area), "motion_notify_event",
		      GTK_SIGNAL_FUNC (motion_on_figure_area_event), NULL);
  gtk_signal_connect (GTK_OBJECT (figure_drawing_area), "expose_event",
		      GTK_SIGNAL_FUNC (expose_event), NULL);
  gtk_signal_connect (GTK_OBJECT (figure_drawing_area), "configure_event",
		      GTK_SIGNAL_FUNC (configure_event), NULL);


  gtk_widget_realize (figure_drawing_area);
  gtk_widget_show (figure_drawing_area);


  /* the pixmap buffer where we draw the figure */
  mode = SOURIS_SELECT_MODE;
  set_statusbar_msg (mode);

  /* load courier font for the canvas bubble */
  fontbulle = gdk_font_load ("-adobe-courier-medium-r-normal--12-120-75-75-m-70-iso8859-1");
  fontobject = gdk_font_load ("-adobe-courier-bold-r-normal--12-120-75-75-m-70-iso8859-1");

  return TRUE;
}
void 
init_other_widget (void)
{
  int a;
  GtkStyle *defstyle;
  GtkWidget *dialog, *button, *label, *hbox, *vbox, *window;
  // Create the dialog to change object style
  dialog_style = gtk_dialog_new ();
  gtk_signal_connect (GTK_OBJECT (dialog_style), "delete_event",
		      GTK_SIGNAL_FUNC (delete_dialog_event), NULL);
  gtk_window_set_policy (GTK_WINDOW (dialog_style), FALSE, FALSE, FALSE);
  table_style = gtk_table_new (4, 5, FALSE);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_style)->vbox), table_style, TRUE, TRUE, 0);

  // pack the color button
  defstyle = gtk_widget_get_default_style ();
  for (a = 0; a < 12; a++)
    {
      color_button[a] = gtk_radio_button_new (group_color);
      group_color = gtk_radio_button_group (GTK_RADIO_BUTTON (color_button[a]));
      gtk_container_border_width (GTK_CONTAINER (color_button[a]), 1);
      gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (color_button[a]), FALSE);
      gtk_table_attach_defaults (GTK_TABLE (table_style), color_button[a],
				 1 + a % 4, (a % 4) + 2, a / 4, a / 4 + 1);
      color_style[a] = gtk_style_copy (defstyle);
      color_style[a]->bg[0] = tab_couleur[a];
      color_style[a]->bg[1] = tab_couleur[a];
      color_style[a]->bg[2] = tab_couleur[a];
      color_style[a]->bg[3] = tab_couleur[a];
      color_style[a]->bg[4] = tab_couleur[a];
      gtk_widget_show (color_button[a]);
      gtk_widget_set_style (color_button[a], color_style[a]);
      gtk_signal_connect (GTK_OBJECT (color_button[a]), "clicked",
			GTK_SIGNAL_FUNC (color_button_event), (gpointer) a);
    }

  // pack the size button on the left
  // dot line (invisible)
  icon = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
				       &main_window->style->white,
				       dotline_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  gtk_widget_show (iconw);
  size_button[0] = gtk_radio_button_new (group_size);
  gtk_container_add (GTK_CONTAINER (size_button[0]), iconw);
  group_size = gtk_radio_button_group (GTK_RADIO_BUTTON (size_button[0]));
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (size_button[0]), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table_style), size_button[0],
			     0, 1, 0, 1);
  gtk_widget_show (size_button[0]);
  // dash line
  icon = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
				       &main_window->style->white,
				       dashline_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  gtk_widget_show (iconw);
  size_button[1] = gtk_radio_button_new (group_size);
  gtk_container_add (GTK_CONTAINER (size_button[1]), iconw);
  group_size = gtk_radio_button_group (GTK_RADIO_BUTTON (size_button[1]));
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (size_button[1]), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table_style), size_button[1],
			     0, 1, 1, 2);
  gtk_widget_show (size_button[1]);
  // normal line
  icon = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
				       &main_window->style->white,
				       normalline_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  gtk_widget_show (iconw);
  size_button[2] = gtk_radio_button_new (group_size);
  gtk_container_add (GTK_CONTAINER (size_button[2]), iconw);
  group_size = gtk_radio_button_group (GTK_RADIO_BUTTON (size_button[2]));
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (size_button[2]), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table_style), size_button[2],
			     0, 1, 2, 3);
  gtk_widget_show (size_button[2]);
  // large line
  icon = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
				       &main_window->style->white,
				       largeline_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  gtk_widget_show (iconw);
  size_button[3] = gtk_radio_button_new (group_size);
  gtk_container_add (GTK_CONTAINER (size_button[3]), iconw);
  group_size = gtk_radio_button_group (GTK_RADIO_BUTTON (size_button[3]));
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (size_button[3]), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table_style), size_button[3],
			     0, 1, 3, 4);
  gtk_widget_show (size_button[3]);

  gtk_signal_connect (GTK_OBJECT (size_button[0]), "clicked",
		      GTK_SIGNAL_FUNC (size_button_event), (gpointer) 0);
  gtk_signal_connect (GTK_OBJECT (size_button[1]), "clicked",
		      GTK_SIGNAL_FUNC (size_button_event), (gpointer) 1);
  gtk_signal_connect (GTK_OBJECT (size_button[2]), "clicked",
		      GTK_SIGNAL_FUNC (size_button_event), (gpointer) 2);
  gtk_signal_connect (GTK_OBJECT (size_button[3]), "clicked",
		      GTK_SIGNAL_FUNC (size_button_event), (gpointer) 3);

  // pack the shape button
  // round shape
  icon = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
				       &main_window->style->white,
				       round_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  gtk_widget_show (iconw);
  shape_button[0] = gtk_radio_button_new (group_shape);
  gtk_container_add (GTK_CONTAINER (shape_button[0]), iconw);
  group_shape = gtk_radio_button_group (GTK_RADIO_BUTTON (shape_button[0]));
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (shape_button[0]), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table_style), shape_button[0],
			     1, 2, 3, 4);
  gtk_widget_show (shape_button[0]);
  // cross shape
  icon = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
				       &main_window->style->white,
				       cross_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  gtk_widget_show (iconw);
  shape_button[1] = gtk_radio_button_new (group_shape);
  gtk_container_add (GTK_CONTAINER (shape_button[1]), iconw);
  group_shape = gtk_radio_button_group (GTK_RADIO_BUTTON (shape_button[1]));
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (shape_button[1]), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table_style), shape_button[1],
			     2, 3, 3, 4);
  gtk_widget_show (shape_button[1]);
  // square shape
  icon = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
				       &main_window->style->white,
				       square_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  gtk_widget_show (iconw);
  shape_button[2] = gtk_radio_button_new (group_shape);
  gtk_container_add (GTK_CONTAINER (shape_button[2]), iconw);
  group_shape = gtk_radio_button_group (GTK_RADIO_BUTTON (shape_button[2]));
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (shape_button[2]), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table_style), shape_button[2],
			     3, 4, 3, 4);
  gtk_widget_show (shape_button[2]);


  // fill shape
  icon = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
				       &main_window->style->white,
				       fill_xpm);
  iconw = gtk_pixmap_new (icon, mask);
  gtk_widget_show (iconw);
  fill_button = gtk_toggle_button_new ();
  gtk_container_add (GTK_CONTAINER (fill_button), iconw);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (fill_button), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table_style), fill_button,
			     4, 5, 3, 4);
  gtk_widget_show (fill_button);

  gtk_signal_connect (GTK_OBJECT (shape_button[0]), "clicked",
		      GTK_SIGNAL_FUNC (shape_button_event), (gpointer) 1);
  gtk_signal_connect (GTK_OBJECT (shape_button[1]), "clicked",
		      GTK_SIGNAL_FUNC (shape_button_event), (gpointer) 2);
  gtk_signal_connect (GTK_OBJECT (shape_button[2]), "clicked",
		      GTK_SIGNAL_FUNC (shape_button_event), (gpointer) 3);

  gtk_signal_connect (GTK_OBJECT (fill_button), "clicked",
		      GTK_SIGNAL_FUNC (fill_button_event), (gpointer) 128);


  gtk_widget_show (table_style);


  // prepare a vbox for entry
  gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (dialog_style)->action_area), FALSE);
  vbox = gtk_vbox_new (FALSE, 2);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 2);
  gtk_container_add (GTK_CONTAINER (GTK_BOX (GTK_DIALOG (dialog_style)->action_area)), vbox);
  gtk_widget_show (vbox);

  // set the entry widget to change the object name
  // a hbox to put the label and entry
  hbox = gtk_hbox_new (FALSE, 2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new (_ ("Rename this object : "));
  entry_change_name = gtk_entry_new_with_max_length (LONGUEUR_NOM);

  gtk_box_pack_start (GTK_BOX (hbox),
		      label, FALSE, TRUE, 0);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox),
		      entry_change_name, TRUE, TRUE, 0);
  gtk_widget_show (entry_change_name);
  gtk_widget_set_usize (entry_change_name, LONGUEUR_NOM * 8, 20);

  gtk_signal_connect (GTK_OBJECT (entry_change_name), "activate",
		GTK_SIGNAL_FUNC (entry_change_name_event), (gpointer) NULL);

  // set the entry widget to change the value/expression of a numeric or expression object
  // a hbox to put the label and entry
  hbox = gtk_hbox_new (FALSE, 2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show (hbox);
  label = gtk_label_new (_ ("Expression : "));
  entry_change_expression = gtk_entry_new_with_max_length (255);

  gtk_box_pack_start (GTK_BOX (hbox),
		      label, FALSE, TRUE, 0);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox),
		      entry_change_expression, TRUE, TRUE, 0);
  gtk_widget_show (entry_change_expression);
  gtk_widget_set_usize (entry_change_expression, LONGUEUR_NOM * 8, 20);

  gtk_signal_connect (GTK_OBJECT (entry_change_expression), "activate",
	  GTK_SIGNAL_FUNC (entry_change_expression_event), (gpointer) NULL);


  // erase dialog
  erase_dialog = gtk_dialog_new ();
  gtk_window_position (GTK_WINDOW (erase_dialog), GTK_WIN_POS_MOUSE);
  gtk_signal_connect (GTK_OBJECT (erase_dialog), "delete_event",
		      GTK_SIGNAL_FUNC (close_erase_dialog), NULL);
  gtk_window_set_policy (GTK_WINDOW (erase_dialog), FALSE, FALSE, FALSE);

  // erase label
  erase_label = gtk_label_new (_ ("Confirm deletion"));
  gtk_misc_set_padding (GTK_MISC (erase_label), 10, 10);
  gtk_widget_show (erase_label);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (erase_dialog)->vbox), erase_label,
		      TRUE, TRUE, 0);
  // erase ok
  erase_ok = gtk_button_new_with_label (_ ("Yes"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (erase_dialog)->action_area),
		      erase_ok, TRUE, TRUE, 0);
  gtk_widget_show (erase_ok);
  GTK_WIDGET_SET_FLAGS (erase_ok, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (erase_ok);
  gtk_signal_connect (GTK_OBJECT (erase_ok), "clicked",
		      GTK_SIGNAL_FUNC (erase_event), (gpointer) 1);
  // erase cancel
  erase_cancel = gtk_button_new_with_label (_ ("No"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (erase_dialog)->action_area),
		      erase_cancel, TRUE, TRUE, 0);
  gtk_widget_show (erase_cancel);
  GTK_WIDGET_SET_FLAGS (erase_cancel, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (erase_cancel), "clicked",
		      GTK_SIGNAL_FUNC (erase_event), (gpointer) 0);

  // new figure  dialog
  newfigure_dialog = gtk_dialog_new ();
  gtk_window_set_modal (GTK_WINDOW (newfigure_dialog), TRUE);
  gtk_window_position (GTK_WINDOW (newfigure_dialog), GTK_WIN_POS_MOUSE);
  gtk_signal_connect (GTK_OBJECT (newfigure_dialog), "delete_event",
		      GTK_SIGNAL_FUNC (delete_dialog_event), NULL);
  gtk_window_set_policy (GTK_WINDOW (newfigure_dialog), FALSE, FALSE, FALSE);

  // new figure label
  label = gtk_label_new (_ ("The unsave objects will be lost"));
  gtk_misc_set_padding (GTK_MISC (label), 10, 10);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (newfigure_dialog)->vbox), label,
		      TRUE, TRUE, 0);
  // new figure ok
  button = gtk_button_new_with_label (_ ("Yes"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (newfigure_dialog)->action_area),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (newfigure_event), (gpointer) 0);
  // new figure cancel
  button = gtk_button_new_with_label (_ ("No"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (newfigure_dialog)->action_area),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (newfigure_event), (gpointer) 1);


  // file selector to save a geometric figure
  savefigure = gtk_file_selection_new (_ ("Save the current figure"));
  gtk_window_position (GTK_WINDOW (savefigure), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (savefigure), TRUE);
  gtk_signal_connect (GTK_OBJECT (savefigure), "delete_event",
		      (GtkSignalFunc) delete_dialog_event, NULL);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (savefigure)->cancel_button),
       "clicked", (GtkSignalFunc) hide_dialog_event, (gpointer) savefigure);

  // file selector to load a geometric figure
  loadfigure = gtk_file_selection_new (_ ("Load a figure"));
  gtk_window_position (GTK_WINDOW (loadfigure), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (loadfigure), TRUE);
  gtk_signal_connect (GTK_OBJECT (loadfigure), "delete_event",
		      (GtkSignalFunc) delete_dialog_event, NULL);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (loadfigure)->cancel_button),
       "clicked", (GtkSignalFunc) hide_dialog_event, (gpointer) loadfigure);

  // Builder macro-construction dialog
  buildmacro_dialog = gtk_dialog_new ();
  gtk_window_position (GTK_WINDOW (buildmacro_dialog), GTK_WIN_POS_MOUSE);
  gtk_signal_connect (GTK_OBJECT (buildmacro_dialog), "delete_event",
		      GTK_SIGNAL_FUNC (buildmacro_delete_event), NULL);
  gtk_window_set_policy (GTK_WINDOW (buildmacro_dialog), FALSE, FALSE, FALSE);

  // build macro label
  label = gtk_label_new (_ ("Build a macro-construction"));
  gtk_misc_set_padding (GTK_MISC (label), 10, 10);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (buildmacro_dialog)->vbox), label,
		      TRUE, TRUE, 0);
  // input macro radio button
  input_buildmacro = gtk_radio_button_new_with_label (group_buildmacro, _ ("Input parameters"));
  group_buildmacro = gtk_radio_button_group (GTK_RADIO_BUTTON (input_buildmacro));
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (input_buildmacro), FALSE);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (buildmacro_dialog)->vbox), input_buildmacro,
		      TRUE, FALSE, 10);
  gtk_signal_connect (GTK_OBJECT (input_buildmacro), "clicked",
		      GTK_SIGNAL_FUNC (buildmacro_event), (gpointer) 0);
  gtk_widget_show (input_buildmacro);
  // output macro radio button
  output_buildmacro = gtk_radio_button_new_with_label (group_buildmacro, _ ("Output parameters"));
  group_buildmacro = gtk_radio_button_group (GTK_RADIO_BUTTON (output_buildmacro));
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (output_buildmacro), FALSE);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (buildmacro_dialog)->vbox), output_buildmacro,
		      TRUE, FALSE, 10);
  gtk_signal_connect (GTK_OBJECT (output_buildmacro), "clicked",
		      GTK_SIGNAL_FUNC (buildmacro_event), (gpointer) 1);
  gtk_widget_show (output_buildmacro);

  gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (buildmacro_dialog)->vbox), FALSE);

  // build macro ok
  button = gtk_button_new_with_label (_ ("Ok"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (buildmacro_dialog)->action_area),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (buildmacro_event), (gpointer) 2);
  // build macro cancel
  button = gtk_button_new_with_label (_ ("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (buildmacro_dialog)->action_area),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (buildmacro_event), (gpointer) 3);

  // macro construction name dialog
  macroname_dialog = gtk_dialog_new ();
  gtk_window_set_modal (GTK_WINDOW (macroname_dialog), TRUE);
  gtk_window_position (GTK_WINDOW (macroname_dialog), GTK_WIN_POS_MOUSE);
  gtk_signal_connect (GTK_OBJECT (macroname_dialog), "delete_event",
		      GTK_SIGNAL_FUNC (buildmacro_delete_event), NULL);
  gtk_window_set_policy (GTK_WINDOW (macroname_dialog), FALSE, FALSE, FALSE);
  // macro name label
  label = gtk_label_new (_ ("Enter the macro-construction name :"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (macroname_dialog)->vbox), label,
		      TRUE, TRUE, 0);
  gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (macroname_dialog)->vbox), FALSE);
  // field to enter macro name
  macroname_entry = gtk_entry_new_with_max_length (MACRO_NAME_WIDTH - 1);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (macroname_dialog)->vbox),
		      macroname_entry, FALSE, FALSE, 0);
  gtk_widget_show (macroname_entry);
  gtk_signal_connect (GTK_OBJECT (macroname_entry), "activate",
		      GTK_SIGNAL_FUNC (buildmacro_event), (gpointer) 4);
  // ok button 
  button = gtk_button_new_with_label (_ ("Ok"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (macroname_dialog)->action_area),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (buildmacro_event), (gpointer) 4);

  // Exec macro-construction window
  execmacro_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (execmacro_window), _ ("Run macro-construction"));
  gtk_window_position (GTK_WINDOW (execmacro_window), GTK_WIN_POS_MOUSE);
  gtk_window_set_policy (GTK_WINDOW (execmacro_window), FALSE, FALSE, FALSE);
  gtk_signal_connect (GTK_OBJECT (execmacro_window), "delete_event",
		      GTK_SIGNAL_FUNC (delete_dialog_event), NULL);
  // pack an horizontal box inside
  hbox = gtk_hbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_container_add (GTK_CONTAINER (execmacro_window), hbox);
  gtk_widget_show (hbox);
  // vbox for the list and text zone
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (hbox), vbox);
  gtk_widget_show (vbox);

  // Scrolled window where we will put the macro name list
  window = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_usize (window, 80, 50);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (window),
				GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (vbox), window, FALSE, FALSE, 0);
  gtk_widget_show (window);
  // create the macro name list 
  macrolist = gtk_clist_new (1);
  gtk_clist_set_selection_mode (GTK_CLIST (macrolist), GTK_SELECTION_SINGLE);
  gtk_clist_set_shadow_type (GTK_CLIST (macrolist), GTK_SHADOW_ETCHED_OUT);
  gtk_clist_set_column_width (GTK_CLIST (macrolist), 1, MACRO_NAME_WIDTH * 8);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (window), macrolist);
  gtk_widget_show (macrolist);
  gtk_signal_connect (GTK_OBJECT (macrolist),
		      "unselect_row",
		      GTK_SIGNAL_FUNC (macrolist_event),
		      (gpointer) 1);
  gtk_signal_connect (GTK_OBJECT (macrolist),
		      "select_row",
		      GTK_SIGNAL_FUNC (macrolist_event),
		      (gpointer) 0);
  // text widget 
  macrotextinfo = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (macrotextinfo), TRUE);
  gtk_box_pack_start (GTK_BOX (vbox), macrotextinfo, FALSE, FALSE, 0);
  gtk_text_set_word_wrap (GTK_TEXT (macrotextinfo), TRUE);
  gtk_widget_show (macrotextinfo);
  gtk_widget_realize (macrotextinfo);
  // Pack action button on the right
  // vbox for the button
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (hbox), vbox);
  gtk_widget_show (vbox);
  //Load button
  button = gtk_button_new_with_label (_ ("Load"));
  gtk_box_pack_start (GTK_BOX (vbox),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (execmacro_event), (gpointer) 1);
  //Save button
  button = gtk_button_new_with_label (_ ("Save"));
  gtk_box_pack_start (GTK_BOX (vbox),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (execmacro_event), (gpointer) 2);
  //Delete button
  button = gtk_button_new_with_label (_ ("Delete"));
  gtk_box_pack_start (GTK_BOX (vbox),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (execmacro_event), (gpointer) 3);

  // Dialog to enter/edit a value
  value_dialog = gtk_dialog_new ();
  gtk_window_set_modal (GTK_WINDOW (value_dialog), TRUE);
  gtk_window_position (GTK_WINDOW (value_dialog), GTK_WIN_POS_MOUSE);
  gtk_signal_connect (GTK_OBJECT (value_dialog), "delete_event",
		      GTK_SIGNAL_FUNC (delete_dialog_event), NULL);

  // value name label
  label = gtk_label_new (_ ("Edit value :"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (value_dialog)->vbox), label,
		      TRUE, TRUE, 0);
  gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (value_dialog)->vbox), FALSE);
  // field to enter macro name
  value_entry = gtk_entry_new_with_max_length (256);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (value_dialog)->vbox),
		      value_entry, FALSE, FALSE, 0);
  gtk_widget_show (value_entry);
  gtk_signal_connect (GTK_OBJECT (value_entry), "activate",
		      GTK_SIGNAL_FUNC (value_edit_event), NULL);
  // ok button 
  button = gtk_button_new_with_label (_ ("Ok"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (value_dialog)->action_area),
		      button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (value_edit_event), NULL);
}

void 
color_button_event (GtkWidget * widget, gpointer data)
{
  char c;
  int nb;
  figure_c *fig;
  c = (char) data;
  nb = selection.nb_elem;
  selection.init_lire ();
  while (nb-- != 0)
    {
      fig = (figure_c *) (selection.lire (0));
      fig->couleur = c;
    }
  // refresh the pixmap
  if (mode == MISE_EN_FORME_MODE)
    dessine_tout ();
  else
    dessine_figure ();
  swap ();
}
void 
shape_button_event (GtkWidget * widget, gpointer data)
{
  char c;
  int nb;
  figure_c *fig;
  c = (char) data;
  nb = selection.nb_elem;
  selection.init_lire ();
  while (nb-- != 0)
    {
      fig = (figure_c *) (selection.lire (0));
      // set to zero the style bit and put the new one style
      fig->style = (fig->style & 0xF0) + c;
    }
  // refresh the pixmap
  tapisser (current_screen);
  if (mode == MISE_EN_FORME_MODE)
    dessine_tout ();
  else
    dessine_figure ();
  swap ();
}
void 
fill_button_event (GtkWidget * widget, gpointer data)
{
  char c;
  int nb;
  figure_c *fig;
  c = (char) data;
  nb = selection.nb_elem;
  selection.init_lire ();
  while (nb-- != 0)
    {
      fig = (figure_c *) (selection.lire (0));
      fig->style ^= c;
    }
  // refresh the pixmap
  tapisser (current_screen);
  if (mode == MISE_EN_FORME_MODE)
    dessine_tout ();
  else
    dessine_figure ();
  swap ();
}
void 
size_button_event (GtkWidget * widget, gpointer data)
{
  char c;
  int nb;
  figure_c *fig;
  c = (char) data;
  nb = selection.nb_elem;
  selection.init_lire ();
  while (nb-- != 0)
    {
      fig = (figure_c *) (selection.lire (0));
      fig->epaisseur = c;
      if (c == 0)
	fig->masque = OBJET_MASQUE;
      else
	fig->masque = OBJET_APPARENT;
    }
  // refresh the pixmap
  tapisser (current_screen);
  dessine_tout ();
  swap ();
}

void 
entry_change_name_event (GtkWidget * widget, gpointer data)
{
  figure_c *fig;
  int i, nb;
  if (selection.nb_elem == 0)
    return;
  fig = (figure_c *) (selection.lire (1));
  strcpy (fig->nom, gtk_entry_get_text (GTK_ENTRY (entry_change_name)));
  // reinit all object name
  nb = liste_figure.nb_elem;
  liste_figure.init_lire ();
  for (i = 1; i <= nb; i++)
    ((figure_c *) liste_figure.lire (0))->init_nom ();
  // refresh the pixmap
  tapisser (current_screen);
  if (mode == MISE_EN_FORME_MODE)
    dessine_tout ();
  else
    dessine_figure ();
  swap ();
}

void 
entry_change_expression_event (GtkWidget * widget, gpointer data)
{
  figure_c *fig;
  double val;
  if (selection.nb_elem == 0)
    return;
  fig = (figure_c *) (selection.lire (1));
  switch (fig->classe)
    {
    case VA_LI:
      val = strtod (gtk_entry_get_text (GTK_ENTRY (entry_change_expression)), NULL);
      ((valeur_c *) fig)->val = val;
      break;
    }
  // refresh the pixmap
  mise_a_jour ();
  tapisser (current_screen);
  if (mode == MISE_EN_FORME_MODE)
    dessine_tout ();
  else
    dessine_figure ();
  swap ();
}

void 
hide_dialog_event (GtkWidget * called_widget, gpointer widget)
{
  gtk_widget_hide (GTK_WIDGET (widget));
}
void 
delete_dialog_event (GtkWidget * widget, gpointer data)
{
  gtk_widget_hide (widget);
}

void 
adjust_style_dialog ()
{
  figure_c *fig;
  if (selection.nb_elem == 0)
    {
      // not selected object, set to default style
      gtk_entry_set_text (GTK_ENTRY (entry_change_name), "");
      gtk_entry_set_text (GTK_ENTRY (entry_change_expression), "");
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (color_button[0]), TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (size_button[2]), TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (shape_button[0]), TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fill_button), FALSE);
    }
  else
    {
      gchar out[800] = "";
      // at least one selected object
      fig = (figure_c *) selection.lire (1);
      gtk_entry_set_text (GTK_ENTRY (entry_change_name), fig->nom);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (color_button[fig->couleur]), TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (size_button[fig->epaisseur]), TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (shape_button[(fig->style & 0xF) - 1]), TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fill_button), (fig->style & 128) == 128);
      switch (fig->type)
	{
	case FIG_VALEUR:
	  sprintf (out, "%f", ((valeur_c *) fig)->valeur ());
	  break;
	case FIG_EQUATION:
	  break;
	}
      gtk_entry_set_text (GTK_ENTRY (entry_change_expression), out);
    }
}

void 
erase_event (GtkWidget * widget, gpointer data)
{
  char c;
  c = (char) data;
  switch (c)
    {
    case 0:
      // cancel deletion
      efface_objet (NULL, 2);
      break;
    case 1:
      // confirm deletion
      efface_objet (NULL, 1);
      break;
    }
}

void 
close_erase_dialog (GtkWidget * widget, gpointer data)
{
  // user close the erase dialog, we guess he want to cancel the deletion
  erasing = FALSE;
  // refresh the pixmap
  tapisser (current_screen);
  dessine_figure ();
  swap ();
  gtk_widget_hide (widget);
}
void 
newfigure_event (GtkWidget * widget, gpointer data)
{
  char c;

  c = (char) data;
  switch (c)
    {
    case 0:
      // user confirm, so let's delete the objets
      effacer_figure ();
      liste_figure.vide ();
      liste_figure_libre.vide ();
      gtk_widget_hide (newfigure_dialog);
      tapisser (current_screen);
      swap ();
      mode = POINT_MODE;
      set_statusbar_msg (mode);
      break;
    case 1:
      // user cancel
      gtk_widget_hide (newfigure_dialog);
      mode = SOURIS_SELECT_MODE;
      set_statusbar_msg (mode);
      break;
    }
}
void 
buildmacro_event (GtkWidget * widget, gpointer data)
{
  // data == 0 : input parameters button 
  // data == 1 : output parameters button 
  // data == 2 : ok button 
  // data == 3 : cancel button 
  // data == 4 : we enter the macro construction name
  char c;
  c = (char) data;
  switch (c)
    {
    case 0:
      fin_clignote_no_vide (flashing_list);
      flashing_list = &liste_i;
      break;
    case 1:
      fin_clignote_no_vide (flashing_list);
      flashing_list = &liste_f;
      break;
    case 2:
      // Check validity of the macro
      if (!verifie_validite_macro (liste_i, liste_f))
	{
	  g_print (_ ("The choosen input and output parameters don't allow to build a macro construction\n"));
	  return;
	}
      else
	{
	  gtk_widget_hide (buildmacro_dialog);
	  // valide, let's enter a name
	  gtk_widget_show (macroname_dialog);
	}
      break;
    case 3:
      // cancel the action
      fin_clignote (flashing_list);
      flashing_list = &selection;
      liste_i.vide ();
      liste_f.vide ();
      gtk_widget_hide (buildmacro_dialog);
      mode = SOURIS_SELECT_MODE;
      set_statusbar_msg (mode);
      break;
    case 4:
      // now we have the macro name, let's build it
      gtk_widget_hide (macroname_dialog);
      if (macro_enregistre ((figure_c *) NULL, 2))
	{
	  char *pt[1];
	  // macro constructed : do some cleaning
	  buildmacro_delete_event (NULL, NULL);
	  // add the macro name to the macrolist GtkCList
	  pt[0] = ((macro *) (liste_macro.lire (liste_macro.nb_elem)))->nom;
	  gtk_clist_append (GTK_CLIST (macrolist), pt);
	}
      mode = SOURIS_SELECT_MODE;
      set_statusbar_msg (mode);
      break;
    }
}
void 
buildmacro_delete_event (GtkWidget * widget, gpointer data)
{
  // delete event for the buid macro dialog.
  // we need to make some cleaning when closing it
  fin_clignote (flashing_list);
  flashing_list = &selection;
  liste_i.vide ();
  liste_f.vide ();
  gtk_widget_hide (buildmacro_dialog);
  mode = SOURIS_SELECT_MODE;
  set_statusbar_msg (mode);
}
void 
execmacro_event (GtkWidget * widget, gpointer data)
{
  // data ==
  // 1 : Load button
  // 2 : Save button
  // 3 : Delete button
  char c;
  c = (char) data;
  switch (c)
    {
    case 1:
      fin_clignote (&selection);
      selection.vide ();
      gtk_signal_handlers_destroy (GTK_OBJECT (GTK_FILE_SELECTION (loadfigure)->ok_button));
      gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (loadfigure)->ok_button),
		    "clicked", (GtkSignalFunc) lire_figurefs, (gpointer) 1);
      gtk_file_selection_set_filename (GTK_FILE_SELECTION (loadfigure), "~/");
      gtk_widget_show (loadfigure);

      break;
    case 2:
      // do the user select a macro to save ?
      if (selected_macro == NULL)
	break;
      // First copy the text edit in the selected macro area
      // just use brut force and don't care if the user change something, we update anyway
      {
	char *txt;
	int size;
	size = gtk_text_get_length (GTK_TEXT (macrotextinfo));
	if (size >= MACRO_TEXT_INFO)
	  size = MACRO_TEXT_INFO - 1;
	txt = gtk_editable_get_chars (GTK_EDITABLE (macrotextinfo), 0, size);
	strcpy (selected_macro->info, txt);
	g_free (txt);
      }
      // destroy the other handers (from macro, figure)
      gtk_signal_handlers_destroy (GTK_OBJECT (GTK_FILE_SELECTION (savefigure)->ok_button));
      // connect the needed handler to save a geo figure
      gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (savefigure)->ok_button),
		    "clicked", (GtkSignalFunc) sauver_figure, (gpointer) 1);
      gtk_file_selection_set_filename (GTK_FILE_SELECTION (savefigure), "~/");
      gtk_widget_show (savefigure);
      break;
    case 3:
      fin_clignote (&selection);
      selection.vide ();
      if (selected_macro == NULL)
	break;
      liste_macro.supprime (selected_macro);
      c = macro_selected_row;
      // copy it as the following call will generate an event who put it to -1
      gtk_clist_unselect_row (GTK_CLIST (macrolist), macro_selected_row, 0);

      gtk_clist_remove (GTK_CLIST (macrolist), c);
      macro_selected_row = c - 1;
      if (macro_selected_row != -1)
	{
	  selected_macro = (macro *) liste_macro.lire (macro_selected_row + 1);
	  gtk_clist_select_row (GTK_CLIST (macrolist), macro_selected_row, 0);
	}
      else
	selected_macro = NULL;
      break;
    }
}

void 
macrolist_event (GtkWidget * widget, gint row, gint col, GdkEventButton * event, gpointer data)
{
  // data ==
  // 0 : selected row
  // 1 : unselected row
  char c;
  c = (char) data;
  switch (c)
    {
    case 0:
      macro_selected_row = row;
      fin_clignote (&selection);
      selection.vide ();
      selected_macro = (macro *) liste_macro.lire (row + 1);
      // let's update the macro info text window
      gtk_text_insert (GTK_TEXT (macrotextinfo), NULL, NULL, NULL, selected_macro->info, -1);
      break;
    case 1:
      // do the user change the info text of the previsious selected macro ? (If one was selected)
      if (selected_macro != NULL)
	{
	  // just use brut force and don't care if the user change something, we update anyway
	  char *txt;
	  int size;
	  size = gtk_text_get_length (GTK_TEXT (macrotextinfo));
	  if (size >= MACRO_TEXT_INFO)
	    size = MACRO_TEXT_INFO - 1;
	  txt = gtk_editable_get_chars (GTK_EDITABLE (macrotextinfo), 0, size);
	  strcpy (selected_macro->info, txt);
	  g_free (txt);
	}
      // then empty the macro text info
      gtk_text_set_point (GTK_TEXT (macrotextinfo), 0);
      gtk_text_forward_delete (GTK_TEXT (macrotextinfo), gtk_text_get_length (GTK_TEXT (macrotextinfo)));
      macro_selected_row = -1;
      break;
    }
}

void 
set_range_rules ()
{
  gtk_ruler_set_range (GTK_RULER (hrule), MONx (0), MONx (w_ecran), 0, MONx (w_ecran));
  gtk_ruler_set_range (GTK_RULER (vrule), MONy (0), MONy (h_ecran), 0, MONy (h_ecran));
}

void 
set_statusbar_msg (int status)
{
  gchar tmp[512];

  gtk_statusbar_pop (GTK_STATUSBAR (statusbar), statusbar_context_id);
  strcpy (tmp, _ (" You are in mode : "));
  switch (status)
    {
    case POINT_MODE:
      strcat (tmp, _ ("Free point"));
      break;
    case POINT_MILIEU_MODE:
      strcat (tmp, _ ("Middle"));
      break;
    case POINT_INTER_MODE:
      strcat (tmp, _ ("Intersection point"));
      break;
    case POINT_REPERE_MODE:
      strcat (tmp, _ ("Point defines by its coordinates"));
      break;
    case DROITE_MODE:
      strcat (tmp, _ ("Line"));
      break;
    case DEMI_DROITE_MODE:
      strcat (tmp, _ ("Half-line"));
      break;
    case SEGMENT_MODE:
      strcat (tmp, _ ("Segment"));
      break;
    case VECTEUR_MODE:
      strcat (tmp, _ ("Vector"));
      break;
    case CERCLE_MODE:
      strcat (tmp, _ ("Circle"));
      break;
    case ARC_CERCLE_MODE:
      strcat (tmp, _ ("Arc circle"));
      break;
    case LIEU_POINT_MODE:
      strcat (tmp, _ ("Geometric locus"));
      break;
    case DROITE_PARALLELE_MODE:
      strcat (tmp, _ ("Parallel line"));
      break;
    case DROITE_ORTHOGONALE_MODE:
      strcat (tmp, _ ("Perpendicular line"));
      break;
    case REFLEXION_MODE:
      strcat (tmp, _ ("Axial symetry"));
      break;
    case SYMETRIE_MODE:
      strcat (tmp, _ ("Central symetry"));
      break;
    case TRANSLATION_MODE:
      strcat (tmp, _ ("Translation"));
      break;
    case ROTATION_MODE:
      strcat (tmp, _ ("Rotation"));
      break;
    case HOMOTHETIE_MODE:
      strcat (tmp, _ ("Scale"));
      break;
    case NUMERIQUE_MODE:
      strcat (tmp, _ ("Distance & length"));
      break;
    case ANGLE_MODE:
      strcat (tmp, _ ("Angle"));
      break;
    case COORDONNEES_MODE:
      strcat (tmp, _ ("Coordonnea & equation"));
      break;
    case MACRO_ENREGISTRE_MODE:
      strcat (tmp, _ ("Build a macro-construction"));
      break;
    case MACRO_PLAY_MODE:
      strcat (tmp, _ ("Execute a macro-construction"));
      break;
    case SOURIS_SELECT_MODE:
      strcat (tmp, _ ("Move an object"));
      break;
    case MISE_EN_FORME_MODE:
      strcat (tmp, _ ("Change the style of an object"));
      break;
    case EFFACE_OBJET_MODE:
      strcat (tmp, _ ("Erase an object"));
      break;
    }
  gtk_statusbar_push (GTK_STATUSBAR (statusbar), statusbar_context_id, tmp);
}

void 
figure_adjustment_event (GtkAdjustment * adj, gpointer data)
{
// data == 0 : hadjsutment
  //         1 : vadjsument
  // when valuev of the adustment is 0 ORIGIN_V = v_ecran/2
  //      valueh of the adustment is 0 ORIGIN_H = h_ecran/2
  int c, value;
  c = (int) data;
  switch (c)
    {
    case 0:
      ORIGIN_W = (w_ecran / 2) - adj->value;
      break;
    case 1:
      ORIGIN_H = (h_ecran / 2) - adj->value;
      break;
    }
  MON_L = MONx (0);
  MON_R = MONx (w_ecran);
  MON_T = MONy (0);
  MON_B = MONy (h_ecran);
  set_range_rules ();
  tapisser (current_screen);
  dessine_figure ();
  swap ();
}

void 
value_edit_event (GtkWidget * widget, gpointer data)
{
  double val;
  figure_c *new_fig;
  gtk_widget_hide (value_dialog);
  val = strtod (gtk_entry_get_text (GTK_ENTRY (value_entry)), NULL);
  selection.ajoute ((void *) &val);
  new_fig = new valeur_libre (selection, MONx (mx), MONy (my));
  liste_figure.ajoute ((void *) new_fig);
  liste_figure_libre.ajoute ((void *) new_fig);
  new_fig->dessine (current_screen, FALSE);
  swap ();
  selection.vide ();
}
