



/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include "graphic.h"
GdkGC *figure_gc;

extern GdkPixmap *figure_drawing_area;
extern GtkWidget *main_window;
extern int w_ecran, h_ecran;
extern GdkColor tab_couleur[];

void
line_good_clip (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int c)
{
  point p1, p2;
  p1.x = x1;
  p1.y = y1;
  p2.x = x2;
  p2.y = y2;
  clip_line (p1, p2);
  gdk_gc_set_line_attributes (figure_gc, 0, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_gc_set_foreground (figure_gc, &tab_couleur[c]);
  gdk_draw_line (bmp, figure_gc, (int) p1.x, (int) p1.y, (int) p2.x, (int) p2.y);
}

char
clip_test (float p, float q, float &u1, float &u2)
{
  float r;
  char ret = TRUE;
  if (p < 0.0)
    {
      r = q / p;
      if (r > u2)
	ret = FALSE;
      else if (r > u1)
	u1 = r;
    }
  else
    {
      if (p > 0.0)
	{
	  r = q / p;
	  if (r < u1)
	    ret = FALSE;
	  else if (r < u2)
	    u2 = r;
	}
      else if (q < 0.0)
	ret = FALSE;
    }
  return ret;
}

void
clip_line (point & p1, point & p2)
{
  point winMin, winMax;
  float u1, u2, dx, dy;
  winMin.x = 0;
  winMin.y = 0;
  winMax.x = w_ecran;
  winMax.y = h_ecran;
  u1 = 0;
  u2 = 1;
  dx = p2.x - p1.x;
  if (clip_test (-dx, p1.x - winMin.x, u1, u2))
    {
      if (clip_test (dx, winMax.x - p1.x, u1, u2))
	{
	  dy = p2.y - p1.y;
	  if (clip_test (-dy, p1.y - winMin.y, u1, u2))
	    {
	      if (clip_test (dy, winMax.y - p1.y, u1, u2))
		{
		  if (u1 > 0)
		    {
		      p1.x = p1.x + u1 * dx;
		      p1.y = p1.y + u1 * dy;
		    }
		  if (u2 < 1)
		    {
		      p2.x = p1.x + u2 * dx;
		      p2.y = p1.y + u2 * dy;
		    }
		}
	    }
	}
    }
}

void
dotted_line (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int col, unsigned char mask)
{
  char style;
  point p1, p2;
  p1.x = x1;
  p1.y = y1;
  p2.x = x2;
  p2.y = y2;
  clip_line (p1, p2);
  if (mask == 1)
    style = GDK_LINE_ON_OFF_DASH;
  else
    style = GDK_LINE_DOUBLE_DASH;
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_gc_set_line_attributes (figure_gc, 0, style, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_draw_line (bmp, figure_gc, (int) p1.x, (int) p1.y, (int) p2.x, (int) p2.y);
}
void
gline (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int col)
{
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_gc_set_line_attributes (figure_gc, 0, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_draw_line (bmp, figure_gc, x1, y1, x2, y2);
}

void
dotted_circle (GdkPixmap * bmp, int x, int y, int rayon, int col, unsigned char mask)
{
  char style;
  if (mask == 1)
    style = GDK_LINE_ON_OFF_DASH;
  else
    style = GDK_LINE_DOUBLE_DASH;
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_gc_set_line_attributes (figure_gc, 0, style, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_draw_arc (bmp, figure_gc, FALSE, x - rayon, y - rayon, rayon << 1, rayon << 1, 0, 360 * 64);
}
void
thick_line (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int col, unsigned char epaisseur)
{
  point p1, p2;
  p1.x = x1;
  p1.y = y1;
  p2.x = x2;
  p2.y = y2;
  clip_line (p1, p2);
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_gc_set_line_attributes (figure_gc, epaisseur, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_draw_line (bmp, figure_gc, (int) p1.x, (int) p1.y, (int) p2.x, (int) p2.y);
}
void
thick_circle (GdkPixmap * bmp, int x, int y, int rayon, int col, unsigned char epaisseur)
{
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_gc_set_line_attributes (figure_gc, epaisseur, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_draw_arc (bmp, figure_gc, FALSE, x - rayon, y - rayon, rayon << 1, rayon << 1, 0, 360 * 64);
}
void
rectanglefilled (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int c)
{
  gdk_gc_set_foreground (figure_gc, &tab_couleur[c]);
  gdk_draw_rectangle (bmp, figure_gc, TRUE, x1, y1, x2, y2);
}
void
circlefilled (GdkPixmap * bmp, int x, int y, int rayon, int col)
{
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_draw_arc (bmp, figure_gc, TRUE, x - rayon, y - rayon, rayon << 1, rayon << 1, 0, 360 * 64);
}
void
gcircle (GdkPixmap * bmp, int x, int y, int rayon, int col)
{
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_gc_set_line_attributes (figure_gc, 0, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_draw_arc (bmp, figure_gc, FALSE, x - rayon, y - rayon, rayon << 1, rayon << 1, 0 * 64, 360 * 64);
}
void
plotpixel (GdkPixmap * bmp, int x, int y, int col)
{
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_draw_point (bmp, figure_gc, x, y);
}
void
dotted_arc_circle (GdkPixmap * bmp, int x, int y, int rayon, int a1, int a2, int col, unsigned char mask)
{
  char style;
  if (mask == 1)
    style = GDK_LINE_ON_OFF_DASH;
  else
    style = GDK_LINE_DOUBLE_DASH;
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_gc_set_line_attributes (figure_gc, 0, style, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_draw_arc (bmp, figure_gc, FALSE, x - rayon, y - rayon, rayon << 1, rayon << 1, a1 * 64, a2 * 64);
}
void
thick_arc_circle (GdkPixmap * bmp, int x, int y, int rayon, int a1, int a2, int col, unsigned char epaisseur)
{
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_gc_set_line_attributes (figure_gc, epaisseur, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_draw_arc (bmp, figure_gc, FALSE, x - rayon, y - rayon, rayon << 1, rayon << 1, a1 * 64, a2 * 64);
}
void
arc_circlefilled (GdkPixmap * bmp, int x, int y, int rayon, int a1, int a2, int col)
{
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_draw_arc (bmp, figure_gc, TRUE, x - rayon, y - rayon, rayon << 1, rayon << 1, a1 * 64, a2 * 64);
}
void
garc_circle (GdkPixmap * bmp, int x, int y, int rayon, int a1, int a2, int col)
{
  gdk_gc_set_foreground (figure_gc, &tab_couleur[col]);
  gdk_gc_set_line_attributes (figure_gc, 0, GDK_LINE_SOLID, GDK_CAP_ROUND, GDK_JOIN_MITER);
  gdk_draw_arc (bmp, figure_gc, FALSE, x - rayon, y - rayon, rayon << 1, rayon << 1, a1 * 64, a2 * 64);
}
