/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "coordonnees.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *object_gc, *font_gc;
extern GdkColor tab_couleur[];

// Members functions of the class type coordonnea
void abscisse_point::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the abscissa of %1"));
  if (nom[0] == 0)
    strcpy (nom, pt->nom);
  strinsmsg (nom_type, nom, "%1");
}
void abscisse_point::
dessine (GdkPixmap * ecran, char force)
{
  char out[10];
  point_s co;
  int x, y;
  co = pt->coordonnees () + p;
  x = ECRx (co.x);
  y = ECRy (co.y);
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || existe == FALSE)
    return;
  sprintf (out, "%.2f", valeur ());
  gdk_gc_set_foreground (object_gc, &tab_couleur[couleur]);
  gdk_draw_string (ecran, fontobject, object_gc, x, y, out);
  line_good_clip (ecran, x - 2, y + 3, x - 2, y - 9 - 3, couleur);
}
char abscisse_point::
appartient (int xm, int ym)
{
  double xl, yh, mx, my;
  char out[30];
  point_s p1;
  p1 = pt->coordonnees () + p;
  mx = MONx (xm);
  my = MONy (ym);
  sprintf (out, "%.2f", valeur ());
  xl = gdk_string_width (fontobject, out);
  yh = gdk_string_height (fontobject, out);
  xl = p1.x + xl / ECHELLE;
  yh = p1.y + yh / ECHELLE;
  if (mx >= p1.x && mx <= xl && my <= yh && my >= p1.y)
    return TRUE;
  else
    return FALSE;
}
char abscisse_point::
dependance (figure_c * fig)
{
  return (pt == fig);
}
void abscisse_point::
actualise (void)
{
  point_s p1;
  existe = pt->existe;
  if (!existe)
    return;
  p1 = pt->coordonnees ();
  val = p1.x;
}
liste_elem *abscisse_point::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) pt);
  return liste_parent;
}
void abscisse_point::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&val, 1, sizeof (val), f);
  pos = liste_figure.position ((void *) pt);
  fwrite (&pos, 1, sizeof (pos), f);
}
void abscisse_point::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&val, 1, sizeof (val), f);
  fread (&pos, 1, sizeof (pos), f);
  pt = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
//
void ordonnee_point::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the ordinate of %1"));
  if (nom[0] == 0)
    strcpy (nom, pt->nom);
  strinsmsg (nom_type, nom, "%1");
}
void ordonnee_point::
actualise (void)
{
  point_s p1;
  existe = pt->existe;
  if (!existe)
    return;
  p1 = pt->coordonnees ();
  val = p1.y;
}
//
void abscisse_vecteur::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the abscissa of %1"));
  if (nom[0] == 0)
    strcpy (nom, v->nom);
  strinsmsg (nom_type, nom, "%1");
}
char abscisse_vecteur::
dependance (figure_c * fig)
{
  return (v == fig);
}
void abscisse_vecteur::
actualise (void)
{
  vecteur_s p1;
  existe = v->existe;
  if (!existe)
    return;
  p1 = v->vecteur ();
  val = p1.x;
}
liste_elem *abscisse_vecteur::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) v);
  return liste_parent;
}
void abscisse_vecteur::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  fwrite (&val, 1, sizeof (val), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
}
void abscisse_vecteur::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&val, 1, sizeof (val), f);
  fread (&pos, 1, sizeof (pos), f);
  v = (vecteur_c *) liste_figure.lire (pos);
  init_nom ();
}
//
void ordonnee_vecteur::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("the ordinate of %1"));
  if (nom[0] == 0)
    strcpy (nom, v->nom);
  strinsmsg (nom_type, nom, "%1");
}
void ordonnee_vecteur::
actualise (void)
{
  vecteur_s p1;
  existe = v->existe;
  if (!existe)
    return;
  p1 = v->vecteur ();
  val = p1.y;
}
