/* cp_util.c   utility routines for drawing in canvases */

/* cc cp_util.c -o cp_util.o -c -g -lm complex_math.o */

/* basic structure = box, labeled by lower left and upper right corner.
Have pixel box for screen and real box for real-world locations */

#include <math.h>
#include "complex_math.h"
#include "hyp_math.h"
#include "cp_util.h"

void
r_to_pix(pt,normpt,pix_box,box) /* real pt in box converted to float
normpt relative to pix_box. */
complex pt,*normpt;
Box box;
Pix_box pix_box;
{
	normpt->re=pix_box.lx+
		(pix_box.rx-pix_box.lx)*((pt.re-box.lx)/(box.rx-box.lx));
	normpt->im=pix_box.ry-
		(pix_box.ry-pix_box.ly)*((pt.im-box.ly)/(box.ry-box.ly));
		 /* note: have had to turn around the y-coords because
		    canvases think + is down */
	return;
} /* r_to_pix */

void
pix_to_r(x,y,realpt,pix_box,box) /* point (x,y) in pixels converted 
to complex. */
int x,y;
complex *realpt;
Pix_box pix_box;
Box box;
{
	float fac;

	fac=(float)(x-pix_box.lx)/(float)(pix_box.rx-pix_box.lx);
	realpt->re=box.lx+(box.rx-box.lx)*fac;
	fac=(float)(y-pix_box.ly)/(float)(pix_box.ry-pix_box.ly);
	realpt->im=box.ry-(box.ry-box.ly)*fac;
		 /* note: have had to turn around the y-coords because
		    canvases think + is down */
	return;
} /* pix_to_r */
	
int
line_ck(end1,end2,box) /* returns 1 if line is in circle circumscribing
box. This needs work. */
complex end1,end2;
Box box;
{
	float diag,m,a,cx,cy,x1,x2,y1,y2,lx,ly,w,h;

	lx=box.lx;ly=box.ly;
	w = (box.rx-lx)*0.5;  h =(box.ry-ly)*0.5;
	cx=lx+w;cy=ly+h;
	x1=end1.re-cx;y1=end1.im-cy;
	x2=end2.re-cx;y2=end2.im-cy;
	diag=(w*w+h*h); /* rad squared of circumscribed circle */
	if (x1*x1+y1*y1<diag || x2*x2+y2*y2<diag) return 1;
	if (y1==y2)
	 {
		if (y1<ly || y1>cy+h) return 0;
		if ((x1<lx && x2>lx) || (x2<lx && x1>lx)) return 1;
		if ((x1<cx+w && x2>cx+w) || (x2<cx+w && x1>cx+w)) return 1;
		return 0;
	 }
	if (x1==x2)
	 {
		if (x1<lx || x1>cx+w) return 0;
		if ((y1<ly && y2>ly) || (y2<ly && y1>ly)) return 1;
		if ((y1<cy+h && y2>cy+h) || (y2<cy+h && y1>cy+h)) return 1;
		return 0;
	 }
	m=(y1-y2)/(x1-x2); /* slope */
	a=m*x1-y1;
	if (a*a/(m*m+1) < diag) return 1;
	return 0;
} /* line_ck */

int
cir_ck(ctr,rad,box) /* return 1 if circle approx hits box. Needs more work. */
float rad;
complex ctr;
Box box;
{
	float lx,ly,rx,ry;

	lx =box.lx-rad; ly =box.ly-rad; rx=box.rx+rad;  ry=box.ry+rad;
	if (ctr.re>lx && ctr.re<rx && ctr.im>ly && ctr.im<ry) return 1;
	else return 0;
} /* cir_ck */
	
int
geo_ck(hg,box) /* return 1 if the geodesic is part of circle hitting box */
hyp_geodesic hg;
Box box;

{
	if ( 
		(hg.line_flag && line_ck(hg.z1,hg.z2,box)) || 
		cir_ck(hg.c,hg.rad,box) 
	   ) return 1;
	else return 0;
} /* geo_ck */


