// $Id: interf_aux.hh,v 1.1 1998/10/25 23:39:47 cthulhu Exp $

#include "tcl_interf.hh"

char *strnstr(char *haystack,char *needle);
char *strrep(char *destination,char *substring,char *replacement);
char *strnrep(char *destination,char *substring,char *replacement);
int SearchCell(Sheet *sheet, Tcl_Interp *interp, char *search, char *replace,
	       int i, int j, int form, int vals, int exact, int whole);

void reverse(char *s);
char *itof(double n,char *s);
char *itoa(int n,char *s);
void join_formulas_op_all(Sheet *sheet, Cell *from,Cell *to,int op,int inv,
			  int all);
void join_formulas_op_val(Cell *from,Cell *to,int op);
void paste_cell(Sheet *sheet,Cell *from,Cell *to,int what, int how);

int CompareStrings(char *str1,char *str2);
int CompareCells(const void *val1,const void *val2);
SortList *BuildSortColumnVector(Sheet *sheet,SortList *list,Range rng,
				short *i);
SortList *BuildSortRowVector(Sheet *sheet,SortList *list,Range rng,
			     short *i);
SortList *RearrangeSortColumn(Sheet *sheet,SortList *list,Range rng,short *i,
			      array<Cell*> *to_calc);
SortList *RearrangeSortRow(Sheet *sheet,SortList *list,Range rng,short *i,
			   array<Cell*> *to_calc);
SortList *SwapKeyValue(SortList *list,short i,short Key);

void ApplyCRFormat(Sheet *sheet, short col_or_row, int index, 
		   CR_Formats format, Format *fmt);

// $Log: interf_aux.hh,v $
// Revision 1.1  1998/10/25 23:39:47  cthulhu
// Initial revision
//
