# source.tcl --
#
# This file contains code which handles shows the soruce of a bodypart
#
#
#  TkRat software and its included text is Copyright 1996,1997,1998
#  by Martin Forssn
#
#  Postilion software and its included text and images
#  Copyright (C) 1998 Nic Bernstein
#
#  The full text of the legal notices is contained in the files called
#  COPYING and COPYRIGHT.TkRat, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# ShowSource
#
# Shows the source of a bodypart
#
# Arguments:
# body   - The bodypart to show

proc ShowSource {body} {
    global idCnt t showParams option defaultFont

    # Create identifier
    set id sourceWin[incr idCnt]
    set w .$id

    # Create toplevel
    toplevel $w -class Postilion
    wm title $w $t(source)
    wm group $w .

    set normal $defaultFont

    # Type
    set type [$body type]
    set tstring [string tolower [lindex $type 0]/[lindex $type 1]]
    frame $w.type
    label $w.type.label -width 15 -anchor e -text $t(type):
    label $w.type.value -text $tstring -font $normal
    pack $w.type.label \
	 $w.type.value -side left
    pack $w.type -side top -anchor w
    # Description
    if [string length [$body description]] {
	frame $w.desc
	label $w.desc.label -width 15 -anchor e -text $t(description):
	label $w.desc.value -text [$body description] -font $normal
	pack $w.desc.label \
	     $w.desc.value -side left
        pack $w.desc -side top -anchor w
    }
    # Size
    frame $w.size
    label $w.size.label -width 15 -anchor e -text $t(size):
    label $w.size.value -text [RatMangleNumber [$body size]] -font $normal
    pack $w.size.label \
	 $w.size.value -side left
    pack $w.size -side top -anchor w
    # Parameters
    set typepair [$body type]
    set type [string tolower [lindex $typepair 0]/[lindex $typepair 1]]
    if [info exists showParams($type)] {
	foreach p $showParams($type) {
	    frame $w.p_$p
	    label $w.p_$p.label -width 15 -anchor e -text $t($p):
	    label $w.p_$p.value -text [$body paramete $p] -font $normal
	    pack $w.p_$p.label \
		 $w.p_$p.value -side left
	    pack $w.p_$p -side top -anchor w
	}
    }
    # Encodings
    frame $w.enc
    label $w.enc.label -width 15 -anchor e -text $t(encoding):
    label $w.enc.value -text [$body encoding] -font $normal
    pack $w.enc.label \
         $w.enc.value -side left
    pack $w.enc -side top -anchor w

    # The data
    frame $w.text -relief sunken -bd 1
    scrollbar $w.text.scroll \
              -relief sunken \
              -command "$w.text.text yview" \
              -highlightthickness 0
    text $w.text.text \
         -yscroll "$w.text.scroll set" \
         -setgrid true \
         -wrap char \
         -font $defaultFont \
         -bd 0 \
         -highlightthickness 0
    Size $w.text.text source
    pack $w.text.scroll -side left -fill y
    pack $w.text.text -expand yes -fill both
    pack $w.text -side top -expand yes -fill both

    # The buttons
    button $w.dismiss -text $t(dismiss) -command "RecordPos $w showSource; \
	    RecordSize $w.text.text source; destroy $w"
    button $w.save -text $t(save_to_file)... -command "SaveBody $body"
    pack $w.save \
         $w.dismiss -side left -expand 1 -pady 5

    # Insert the source into the text widget
    regsub -all "\r\n" [$body data true] "\n" data
    $w.text.text insert end $data

    Place $w showSource
}
