# dotext.tcl
#
# See README for information about what this program does.
#
#
#  TkRat software and its included text is Copyright 1996,1997,1998
#  by Martin Forssn
# 
#  Postilion software and its included text and images
#  Copyright (C) 1998 Nic Bernstein
# 
#  The full text of the legal notices is contained in the files called
#  COPYING and COPYRIGHT.TkRat, included with this distribution.
# 
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


###########################################################################
# List of languages							  #
# Each language is represented by a list of three elements. The first is  #
# the shorthand name of the language (this is the name which is used in   #
# all the structures, filenames and procedures. The second is the name of #
# the language (in the language itself) (this will be used in menus etc). #
# The last element is the character set that should be used for this      #
# language. If there is no font for this charset available then the user  #
# will not see the language in the list of possible choices.              #
###########################################################################
set languages { {sv Svenska iso-8859-1} 
		{en English us-ascii}
		{it Italiano iso-8859-1}
		{fr Franais iso-8859-1}
}

######################################################
# YOU DO NOT NEED TO MODIFY ANYTHING BELOW THIS LINE #
######################################################

# Directory where we should store the output files:
set outdir ..

# The following message is inserted at the top of every generated file
set message {#
# DO NOT EDIT!
#
# This file is automatically generated from files in the Text/ subdirectory
#
#  TkRat software and its included text is Copyright 1996 by Martin Forssen.
#
#  WMRat and Postilion software and its included text is Copyright 1997 by Nic Bernstein
#
#  The full text of the legal notices is contained in the files called
#  COPYRIGHT and COPYRIGHT.TkRat, included with this distribution.
#
}

# First we should create the language procedures
foreach l $languages {
    proc [lindex $l 0] m "global lab text; set text([lindex $l 0],\$lab) \$m"
}

# variable --
#
# Sets the variable name that the messages from this file will end up in.
#
# Arguments:
# name -	The variable name

proc variable {name} {
    global varName
    set varName $name
}

# label --
#
# Sets the label to be used for all subsequent language commands, that
# is until the next call to this function.
#
# Arguments:
# l -	The label

proc label {l} {
    global lab labels
    if { -1 != [lsearch -exact $labels $l]} {
	puts "*** Label '$l' is already defined"
	exit
    }
    lappend labels $l
    set lab $l
}


# Now we should build the languages.tcl file, we start by definig the
# procedures.
set getLanguages "proc GetLanguages {} {return \"$languages\"}"
set initMessages {
# InitMessages --
#
# Initializes a set of messages.
#
# Arguments:
# lang -	The language if the messages
# var  -	The variable the messages are in

proc InitMessages {lang var} {
    upvar #0 currentLanguage_$var currentLanguage

    set currentLanguage $lang
    eval init_${var}_${lang}
}

}

set fh [open $outdir/languages.tcl w]
puts $fh $message
puts $fh ""
puts $fh $getLanguages
puts $fh ""
puts $fh $initMessages
close $fh


# Source the text input files and write the apropriate output file after
# each input file is read.
foreach f [glob *.text] {
    set labels {}

    # Read data
    source $f

    # Write datafiles
    foreach lang $languages {
	set l [lindex $lang 0]
	set fh [open $outdir/text_${varName}_${l}.tcl w]
	puts $fh $message
	puts $fh ""
	puts $fh "# The following is the function which does the actual work"
	puts $fh "proc init_${varName}_${l} {} {"
	puts $fh "global $varName"
	foreach n $labels {
	    if [info exists text($l,$n)] {
		set rl $l
	    } else {
		puts "Text $n not found in [lindex $lang 1] substituting English"
		set rl en
	    }
	    puts $fh "set ${varName}($n) [list $text($rl,$n)]"
	}
	puts $fh "}"
	close $fh
    }
    catch {unset labels}
    catch {unset text}
}
