
static char rcsid[] = "@(#)$Id: limit.c,v 1.3 1999/04/11 18:11:34 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This stuff is inspired by MH and dmail and is used to 'select'
    a subset of the existing mail in the folder based on one of a
    number of criteria.  The basic tricks are pretty easy - we have
    as status of VISIBLE associated with each header stored in the
    (er) mind of the computer (!) and simply modify the commands to
    check that flag...the global variable `selected' is set to the
    number of messages currently selected, or ZERO if no select.
**/

#include "headers.h"
#include "s_elm.h"
#include "s_aliases.h"
#include "me.h"

#define TO		1
#define FROM		2
#define CC              3

char *shift_lower();
void ClearSelection();

int
limit()
{
	/** returns non-zero if we changed selection criteria = need redraw **/
	
	char criteria[STRING], first[STRING], rest[STRING], msg[STRING];
	static char *prompt = NULL;
	int  last_selected, all;
	char 	ch_s[255];
	char  	*ch_p;

	last_selected = selected;
	all = 0;
	if (prompt == NULL) {
	  prompt = catgets(elm_msg_cat, ElmSet, ElmLimitEnterCriteria,
		"Enter criteria or '?' for help: ");
	}

	if (selected) {
	  elm_sfprintf(msg, sizeof msg,
		       CATGETS(elm_msg_cat, ElmSet, ElmLimitAlreadyHave,
			       "Already have selection criteria - add more? (%c/%c) %c%c"),
		       *def_ans_yes, *def_ans_no, *def_ans_no, BACKSPACE);
	  PutLine0(elm_LINES-2, 0, msg);
	  criteria[0] = ReadCh(0);
	  if (
#ifdef ASCII_CTYPE
	      isascii(criteria[0]) &&
#endif
	      tolower((unsigned char)criteria[0]) == *def_ans_yes) {
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmYesWord, "Yes."));
	    PutLine0(elm_LINES-3, elm_COLUMNS-30, 
		     catgets(elm_msg_cat, ElmSet, ElmLimitAdding,
			     "Adding criteria..."));
	  } else {
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmNoWord, "No."));
	    PutLine0(elm_LINES-3, elm_COLUMNS-30, 
		     catgets(elm_msg_cat, ElmSet, ElmLimitChanging,
			     "Change criteria..."));
	    selected = 0;
	  }
	}

	while(1) {
	  PutLine0(elm_LINES-2, 0, prompt);
	  CleartoEOLN();

	  criteria[0] = '\0';
	  if (0 != optionally_enter(criteria, elm_LINES-2, strlen(prompt), 0,
				    sizeof criteria))
	    return TRUE;

	  clear_error();
	  
	  if (strlen(criteria) == 0) {
	    /* no change */
	    selected = last_selected;
	    return(FALSE);	
	  }

	  split_word(criteria, first, rest);

	  if (inalias) {
	    if (equal(first, "?")) {
	      if (last_selected)
	        lib_error(CATGETS(elm_msg_cat, AliasesSet, 
				  AliasesEnterLastSelected,
				  "Enter:{\"name\",\"alias\"} [pattern] OR {\"person\",\"group\",\"user\",\"system\"} OR \"all\""));
	      else
	        lib_error(CATGETS(elm_msg_cat, AliasesSet, 
				  AliasesEnterSelected,
				  "Enter: {\"name\",\"alias\"} [pattern] OR {\"person\",\"group\",\"user\",\"system\"}"));
	      continue;
	    }
	    else if (equal(first, "all")) {
	      all++;
	      selected = 0;
	    }
	    else if (equal(first, "name"))
	      selected = limit_alias_selection(BY_NAME, rest, selected);
	    else if (equal(first, "alias"))
	      selected = limit_alias_selection(BY_ALIAS, rest, selected);
	    else if (equal(first, "person"))
	      selected = limit_alias_selection(PERSON, rest, selected);
	    else if (equal(first, "group"))
	      selected = limit_alias_selection(GROUP, rest, selected);
	    else if (equal(first, "user"))
	      selected = limit_alias_selection(USER, rest, selected);
	    else if (equal(first, "system"))
	      selected = limit_alias_selection(SYSTEM, rest, selected);
	    else {
	      lib_error(CATGETS(elm_msg_cat, ElmSet, 
				ElmLimitNotValidCriterion,
				"\"%s\" not a valid criterion."), 
			first);
	      continue;
	    }
	    break;
	  }
	  else {
	    if (equal(first, "?")) {
	      if (last_selected)
	        lib_error(CATGETS(elm_msg_cat, ElmSet, ElmEnterLastSelected,
				  "Enter: {\"subject\",\"to\",\"from\",\"cc\"} [pattern] OR {\"thread\",\"tagged\",\"all\"}"));
	      else
	        lib_error(CATGETS(elm_msg_cat, ElmSet, ElmEnterSelected,
				  "Enter: {\"subject\",\"to\",\"from\"} [pattern] OR \"thread\",\"tagged\"}"));
	      continue;
	    }
	    else if (equal(first, "all")) {
	      all++;
	      selected = 0;
	    }
	    else if (equal(first, "tagged"))
	      selected = SelectTaggedMessages();
	    else {
	      char *c, *p, buf[STRING], buf2[STRING];
	      int complx = 0, err = 0, iter = 0;

	      if (!selected)
		ClearSelection();
		
	      /* this next bit of code assumes that the input string is a
		 list of "and"ed or "or"ed items.  NOTE: it assumes that
		 if the first operator is "and", then all operators are "and",
		 and vice-versa. */
	      strfcpy(buf, first, sizeof buf);
	      strfcat(buf, " ", sizeof buf);
	      strfcat(buf, rest, sizeof buf);
	      p = buf;
	      if (index(p, '&') != NULL)
		complx = 1;
	      while ((c = strtok(p, "|&")) != NULL) {
		while (*c && isspace(*c)) ++c;
		p = c;
		while (*p && !isspace(*p)) ++p;
		while (*p && isspace(*p)) ++p;
		strfcpy(buf2, p, sizeof buf2);
		remove_possible_trailing_spaces(buf2);
		if (strncmp(c, "subj", 4) == 0)
		  limit_selection(SUBJECT, buf2, selected||(complx&&iter!=0));
		else if (strncmp(c, "to", 2) == 0)
		  limit_selection(TO, buf2, selected||(complx&&iter!=0));
		else if (strncmp(c, "cc", 2) == 0)
		  limit_selection(CC, buf2, selected||(complx&&iter!=0));
		else if (strncmp(c, "from", 4) == 0)
		  limit_selection(FROM, buf2, selected||(complx&&iter!=0));
		else if (strncmp(c, "thread", 6) == 0) {
		  if (!headers)
		    continue;
		  strfcpy(ch_s, headers[current-1]->subject, sizeof(ch_s));
		  ch_p=&ch_s[0]; while (*ch_p) {
#ifdef ASCII_CTYPE
		    if (isascii(*ch_p))
#endif
		      *ch_p=(char)tolower((unsigned char)*ch_p); 
		    ch_p++;
		  }
		  if (strncmp(ch_s,"re: ",4) == 0) {
		    limit_selection(SUBJECT,ch_s+4,selected||(complx&&iter!=0));
		    } else {
		    limit_selection(SUBJECT,ch_s, selected||(complx&&iter!=0));
		    }
		  }
		else {
		  if ((p = index(c, ' ')) != NULL)
		    *p = '\0';
		  lib_error(CATGETS(elm_msg_cat, ElmSet, 
				    ElmLimitNotValidCriterion,
				    "\"%s\" not a valid criterion."), 
			    c);
		  err = 1;
		  break;
		}
		p = NULL;
		++iter;
	      }
	      if (err)
		continue;
	      selected = TallySelection();
	    }
	    break;
	  }
        }

	if (all && last_selected)
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLimitReturnToUnlimited,
			    "Returned to unlimited display."));
	else {
	  if (inalias) {
	    if (selected > 1)
	      lib_error(CATGETS(elm_msg_cat, AliasesSet,
				AliasesLimitMessagesSelected, 
				"%d aliases selected."),
			selected);
	    else if (selected == 1)
	      lib_error(CATGETS(elm_msg_cat, AliasesSet,
				AliasesLimitMessageSelected, 
				"1 alias selected."));
	    else
	      lib_error(CATGETS(elm_msg_cat, AliasesSet,
				AliasesLimitNoMessagesSelected, 
				"No aliases selected."));
	  }
	  else {
	    if (selected > 1)
	      lib_error(CATGETS(elm_msg_cat, ElmSet,
				ElmLimitMessagesSelected, 
				"%d messages selected."), 
			selected);
	    else if (selected == 1)
	      lib_error(CATGETS(elm_msg_cat, ElmSet, 
				ElmLimitMessageSelected,
				"1 message selected."));
	    else
	      lib_error(CATGETS(elm_msg_cat, ElmSet,
				ElmLimitNoMessagesSelected, 
				"No messages selected."));
	  }
	}

	/* we need a redraw if there had been a selection or there is now. */
	if (last_selected || selected) {
	  /* if current message won't be on new display, go to first message */
	  if (selected && !(ifmain(headers[current-1]->status,
	                           aliases[current-1]->status) & VISIBLE))
	    current = visible_to_index(1)+1;
	  return(TRUE);
	} else {
	  return(FALSE);
	}
}

int
limit_selection(based_on, pattern, additional_criteria)
     int based_on, additional_criteria;
     char *pattern;
{
	int iindex;
	
	for (iindex = 0 ; iindex < message_count ; iindex++) {
	  int match;

	  switch (based_on) {

	  case FROM:
	    match = from_matches(iindex,pattern);
	    break;
	  case TO:
	    match = to_matches(iindex,pattern);
	    break;
	  case CC:
	    match = cc_matches(iindex,pattern);
	    break;
	  case SUBJECT:
	  default:
	    match = subject_matches(iindex,pattern);
	    break;
	  }

	  if (additional_criteria) {
	    if (headers[iindex]->status & VISIBLE) {
	      if (!match)
		headers[iindex]->status &= ~VISIBLE;
	    }
	  }
	  else if (match)
	    headers[iindex]->status |= VISIBLE;
        }
	return 0;
}

int
limit_alias_selection(based_on, pattern, additional_criteria)
int based_on, additional_criteria;
char *pattern;
{
	/** Given the type of criteria, and the pattern, mark all
	    non-matching aliases as ! VISIBLE.  If additional_criteria,
	    don't mark as visible something that isn't currently!
	**/

	register int iindex, count = 0;

	dprint(2, (debugfile, "\n\n\n**limit on %d - '%s' - (%s) **\n\n",
		   based_on, pattern, additional_criteria?"add'tl":"base"));

	if (based_on == BY_NAME) {
	  for (iindex = 0; iindex < message_count; iindex++)
	    if (! in_string(shift_lower(aliases[iindex]->name), pattern))
	      clearit(aliases[iindex]->status, VISIBLE);
	    else if (additional_criteria && 	
		     !(aliases[iindex]->status & VISIBLE))
	      clearit(aliases[iindex]->status, VISIBLE);	/* shut down! */
	    else { /* mark it as readable */
	      setit(aliases[iindex]->status, VISIBLE);
	      count++;
	      dprint(5, (debugfile,
		     "  Alias %d (%s, %s) marked as visible\n",
			iindex, aliases[iindex]->alias,
			aliases[iindex]->name));
	    }
	}
	else if (based_on == BY_ALIAS) {
	  for (iindex = 0; iindex < message_count; iindex++)
	    if (! in_string(shift_lower(aliases[iindex]->alias), pattern))
	      clearit(aliases[iindex]->status, VISIBLE);
	    else if (additional_criteria && 	
		     !(aliases[iindex]->status & VISIBLE))
	      clearit(aliases[iindex]->status, VISIBLE);	/* shut down! */
	    else { /* mark it as readable */
	      setit(aliases[iindex]->status, VISIBLE);
	      count++;
	      dprint(5, (debugfile, 
			"  Alias %d (%s, %s) marked as visible\n",
			iindex, aliases[iindex]->alias,
			aliases[iindex]->name));
	    }
	}
	else {
	  for (iindex = 0; iindex < message_count; iindex++)
	    if (! (based_on & aliases[iindex]->type))
	      clearit(aliases[iindex]->status, VISIBLE);
	    else if (additional_criteria && 	
		     !(aliases[iindex]->status & VISIBLE))
	      clearit(aliases[iindex]->status, VISIBLE);	/* shut down! */
	    else { /* mark it as readable */
	      setit(aliases[iindex]->status, VISIBLE);
	      count++;
	      dprint(5, (debugfile,
			"  Alias %d (%s, %s) marked as visible\n",
			iindex, aliases[iindex]->alias,
			aliases[iindex]->name));
	    }
	}

	dprint(4, (debugfile, "\n** returning %d selected **\n\n\n", count));

	return(count);
}

int
next_message(iindex, skipdel)
register int iindex, skipdel;
{
	/** Given 'iindex', this routine will return the actual iindex into the
	    array of the NEXT message, or '-1' iindex is the last.
	    If skipdel, return the iindex for the NEXT undeleted message.
	    If selected, return the iindex for the NEXT message marked VISIBLE.
	**/

	register int remember_for_debug, stat;

	if (iindex < 0) return(-1);	/* invalid argument value! */

	remember_for_debug = iindex;

	for(iindex++;iindex < message_count; iindex++) {
	  stat = ifmain(headers[iindex]->status, aliases[iindex]->status);
	  if (((stat & VISIBLE) || (!selected))
	    && (!(stat & DELETED) || (!skipdel))) {
	      dprint(9, (debugfile, "[Next%s%s: given %d returning %d]\n", 
		  (skipdel ? " undeleted" : ""),
		  (selected ? " visible" : ""),
		  remember_for_debug+1, iindex+1));
	      return(iindex);
	  }
	}
	return(-1);
}

int
prev_message(iindex, skipdel)
register int iindex, skipdel;
{
	/** Like next_message, but the PREVIOUS message. **/

	register int remember_for_debug, stat;

	if (iindex >= message_count) return(-1);	/* invalid argument value! */

	remember_for_debug = iindex;
	for(iindex--; iindex >= 0; iindex--) {
	  stat = ifmain(headers[iindex]->status, aliases[iindex]->status);
	  if (((stat & VISIBLE) || (!selected))
	    && (!(stat & DELETED) || (!skipdel))) {
	      dprint(9, (debugfile, "[Previous%s%s: given %d returning %d]\n", 
		  (skipdel ? " undeleted" : ""),
		  (selected ? " visible" : ""),
		  remember_for_debug+1, iindex+1));
	      return(iindex);
	  }
	}
	return(-1);
}


int
compute_visible(message)
int message;
{
	/** return the 'virtual' iindex of the specified message in the
	    set of messages - that is, if we have the 25th message as
	    the current one, but it's #2 based on our limit criteria,
	    this routine, given 25, will return 2.
	**/

	register int iindex, count = 0;

	if (! selected) return(message);

	if (message < 1) message = 1;	/* normalize */

	for (iindex = 0; iindex < message; iindex++)
	   if (ifmain(headers[iindex]->status,
	              aliases[iindex]->status) & VISIBLE)
	     count++;

	dprint(4, (debugfile,
		"[compute-visible: displayed message %d is actually %d]\n",
		count, message));

	return(count);
}

int
visible_to_index(message)
int message;
{
	/** Given a 'virtual' iindex, return a real one.  This is the
	    flip-side of the routine above, and returns (message_count+1)
	    if it cannot map the virtual iindex requested (too big) 
	**/

	register int iindex = 0, count = 0;

	for (iindex = 0; iindex < message_count; iindex++) {
	   if (ifmain(headers[iindex]->status,
	              aliases[iindex]->status) & VISIBLE)
	     count++;
	   if (count == message) {
	     dprint(4, (debugfile,
		     "visible-to-index: (up) index %d is displayed as %d\n",
		     message, iindex));
	     return(iindex);
	   }
	}

	dprint(4, (debugfile, "index %d is NOT displayed!\n", message));

	return(message_count+1);
}

void
ClearSelection() {
  int iindex;

  for (iindex = 0; iindex < message_count; iindex++)
    headers[iindex]->status &= ~VISIBLE;
}

int
TallySelection() {
  int iindex, count = 0;

  for (iindex = 0 ; iindex < message_count ; iindex++)
    if (headers[iindex]->status & VISIBLE)
      ++count;
  return(count);
}

int
SelectTaggedMessages() {
  int iindex, count = 0;

  for (iindex = 0; iindex < message_count; iindex++)
    if (headers[iindex]->status & TAGGED) {
      headers[iindex]->status |= VISIBLE;
      ++count;
    } else
      headers[iindex]->status &= ~VISIBLE;
  return(count);
}
