/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"rfc1035.h"
#include	<errno.h>
#include	"rfc1035_res.h"

static const char rcsid[]="$Id: rfc1035qptr.c,v 1.2 1999/12/06 13:24:23 mrsam Exp $";

/* Convenient function to do reverse IP lookup */

int rfc1035_ptr(struct rfc1035_res *res, struct in_addr ia, char *name)
{
const char *p;
unsigned char a=0,b=0,c=0,d=0;
struct	rfc1035_reply *reply;
int	n;

	rfc1035_ntoa(ia, name);
	p=name;

	while (*p >= '0' && *p <= '9')
		a= (int)a * 10 + (*p++ - '0');
	if (*p)	p++;
	while (*p >= '0' && *p <= '9')
		b= (int)b * 10 + (*p++ - '0');
	if (*p)	p++;
	while (*p >= '0' && *p <= '9')
		c= (int)c * 10 + (*p++ - '0');
	if (*p)	p++;
	while (*p >= '0' && *p <= '9')
		d= (int)d * 10 + (*p++ - '0');

	sprintf(name, "%d.%d.%d.%d.in-addr.arpa",
		(int)d, (int)c, (int)b, (int)a);

	if (rfc1035_resolve_cname(res, RFC1035_RESOLVE_RECURSIVE, name,
		RFC1035_TYPE_PTR, RFC1035_CLASS_IN, &reply) < 0 ||
		reply == 0 ||
		(n=rfc1035_replysearch_all( reply, name, RFC1035_TYPE_PTR,
			RFC1035_CLASS_IN, 0)) < 0 ||
		rfc1035_replyhostname(reply, reply->allrrs[n]->rr.domainname,
			name) == 0)
	{
		if (reply && reply->rcode != RFC1035_RCODE_NXDOMAIN)
		{
			rfc1035_replyfree(reply);
			errno=EAGAIN;
			return (-1);
		}

		if (reply) rfc1035_replyfree(reply);
		errno=ENOENT;
		return (-1); /* hard error */
	}

	rfc1035_replyfree(reply);
	return (0);
}
