;;;
;;;  cmail-e20.el - cmail functions for emacs 20
;;; 
;;;  Author:        Toshihiko Ueki <toshi@he.kobelcosys.co.jp>
;;;  Created:       1997/08/22
;;;  Last modified: 1997/09/03
;;;
;;;  Copyright (C) 1995-1997 Yukihiro Matsumoto.

;;; cmail-e20.el

(provide 'cmail-e20)
(require 'cmail-20)

(setq *cmail-file-coding-system 'no-conversion)
(setq *cmail-primary-coding-system 'iso-2022-7bit)

(let ((alist cmail-highlight-attribute-alist) entry name fore back bold italic)
  (while (setq entry (pop alist))
    (setq name (nth 0 entry)
	  fore (nth 1 entry)
	  back (nth 2 entry)
	  bold (nth 3 entry)
	  italic (nth 4 entry))
    (if fore (set-face-foreground name fore))
    (if back (set-face-background name back))
    (if bold (set-face-bold-p name bold))
    (if italic (set-face-italic-p name italic))))

(cond (window-system
        (define-key menu-bar-tools-menu [rmail] '("Read Mail" . cmail))
	(define-key menu-bar-tools-menu [compose-mail] '("Send Mail" . cmail))

	(require 'cmail-e19)))
