/* 
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * Revision 0.2
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/menu.h"
#include "vdk/forms.h"
#include "vdk/vdkfont.h"

/* XPM */
static char *tick_xpm []=
{
"18 22 4 1",
"a c #808080",
"# c #000000",
". c None",
"b c #ffffff",
"......................",
"......................",
"................#a#...",
"...............aba#...",
"..............aba#....",
".............aba#.....",
".......a....aba#......",
"......aba..ab##.......",
".....ab..a#b.a#.......",
".....#a...b.##........",
".....##a....a#........",
"......##a..a#.........",
".......##a.a#.........",
"........##a#..........",
".........###..........",
"..........#...........",
"......................",
"......................"
};

/* XPM */
/*
  static char * mini_bball_xpm[] = {
  "16 14 4 1",
  " 	c None s None",
  ".	c blue",
  "X	c white",
  "o	c gray50",
  "                ",
  "                ",
  "                ",
  "                ",
  "      ...       ",
  "     .XX..      ",
  "     .XX..o     ",
  "     .....o     ",
  "      ...oo     ",
  "       ooo      ",
  "                ",
  "                ",
  "                ",
  "                "};
*/
/*
 */
VDKMenu::VDKMenu(VDKForm* owner): VDKObjectContainer(owner)
{
widget = gtk_menu_new();
accel_group = gtk_accel_group_new ();
if(accel_group)
  gtk_accel_group_attach (accel_group, GTK_OBJECT (widget));
Parent(owner);
}
/*
 */
VDKMenu::~VDKMenu()
{
}

/*
 */
void 
VDKMenu::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding)
{
  VDKMenuItem* menuitem = dynamic_cast<VDKMenuItem*>(wid);
  g_return_if_fail(menuitem != NULL);
  switch(justify)
    {
    case l_justify:
      gtk_menu_append(GTK_MENU(Widget()),wid->Widget());
      break;
    case r_justify:
      gtk_menu_prepend(GTK_MENU(Widget()),wid->Widget());
      break;
    default:
      if(justify >= pos_justify)
	gtk_menu_insert(GTK_MENU(Widget()),wid->Widget(),justify-pos_justify);
      break;
    }
  gtk_widget_show(wid->Widget());
  AddItem(wid);
  wid->Parent(this);
  if(menuitem->AccKey() != GDK_VoidSymbol)
    gtk_widget_add_accelerator (menuitem->Widget(),
				"activate_item",
				AccelGroup(),
				menuitem->AccKey(), 
				menuitem->ModKey(),
				(GtkAccelFlags)(GTK_ACCEL_LOCKED|
				GTK_ACCEL_VISIBLE|
				GTK_ACCEL_SIGNAL_VISIBLE));
}

void 
VDKMenu::Separator()
{
GtkWidget* sep = gtk_menu_item_new ();
gtk_container_add (GTK_CONTAINER (widget), sep);
gtk_widget_show(sep);
}
/*
 */
void VDKMenu::SetFont(VDKFont* font)
{

ItemListIterator li(items);
for(;li;li++)
  li.current()->SetFont(font);
}
/*
 */
void VDKMenu::Popup(guint button, guint32 activate_time)
{
  /*
    probably this kind of menu isn't showed before
    this call, so try to add to owner item list.
    add() method will assures won't be added twice
  */
  Owner()->AddItem(this);
  gtk_menu_popup(GTK_MENU(widget),
		 NULL,NULL,NULL,NULL,
		 button, activate_time);
}
/*
 */
VDKMenuItem::VDKMenuItem(VDKMenu* menu ,
			 char* prompt, 
			 char** pix,
			 guint key,
			 guint8 modkey):
  VDKObject(menu->Owner()),
  Checked("Checked",this,false,&VDKMenuItem::Tick),
  Caption ("Caption", this, prompt, &VDKMenuItem::SetCaption,
	   &VDKMenuItem::GetCaption)
{
  GdkBitmap *mask = NULL;
  GtkStyle* style = NULL;
  widget = gtk_menu_item_new();
  box = gtk_hbox_new(FALSE,0);
  gtk_container_border_width(GTK_CONTAINER(box),1);
  // packs tick
  style = gtk_widget_get_style(owner->Window());
  tickPixmap = gdk_pixmap_create_from_xpm_d(owner->Window()->window,
					      &mask,
					      &style->bg[GTK_STATE_NORMAL],
					      tick_xpm);
  tickWidget = gtk_pixmap_new(tickPixmap,mask);
  gtk_box_pack_start(GTK_BOX(box),tickWidget,FALSE,FALSE,1);
  // packs pixmap
  if(pix)
    {
      style = gtk_widget_get_style(owner->Window());
      pixmap = gdk_pixmap_create_from_xpm_d(owner->Window()->window,
					  &mask,
					  &style->bg[GTK_STATE_NORMAL],
					  pix);
      pixmapWidget = gtk_pixmap_new(pixmap,mask);
      gtk_box_pack_start(GTK_BOX(box),pixmapWidget,FALSE,FALSE,1);
      gtk_widget_show(pixmapWidget);
    }
  else
    pixmap = NULL;
  // packs label and set accelerator
  lbl  = gtk_accel_label_new(prompt);
  gtk_box_pack_start(GTK_BOX(box),lbl,FALSE,FALSE,1);
  gtk_widget_show(lbl);
  VDKMenuItem::modkey = modkey;
  accelerator_key = key == GDK_VoidSymbol ?
    gtk_label_parse_uline (GTK_LABEL (lbl), prompt):
    key ;
  if (accelerator_key != GDK_VoidSymbol)
    gtk_widget_add_accelerator (widget,
				"activate",
				menu->AccelGroup(),
				accelerator_key, 
				modkey,
				(GtkAccelFlags)(GTK_ACCEL_LOCKED|
				GTK_ACCEL_VISIBLE|
				GTK_ACCEL_SIGNAL_VISIBLE));  

    ////////////////  
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(widget),box);
  s_activated.obj = this;
  s_activated.signal = activate_signal;
  gtk_menu_append(GTK_MENU(menu->Widget()),widget);
  gtk_widget_show(widget);
  menu->AddItem(this);
  //Parent(menu->Owner());
  Parent(menu);
  gtk_signal_connect(GTK_OBJECT(widget),"activate",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_activated);
  //  ConnectDefaultSignals();
  tickPixmap = NULL;
  tickWidget = NULL;
  ticked = false;
}
/*
 */
void 
VDKMenuItem::SetCaption(char* str)
{
    gtk_label_set_text (GTK_LABEL(lbl),str);
    accelerator_key =  gtk_label_parse_uline (GTK_LABEL (lbl), str);
    VDKMenu* menu = NULL;
    VDKMenubar* bar = NULL;
    bar = dynamic_cast<VDKMenubar*>(Parent());
    if(bar && (accelerator_key != GDK_VoidSymbol))
      {
	gtk_widget_add_accelerator (widget,
				    "activate_item",
				    bar->AccelGroup(),
				    accelerator_key, 
				    modkey,
				    (GtkAccelFlags)(GTK_ACCEL_LOCKED|
				    GTK_ACCEL_VISIBLE|
				    GTK_ACCEL_SIGNAL_VISIBLE));
	return;
      }
    menu = dynamic_cast<VDKMenu*>(Parent());
    if(menu && (accelerator_key != GDK_VoidSymbol))
      {
	gtk_widget_add_accelerator (widget,
				    "activate",
				    menu->AccelGroup(),
				    accelerator_key, 
				    modkey,
				    (GtkAccelFlags)(GTK_ACCEL_LOCKED|
				    GTK_ACCEL_VISIBLE|
				    GTK_ACCEL_SIGNAL_VISIBLE));
	return;
      }
}
/*
 */
char* 
VDKMenuItem::GetCaption () 
{
  return GTK_LABEL(lbl)->label;
}
/*
 */
void
VDKMenuItem::SetPixmap(VDKRawPixmap* newpix)
{
  g_return_if_fail(newpix != NULL);
  if(!pixmap)
    {
      pixmap = *newpix;
      pixmapWidget = gtk_pixmap_new(pixmap,newpix->Mask());
      gtk_box_pack_start(GTK_BOX(box),pixmapWidget,FALSE,FALSE,1);
      gtk_widget_show(pixmapWidget);
    }
  else
    {
      pixmap = *newpix;
      gtk_pixmap_set (GTK_PIXMAP(pixmapWidget), 
		      pixmap, 
		      newpix->Mask());
      gtk_widget_queue_draw(pixmapWidget);
    }
}
/*
 */
VDKMenuItem::VDKMenuItem(VDKMenubar* bar,
			 char* prompt, 
			 char** pix, 
			 int align,
			 guint key,
			 guint8 modkey):
  VDKObject(bar->Owner()),
  Checked("Checked",this,false,&VDKMenuItem::Tick),
  Caption ("Caption", this, prompt, &VDKMenuItem::SetCaption,
	   &VDKMenuItem::GetCaption)
{
 widget = gtk_menu_item_new();
 box = gtk_hbox_new(FALSE,0);
 gtk_container_border_width(GTK_CONTAINER(box),1);
 // packs pixmap
  if(pix)
    {
      GdkBitmap *mask;
      GtkStyle* style = gtk_widget_get_style(owner->Window());
      pixmap = gdk_pixmap_create_from_xpm_d(owner->Window()->window,
					  &mask,
					  &style->bg[GTK_STATE_NORMAL],
					  pix);
      pixmapWidget = gtk_pixmap_new(pixmap,mask);
      gtk_box_pack_start(GTK_BOX(box),pixmapWidget,FALSE,FALSE,1);
      gtk_widget_show(pixmapWidget);
    }
  else
    pixmap = NULL;
  // packs label
  lbl  = gtk_accel_label_new(prompt);
  accelerator_key = key == GDK_VoidSymbol ?
    gtk_label_parse_uline (GTK_LABEL (lbl), prompt):
    key ;
  VDKMenuItem::modkey = modkey;
  if (accelerator_key != GDK_VoidSymbol)
    gtk_widget_add_accelerator (widget,
				"activate_item",
				bar->AccelGroup(),
				accelerator_key, 
				modkey,
				(GtkAccelFlags)(GTK_ACCEL_LOCKED|
				GTK_ACCEL_VISIBLE|
				GTK_ACCEL_SIGNAL_VISIBLE));
 if(pixmap)
   gtk_box_pack_start(GTK_BOX(box),lbl,FALSE,FALSE,1);
 else
   gtk_box_pack_end(GTK_BOX(box),lbl,FALSE,FALSE,1);
 gtk_widget_show(lbl);
 gtk_widget_show(box);
 gtk_container_add(GTK_CONTAINER(widget),box);
 s_activated.obj = this;
 s_activated.signal = activate_signal;
 gtk_signal_connect(GTK_OBJECT(widget),"activate",
		    GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		    (gpointer) &s_activated);
 if(align == r_justify)
   gtk_menu_item_right_justify(GTK_MENU_ITEM(widget));
 gtk_menu_bar_append(GTK_MENU_BAR(bar->Widget()),widget);
 gtk_widget_show(widget);
 bar->AddItem(this);
 Parent(bar);
 tickPixmap = NULL;
 tickWidget = NULL;
 ticked = false;
}
/*
 */
VDKMenuItem::VDKMenuItem(VDKForm* owner,
			 char* prompt, 
			 char** pix, 
			 int align,
			 guint key,
			 guint8 modkey):
  VDKObject(owner),
  modkey(modkey),
  Checked("Checked",this,false,&VDKMenuItem::Tick),
  Caption ("Caption", this, prompt, &VDKMenuItem::SetCaption,
	   &VDKMenuItem::GetCaption)
{

 widget = gtk_menu_item_new();
 box = gtk_hbox_new(FALSE,0);
 gtk_container_border_width(GTK_CONTAINER(box),1);
 // packs pixmap
  if(pix)
    { 
      GdkBitmap *mask;
      GtkStyle* style = gtk_widget_get_style(owner->Window());
      pixmap = gdk_pixmap_create_from_xpm_d(owner->Window()->window,
					  &mask,
					  &style->bg[GTK_STATE_NORMAL],
					  pix);
      pixmapWidget = gtk_pixmap_new(pixmap,mask);
      gtk_box_pack_start(GTK_BOX(box),pixmapWidget,FALSE,FALSE,1);
      gtk_widget_show(pixmapWidget);
    }
  else
    pixmap = NULL;
  // packs label
  lbl  = gtk_accel_label_new(prompt);
  accelerator_key = key == GDK_VoidSymbol ?
    gtk_label_parse_uline (GTK_LABEL (lbl), prompt): key;
  if(pixmap)
    gtk_box_pack_start(GTK_BOX(box),lbl,FALSE,FALSE,1);
  else
    gtk_box_pack_end(GTK_BOX(box),lbl,FALSE,FALSE,1);
  gtk_widget_show(lbl);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(widget),box);
  s_activated.obj = this;
  s_activated.signal = activate_signal;
  gtk_signal_connect(GTK_OBJECT(widget),"activate",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_activated);
  if(align == r_justify)
    gtk_menu_item_right_justify(GTK_MENU_ITEM(widget));
  tickPixmap = NULL;
  tickWidget = NULL;
  ticked = false;
}
/*
 */
void
VDKMenuItem::Tick(bool flag)
{
ticked  = flag;
if(flag)
  {
    if(!tickWidget)
      {
	GdkBitmap *mask;
	GtkStyle* style = gtk_widget_get_style(owner->Window());
	tickPixmap = gdk_pixmap_create_from_xpm_d(owner->Window()->window,
						  &mask,
						  &style->bg[GTK_STATE_NORMAL],
						  tick_xpm);
	tickWidget = gtk_pixmap_new(tickPixmap,mask);
	gtk_box_pack_start(GTK_BOX(box),tickWidget,FALSE,FALSE,1);
	gtk_widget_show(tickWidget);
      }
    else
      gtk_widget_show(tickWidget);
  }
else if(tickWidget) 
  gtk_widget_hide(tickWidget);
}
/*
 */
void VDKMenuItem::SetFont(VDKFont* font)
{
  _setFont_(lbl,font);
  ItemListIterator li(items);
  for(;li;li++)
    li.current()->SetFont(font);
}
/*
 */
VDKMenuItem::~VDKMenuItem()
{
  if(pixmap)
    gdk_pixmap_unref(pixmap);
  if(tickPixmap)
    gdk_pixmap_unref(tickPixmap);
}
/*
 */
void 
VDKMenuItem::Add(VDKMenu* submenu)
{
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(widget),submenu->Widget());
  AddItem(submenu);
  submenu->Parent(this);
}
/*
 */
VDKMenubar::VDKMenubar(VDKForm* owner):
  VDKObjectContainer(owner),
  Shadow("Shadow",this,shadow_out,&VDKMenubar::SetShadow)
{
  widget = gtk_menu_bar_new();
  accel_group = gtk_accel_group_new ();
  if(accel_group)
    gtk_window_add_accel_group(GTK_WINDOW(owner->Window()),
			       accel_group);
}
/*
 */
VDKMenubar::~VDKMenubar()
{

}
/*cd test
 */
void 
VDKMenubar::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding)
{
  VDKMenuItem* menuitem = dynamic_cast<VDKMenuItem*>(wid);
  g_return_if_fail(menuitem != NULL);
  switch(justify)
    {
    case l_justify:
      gtk_menu_bar_append(GTK_MENU_BAR(Widget()),wid->Widget());
      break;
    case r_justify:
      gtk_menu_bar_prepend(GTK_MENU_BAR(Widget()),wid->Widget());
      //gtk_menu_item_right_justify(GTK_MENU_ITEM(wid->Widget()));
      break;
    default:
      if(justify >= pos_justify)
	gtk_menu_bar_insert(GTK_MENU_BAR(Widget()),
			   wid->Widget(),justify-pos_justify);
      break;
    }
  gtk_widget_show(wid->Widget());
  AddItem(wid);
  wid->Parent(this);
  if(menuitem->AccKey() != GDK_VoidSymbol)
    gtk_widget_add_accelerator (menuitem->Widget(),
				"activate_item",
				AccelGroup(),
				menuitem->AccKey(), 
				menuitem->ModKey(),
				(GtkAccelFlags)(GTK_ACCEL_LOCKED|
				GTK_ACCEL_VISIBLE|
				GTK_ACCEL_SIGNAL_VISIBLE));
  

}
/*
 */
void VDKMenubar::SetFont(VDKFont* font)
{

ItemListIterator li(items);
for(;li;li++)
  li.current()->SetFont(font);
}

/*
 */
VDKOptionMenu::VDKOptionMenu(VDKForm* owner):
  VDKObject(owner)
{
widget = gtk_option_menu_new ();
}
/*
 */
VDKOptionMenu::~VDKOptionMenu()
{

}

void VDKOptionMenu::Add(VDKMenu* menu)
{
  gtk_option_menu_set_menu (GTK_OPTION_MENU (widget), 
			    menu->Widget());
  AddItem(menu);
  menu->Parent(this);
}


