/*  
file: sortlistwin.cc
*/
#include "sortlistwin.h"
#include <stdlib.h>
#include "waitcursor.h"
extern char* timesbold12;
extern char *mini_bball_xpm[];
char *titles[MAX_COL] = 
{ 
"Last name","First name","Address","City","ZIP"
};
ynad address[MAX_ADDR]=
{
  {{"Motta","Mario","via delle fonti 1","Montecolombo","98564"}},
  {{"Guerra","Tonino","via Arcangelo 6","Morciano","34567"}},
  {{"Plum","Adam","Strawberry street 678","Los Angeles","CA4567"}},
  {{"Jim","Uncle","Sky boulevard 34", "Paris", "FR5676"}},
  {{"Adelante", "Speedo","fast plaza", "Madrid","SP98767"}},
  {{"Streisand","Barbara","Star hill 567","Hollywood", "XX5676"}}
}; 
     
// signal map
DEFINE_SIGNAL_MAP(SortedListWindow,VDKForm) 
  ON_SIGNAL(add,clicked_signal,AddRow),
  ON_SIGNAL(addmany,clicked_signal,AddManyRow),
  ON_SIGNAL(quit,clicked_signal,Quit),
  ON_SIGNAL(del,clicked_signal,DeleteRow), 
  ON_SIGNAL(reload,clicked_signal,Reload),
  ON_SIGNAL(list,select_row_signal,ListDoubleClick)  
END_SIGNAL_MAP 
 
void
SortedListWindow::Setup()
{
  VDKBox *box1 = new VDKBox(this);
  VDKBox *hbox1 = new VDKBox(this,h_box);
  VDKBox *hbox2 = new VDKBox(this,h_box);
  VDKLabel* label = new VDKLabel(this,
				 "** Yet another address program **",
				 GTK_JUSTIFY_CENTER);
  label->SetForeground(VDKRgb(0,0,130)); // navy blue
  box1->Add(label);
  box1->Add(new VDKSeparator(this));
  list = new VDKCustomSortedList(this,KEYPOS,
				 MAX_COL,titles,
				 GTK_SELECTION_EXTENDED);
  list->ActiveTitles(false);
  list->SetSize(-1,list->RowHeight*8);
  list->SelectedBackground = new VDKColor(this,"dodger blue");
  list->Titles[0]->NormalBackground = VDKRgb(89,186,231);
  // set 4-th column right justified
  gtk_clist_set_column_justification (GTK_CLIST(list->CustomWidget()), 
				      4, GTK_JUSTIFY_RIGHT);
  // load address
  int t = 0;   
  for(;t < MAX_ADDR;t++) 
     list->AddRow(address[t].items);
  hbox1->Add(list); 
  box1->Add(hbox1);
  hbox2->Add(add = new VDKLabelButton(this,"Add a new address"));
  hbox2->Add(addmany = new VDKLabelButton(this,"Add 1000 addresses"));
  hbox2->Add(del = new VDKLabelButton(this,"Delete selected addresses"));
  hbox2->Add(reload = new VDKLabelButton(this,"Reload addresses"));
  reload->Enabled = false;
  hbox2->Add(quit = new VDKLabelButton(this,"Quit"));
  box1->Add(hbox2);
  Add(box1);
}

bool
SortedListWindow::DeleteRow(VDKObject*)
{

if(list->Selections().size() > 0)
  {
    int t;
    // create a string array of deleting keys 
    // StringArray is defined in vdkclist.h
    StringArray array(list->Selections().size());
    for(t = 0; t < array.size(); t++)
      {
	int row = list->Selections()[t];
	array[t] = list->Tuples[row][list->KeyPos()];
      }
    // deletes all key
    for(t = 0; t < array.size(); t++)
      {
	printf("\nremoving:(%s)", (char*) array[t]);
	fflush(stdout);
	list->RemoveKey(array[t]);
      }
  }
 else
   {
     int row = list->Selected.Row();
     if(row >= 0)
       list->RemoveRow(row);
   }
 if(list->Tuples.size() <= 0)
   reload->Enabled = true;
return true;
}

bool
SortedListWindow::Reload(VDKObject*)
{
int t = 0; 
for(;t < MAX_ADDR;t++)
  list->AddRow(address[t].items);
reload->Enabled = false;
return true;
}

bool
SortedListWindow::AddRow(VDKObject* sender)
{
  ynad addr;
  int t,z;
  char p[10];
  for(t = 0; t < 10;t++)
    p[t] = (char) 64+rand()%26;
  p[t] = '\0';
  z = rand()%MAX_ADDR; 
  addr.items[0] = p; 
  for(t = 1; t <MAX_COL;t++)
    addr.items[t] = address[z].items[t];
  list->AddKey(addr.items);
  return true;
} 

bool
SortedListWindow::AddManyRow(VDKObject*)
{
WaitCursor c(this);
list->Freeze();
for(int t = 0; t < 1000; t++)
  AddRow(NULL);
list->Thaw();
return true;
} 
 
bool SortedListWindow::ListDoubleClick(VDKObject*)
{
int ndx  = list->Selected.Row();
if(ndx >= 0)
  {
  if(gtk_clist_get_cell_type(GTK_CLIST(list->CustomWidget()),ndx,0) ==
     GTK_CELL_PIXTEXT)
    list->UpdateRow(ndx,list->Tuples[ndx]);
  else
    list->UpdateRow(ndx,list->Tuples[ndx],mini_bball_xpm,0);
  }
return true;
}
 
