/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKUTILS_H
#define VDKUTILS_H
#include <gdk/gdk.h>
/*
VDKRgb
*/
class VDKRgb
{
 public:
  int red,green,blue;
  VDKRgb(int r = 0, int g = 0, int b = 0): red(r),green(g),blue(b) 
    {
    }
  ~VDKRgb() 
    {
    }
  // names are those provided
  // in rgb X database (normally on /usr/lib/X11/rgb.txt )
  VDKRgb(char* name) 
    {
      red = green = blue = -1;
      GdkColor color;
      if(gdk_color_parse(name, &color))
	{
	red = color.red >> 8;
	green = color.green >> 8;
	blue = color.blue >> 8;
	}
    }
  bool IsValid() { return red != -1 && green != -1 && blue != -1 ; }
  bool operator==(VDKRgb& c) 
  {
    return ( (red == c.red) && (green == c.green) && (blue == c.blue) );
  }
};

/*
   ------------
   point class
   ------------
*/
class  VDKPoint {
 public:
  int x,y;
 public:
  // Constructors
  VDKPoint(): x(0),y(0)
    {
    }
  VDKPoint(int _x, int _y) 
    {  
      x = _x; y = _y; 
    }
  virtual
    ~VDKPoint() 
    {
    }
  /*
    Information functions/operators
  */
  int
    operator ==(VDKPoint& p) {  return (x == p.x ) && (y == p.y);  }
  int
    operator !=(VDKPoint& p) {  return ! (*this == p) ;  }

  /*
    Functions/binary-operators that return points
  */
  VDKPoint
    OffsetBy(int dx, int dy) {  return VDKPoint(x+dx, y+dy);  }
  VDKPoint
    operator -() {  return VDKPoint(-x, -y);  }
  /*
    Functions/assignement-operators that modify this point
  */
  VDKPoint&
    Offset(int dx, int dy);
  //
  int
    X() {  return x;  }
  int
    Y() {  return y;  }
};

/*
   ----------
   rect class
   ----------
*/
class VDKRect
{

 public:
  int left,top,right,bottom;
  int w,h;    // width (in x), height (in y)
 public:



  VDKRect() 
    {  
    left = top = right = bottom = w = h = 0;  
    }
      
  VDKRect(int x, int y, int _w, int _h):w(_w),h(_h)
    {
      left = x; top = y; right = x+_w; bottom = y+_h;
    }

  VDKRect(VDKRect& r):w(r.w),h(r.h)
    {
      left = r.left; right = r.right; top = r.top; bottom = r.bottom;
    }

  ~VDKRect()
    {
    }

  VDKPoint
    Origin() {  return VDKPoint(left,top);  }
  int
    W() {  return w;  }
  int
    H() {  return h;  }
  int
    Contains(VDKPoint& point)
    {
      return point.X() >= left && point.X() < right
	&& point.Y() >= top && point.Y() < bottom;
    }
  int
    Contains(VDKRect& r)  {
    return r.left >= left && r.right <= right
      && r.top >= top && r.bottom <= bottom;
  }


};

#endif







