/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.6
 * Revision 3
 * July 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef PACKER_H
#define PACKER_H
#include <vdk/widcontain.h>
#include <vdk/dlist.h>
#include <vdk/vdkutils.h>
class VDKPacker: public VDKObjectContainer
{
public:
  // properties
  __rwproperty(VDKPacker,int) Spacing;
  __rwproperty(VDKPacker,VDKPoint) Padding;
  VDKPacker(VDKForm* owner);
  virtual ~VDKPacker();

  virtual void Add(VDKObject* obj, 
		   int side = int(GTK_SIDE_TOP),
		   int anchor = int(GTK_ANCHOR_NORTH), 
		   int options = int(GTK_PACK_EXPAND| GTK_FILL_X| GTK_FILL_Y),
		   int borderwith = 0);

  void ReconfigureChild(VDKObject* obj, 
		   int side,
		   int anchor, 
		   int options,
		   int borderwith);

  void ReorderChild(VDKObject* child, int position)
    {
      gtk_packer_reorder_child(GTK_PACKER(widget),
			      GTK_WIDGET(child->Widget()),
			      position); 
    }
  void SetSpacing(int s)
    {  
      gtk_packer_set_spacing(GTK_PACKER(widget),s); 
    }
  void SetPadding(VDKPoint p)
    { 
      gtk_packer_set_default_pad(GTK_PACKER(widget),p.x,p.y); 
    }

};
#endif

