/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * Revision 0.2
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef MENU_H
#define MENU_H
#include <vdk/widcontain.h>
#include <vdk/dlist.h>
#include <vdk/vdktypes.h>
#include <vdk/rawpixmap.h>
#include <gdk/gdkkeysyms.h>
class VDKForms;
class VDKMenubar;
class VDKOptionMenu;

/*
 */
class VDKMenu: public VDKObjectContainer
{
 protected:
  GtkAccelGroup *accel_group; 
 public:
  VDKMenu(VDKForm* owner);
  virtual ~VDKMenu();
  void Separator();
  virtual void SetFont(VDKFont* font);
  void Popup(guint button = 0,  guint32 activate_time = 0);
  void Add(VDKObject* wid, int justify = l_justify,
      int expand = true, int fill = true , int padding = false);
  GtkAccelGroup *AccelGroup() { return accel_group; }
};

/*
 */
class VDKMenuItem: public VDKObject
{
 protected: 
  VDKObjectSignal s_activated;
  VDKMenu* menu;
  GtkWidget *box,*lbl,*pixmapWidget, *tickWidget;
  GdkPixmap* pixmap,*tickPixmap;
  bool ticked;
  guint accelerator_key;
  guint8 modkey;
public:
  __rwproperty(VDKMenuItem,bool) Checked;
  __rwproperty(VDKMenuItem,char*) Caption;
  VDKMenuItem(VDKMenu* menu ,
	      char* prompt, 
	      char** pixmap = NULL,
	      guint key = GDK_VoidSymbol,
	      guint8 modkey = GDK_MOD1_MASK);
  VDKMenuItem(VDKMenubar* bar, 
	      char* prompt, char** pixmap = NULL,
	      int align = l_justify,
	      guint key = GDK_VoidSymbol,
	      guint8 modkey = GDK_MOD1_MASK);
  VDKMenuItem(VDKForm* owner, 
	      char* prompt, char** pixmap = NULL,
	      int align = l_justify,
	      guint key = GDK_VoidSymbol,
	      guint8 modkey = GDK_MOD1_MASK);
  virtual ~VDKMenuItem();
  void SetCaption(char* str);
  guint AccKey() { return accelerator_key; }
  guint8 ModKey() { return modkey; }
  char* GetCaption ();
  void Add(VDKMenu* submenu);
  void Tick(bool flag);
  virtual void SetFont(VDKFont* font);
  void SetPixmap(VDKRawPixmap* newpix);
}; 

/*
 */
class VDKMenubar: public VDKObjectContainer
{
 protected:
  GtkAccelGroup *accel_group; 
  void SetShadow(int shadow)
    { 
      gtk_menu_bar_set_shadow_type(
	      GTK_MENU_BAR(widget),(GtkShadowType) shadow); 
    }
public:
  __rwproperty(VDKMenubar, int) Shadow;
  VDKMenubar(VDKForm* owner);
  ~VDKMenubar();
  virtual void SetFont(VDKFont* font);
  void Add(VDKObject* wid, int justify = l_justify,
      int expand = true, int fill = true , int padding = false);
  GtkAccelGroup *AccelGroup() { return accel_group; }
};

/*
 */
class VDKOptionMenu: public VDKObject
{
public:
  VDKOptionMenu(VDKForm* owner);
  ~VDKOptionMenu();
  void Add(VDKMenu* menu);
  virtual void SetFont(VDKFont* ) {}
};


#endif

