/*
 * ===========================
 * VDK Component Library
 * Version 0.2
 * ===========================
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 * ===========================================
 * This library is a component of:
 * VDK Visual Development Kit
 * Version 0.4.1
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 * ===========================================
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef CHART_H
#define CHART_H
#include <vdk/vdk.h>

class Coord 
{ 
public:
double x,y; 
 Coord(double x = 0.0, double y = 0.0):x(x),y(y) {}
 ~Coord() {}
};

typedef VDKValueList<Coord> CoordList;
typedef VDKValueListIterator<Coord> CoordListIterator;
typedef VDKArray<double>    Darray;

class VDKChart;
////////////////////////////////
class Series: public CoordList
{
  Coord max,min;
  VDKString title;
 public:
  __rwproperty(Series,VDKRgb) Color;
  __rwproperty(Series,GdkLineStyle) LineStyle;
  __rwproperty(Series,int) LineWidth;
  __rwproperty(Series,GdkCapStyle) LineCapStyle;
  __rwproperty(Series,GdkJoinStyle) LineJoinStyle;
  Series(char* title): 
    CoordList(),
    title(title),
    Color("Color",this,VDKRgb(0,0,0)),
    LineStyle("LineStyle",this,GDK_LINE_SOLID),
    LineWidth("LineWidth",this,0),
    LineCapStyle("LineCapStyle",this,GDK_CAP_NOT_LAST),
    LineJoinStyle("LineJoinStyle",this,GDK_JOIN_MITER)
    {}

  ~Series() {}
  void Add(double x, double y);
  void Add(double* x, double* y, int n);
  Coord Min() { return min; }
  Coord Max() { return max; }
  char* Title() { return (char*) title; }
  bool operator==(Series& s) { return title == s.title; }
};

typedef VDKList<Series> SeriesList;
typedef VDKListiterator<Series> SeriesListIterator;

///////////////////////////////////

class ChartAxis
{
  VDKRect  domain;
  VDKChart* owner;
 public:
  ChartAxis():owner((VDKChart*) NULL) {}
  ChartAxis(VDKChart* owner,int w, int h);
  ChartAxis(ChartAxis& a);
  ~ChartAxis() {}
  void Draw();
  VDKRect& Domain() { return domain; }
};

enum 
{
  chart_class = 4096,
  linechart_class,
  scatteredchart_class,
  barchart_class
};

///////////////////////////////////
class VDKChart: public VDKCanvas
{
  
 protected:
  GtkWidget *tip_window;
  VDKPoint size;
  double xn1,yn1,xn2,yn2,xv1,yv1,xv2,yv2,kx,ky;
  Coord domainmax,domainmin;
  SeriesList series;
  bool OnConfigure(VDKObject* sender, GdkEvent* event);
  bool OnClick(VDKObject* sender, GdkEvent* event);
  bool OnClickRelease(VDKObject* sender, GdkEvent* event);
  ChartAxis axis;
  void ComputeDomainLimits(Series* s);
  virtual void DrawChart();
  void DrawTitle();
  void DrawTicks();
  void DrawLabels();
 public:
  __rwproperty(VDKChart,int) ChartBorder;
  __rwproperty(VDKChart, VDKString) Title;
  __rwproperty(VDKChart, VDKString) LabelX;
  __rwproperty(VDKChart, VDKString) LabelY;
  __rwproperty(VDKChart, int) LabelXDigits;
  __rwproperty(VDKChart, int) LabelYDigits;
  VDKChart(VDKForm* owner, int w = 100, int h = 100);
  virtual ~VDKChart();
  virtual int isA() { return chart_class; }
  void AddSeries(Series* s);
  void Clear();
  void SetChartBorder(int b);
  int  GetChartBorder() { return ChartBorder; }
  GdkGC* GC() { return gc; }
  void SetColor(VDKRgb rgb);
  void SetLineAttributes(gint lineWidth, 
			 GdkLineStyle lineStyle,
			 GdkCapStyle capStyle,
			 GdkJoinStyle joinStyle);
  // placeholder for subclasses
  virtual void Plot(VDKPoint& , int , Series*) {}
  DECLARE_EVENT_LIST(VDKChart);
};
///////////////////////////////////////
class VDKLineChart: public VDKChart
{
 public:
  VDKLineChart(VDKForm* owner, int w = 100, int h = 100):
    VDKChart(owner,w,h) {}
  virtual ~VDKLineChart() {}
  virtual void Plot(VDKPoint& p, int t, Series*);
  virtual int isA() { return linechart_class; }
};
///////////////////////////////////////
class VDKScatteredChart: public VDKChart
{
 public:
  VDKScatteredChart(VDKForm* owner, int w = 100, int h = 100):
    VDKChart(owner,w,h) {}
  virtual ~VDKScatteredChart() {}
  virtual void Plot(VDKPoint& p, int t, Series*);
  virtual int isA() { return scatteredchart_class; }
};

///////////////////////////////////////
class VDKBarChart: public VDKChart
{
 public:
  __rwproperty(VDKBarChart,int) BarWidth;
  __rwproperty(VDKBarChart,bool) Labels;
  VDKBarChart(VDKForm* owner, int w = 100, int h = 100):
    VDKChart(owner,w,h),
    BarWidth("BarWidth",this,20),
    Labels("Labels",this,true)
    {}
  virtual ~VDKBarChart() {}
  virtual void Plot(VDKPoint& p, int t, Series*);
  virtual int isA() { return barchart_class; }
};

#endif


