/* $Id: svgaggi_internal.h,v 1.7 1999/02/04 20:30:55 marcus Exp $
******************************************************************************

   SVGAlib wrapper for LibGGI - internal definitions

   Copyright (C) 1998-1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _SVGAGGI_INTERNAL_H
#define _SVGAGGI_INTERNAL_H

#include "config.h"
#include <ggi/ggi.h>
#ifdef HAVE_GGI_GGI_UNIX_H
#include <ggi/ggi-unix.h>
#endif
#include <vga.h>
#include <vgamouse.h>
#include <vgakeyboard.h>

extern ggi_visual_t _ggigsw_visual;
extern int _ggigsw_inggi;
extern int _ggigsw_async;
extern int _ggigsw_but2key;
extern int _ggigsw_modeemu;

#define GSW_CTRLC_C	1
#define GSW_CTRLC_CTRL	2
extern int _ggigsw_ctrlc;

extern int _ggigsw_keytransmask;

/* Internal functions */
void _ggigsw_mode5flush(void);
int _ggigsw_getmouseevent(int wait);
int _ggigsw_getkeyevent(int wait);
extern void (*_ggigsw_mousehandler) (int, int, int, int, int, int, int);
extern void (*_ggigsw_keyhandler) (int, int);

#define COLORSHIFT	10

#define GSW_PAGESIZE	(1<<16)

#define GSW_WANTIT	1
#define GSW_HAVEIT	2
#define GSW_HAVEMODE5	3

#define GSW_ASYNCKEY	1
#define GSW_ASYNCMOUSE	2

#define GSW_BUT4	SCANCODE_I
#define GSW_BUT5	SCANCODE_J
#define GSW_BUT6	SCANCODE_K

/* Debugging macros */
#if 0
#define _GSWPRINT(s)		printf(s)
#define _GSWPRINT_I(s,val) 	printf(s, val)
#else
#define _GSWPRINT(s)
#define _GSWPRINT_I(s,val)
#endif

#endif /* _SVGAGGI_INTERNAL_H */
