/* $Id: message.c,v 1.5 1998/07/05 16:57:03 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            message.c
 *  MODULE OF       shhmsg - library for displaying messages.
 *
 *  DESCRIPTION     Routines for displaying messages unless "quiet mode"
 *                  is on.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *
 **************************************************************************/

#include <stdio.h>
#include <stdarg.h>

#include "internal.h"
#include "shhmsg.h"

/**************************************************************************
 *                                                                        *
 *                        P U B L I C    D A T A                          *
 *                                                                        *
 **************************************************************************/

int msgBeQuiet = 0;             /* supress everything from msgMessage() ? */



/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          msgSetQuiet
 *
 *  FUNCTION      Decide whether msgMessage() should display anything.
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                void msgSetQuiet(int onoff);
 *
 *  INPUT         onoff   1 to disable all messages, 0 to enable.
 *
 *  DESCRIPTION   Used in conjunction with the msgMessage() function.
 *                Note that changing the msgBeQuiet-variable directly
 *                is fully legal.
 */
void
msgSetQuiet(int onoff)
{
    msgBeQuiet = onoff;
}



/*-------------------------------------------------------------------------
 *
 *  NAME          msgMessage
 *
 *  FUNCTION      Show given message unless quiet mode is on.
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                void msgMessage(const char *format, ...);
 *
 *  INPUT         format, ...
 *                        Arguments used as with printf().
 *
 *  DESCRIPTION   If msgSetQuiet(0) has been called, the given message is
 *                displayed on the _msgMessageStream. If msgSetQuiet(1)
 *                has been called, this function just returns.
 */
void
msgMessage(const char *format, ...)
{
    va_list ap;

    if (msgBeQuiet)
        return;
    fflush(stdout);
    if (_msgShowNameAlways)
	fprintf(_msgMessageStream, "%s: ", msgGetName());
    va_start(ap, format);
    vfprintf(_msgMessageStream, format, ap);
    va_end(ap);
}
