//	videapp.h:	Header for videApp class
//=======================================================================

#ifndef videAPP_H
#define videAPP_H

// Include standard V files as needed

#define VIDE_VERS "The V IDE (V 0.8 - 6 August 1999) for GNU g++ and Java"

#ifdef vDEBUG
#include <v/vdebug.h>
#endif

#include <v/vapp.h>
#include <v/vawinfo.h>
#include <v/vtimer.h>

#include "videcmdw.h"	// we use videCommandWindow
#include "vdbcmdw.h"	// debug command window

    enum Emulation
      {
        Generic,
        See,
        Vi,
        Emacs,
        Epsilon,
        WordStar
      };

    enum {
	m_FirstCmd = 100, 		// Dummy Command
	m_Options,			// set options
        m_View,				// view a file R/O
	m_saveAll,
        m_SaveClose,
        m_Build,
        m_MakeAll,
        m_MakeClean,
        m_MakeDebug,
        m_MakeArgs,
        m_StopMake,
        m_SelectMake,
	m_sendToBrowser,

	m_Project,           // Project menu
	m_ProjectNewC,        // ProjectDialog menu
	m_ProjectNewJava,        // ProjectDialog menu
	m_ProjectOpen, 	     // ProjectDialog menu
	m_ProjectEdit,
	m_ProjectClose,
	m_ProjectSaveAs,
	m_MakeMake,

        m_Tools,
        m_RunVgen,
        m_RunViconed,
        m_RunCmdArgs,
        m_RunProject,
        m_RunShell,

	m_CloseDebug,
	m_DebugMenu,
	m_Help,
	m_AboutVide,
	m_EditorPrefs,
	m_VidePrefs,

	videHelp,
	gnuHelp,
	win32Help,
	vguiHelp,
	javaHelp,
       	htmlCSSHelp,
	htmlHelp,

	m_Debug,
	m_RunTo,
	m_StepOver,
	m_StepInto,
	m_StopDebug,
	m_SetBP,
	m_DeleteBP,
	m_CallStack,
	m_Inspect,
	m_ShowBreakpoints,
	m_DeleteBreakpoints,
	m_Continue,
	m_Kill,
	m_DBRun,
	m_SetArgs,
	m_DBHelp,
	m_lastDebug
      };
//@V@:EndIDs

    class myTimer : public vTimer
      {
      public:		//---------------------------------------- public
	myTimer() {}
	~myTimer() {}
	virtual void TimerTick();
      private:		//--------------------------------------- private
      };

    class videApp : public vApp
      {
	friend int AppMain(int, char**);	// allow AppMain access

      public:		//---------------------------------------- public

	videApp(char* name, int sdi = 0, int h = 0, int w = 0);
	virtual ~videApp();

	// Routines from vApp that are normally overridden

	virtual vWindow* NewAppWin(vWindow* win, VCONST char* name, int w, int h,
		vAppWinInfo* winInfo = 0);

	virtual void Exit(void);

	virtual int CloseAppWin(vWindow*);

	virtual void AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType);

	virtual void KeyIn(vWindow*, vKey, unsigned int);

 	// routines for videApp

        videCmdWindow* GetMsgWindow() { return _videCmdWin; }
	void splitFileName(char* fn, char* fdir, char* fbase, char* fext);

        void SetMkFile(char* mkf);
        char* GetMkFile() { return _videMkFile; }

        Emulation GetEmulation() { return _emulation; }
        void SetEmulation(Emulation em) { _emulation = em; }

	char* getHelpPath() {return _videHelpPath;}
	char* getJavaPath() {return _videJavaPath;}
	char* getBrowser() {return _videBrowser;}
	char* getHelpViewer() {return _videHelpViewer;}
	char* getVideShell() {return _videShell;}
	char* getDebugger() {return _videDebugger;}
	void setHelpPath(const char* hp) {strcpy(_videHelpPath,hp);}
	void setJavaPath(const char* jp) {strcpy(_videJavaPath,jp);}
	void setBrowser(const char* bp) {strcpy(_videBrowser,bp);}
	void setHelpViewer(const char* bp) {strcpy(_videHelpViewer,bp);}
	void setVideShell(const char* bp) {strcpy(_videShell,bp);}
	void setDebugger(const char* bp) {strcpy(_videDebugger,bp);}
	int getAutoSave() {return _autoSave;}
	void setAutoSave(int v);
	int getBackup() {return _backup;}
	void setBackup(int v) {_backup = v;}
	int getDefaultRows() { return _winRows;}
	int getDefaultCols() { return _winCols;}
	void setDefaultRows(int r) { _winRows = r;}
	void setDefaultCols(int c) { _winCols = c;}

	int readPrefs();
	void savePrefs();
	void setEditLocals();

	// Debug helpers
	bool debuggerOpen() { return vdbCmdWin != 0;}
	void debugCommand(videCmdWindow* win, ItemVal id);
	void DebuggerClosed() {vdbCmdWin = 0;};
	void runDebug(videCmdWindow* win, const char* runName);

	// help
	void showHelp(int id);
	int findHelp(const char* name, const char* dir, const char* path,
		int showNotice = 1, int browser = 0);

	// make the default font easily available...

	vFont DefaultFont;

      protected:	//--------------------------------------- protected

      private:		//--------------------------------------- private

        Emulation _emulation;
	videCmdWindow* _videCmdWin;	// first window - the info console
	vdbCmdWindow* vdbCmdWin;	// The debug cmd window

	myTimer* _saveTimer;

	int _tabSpacing;
	int _backup;
	int _autoSave;
	int _wrapLim;
	int _winRows;
	int _winCols;
        char _videMkFile[maxFileNameSize];
        char _videHelpPath[maxFileNameSize];
        char _videJavaPath[maxFileNameSize];
        char _videBrowser[maxFileNameSize];
        char _videHelpViewer[maxFileNameSize];
        char _videShell[maxFileNameSize];
        char _videDebugger[maxFileNameSize];
      };
#endif
