/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_BView.h,v 1.2 1999/02/20 00:54:47 slouken Exp $";
#endif

/* This is the event handling and graphics update portion of SDL_BWin */

extern "C" {
#include "SDL_events_c.h"
};

class SDL_BView : public BView
{
public:
	SDL_BView(BRect frame) : 
		BView(frame, "SDL View", B_FOLLOW_ALL_SIDES,
					(B_WILL_DRAW|B_FRAME_EVENTS)) {
		SetBitmap(NULL);
		return;
	}
	virtual ~SDL_BView() {
		SetBitmap(NULL);
	}
	virtual float Width(void) {
		return(w);
	}
	virtual float Height(void) {
		return(h);
	}

	/* Drawing portion of this complete breakfast. :) */
	virtual void FrameResized(float width, float height) {
		w = width;
		h = height;
		BView::FrameResized(width, height);
	}
	virtual void SetBitmap(BBitmap *bitmap) {
		image = bitmap;
	}
	virtual void Draw(BRect updateRect) {
		if ( image )
			DrawBitmap(image, updateRect, updateRect);
	}
	virtual void DrawAsync(BRect updateRect) {
		DrawBitmapAsync(image, updateRect, updateRect);
	}

private:
	float    w, h;
	BBitmap *image;
};
