#!/usr/bin/perl
#
# Program to take a set of header files and generate MWCC export definitions

while ( ($file = shift(@ARGV)) ) {
	if ( ! defined(open(FILE, $file)) ) {
		warn "Couldn't open $file: $!\n";
		next;
	}
	$file =~ s,.*/,,;
	while (<FILE>) {
		if ( /^SDL_DEFUN\(.*,\s*([^\s]+),/ ) {
			print "_$1\n";
		}
	}
	close(FILE);
}
# Special exports not public in the header files
print "_SDL_Init\n";
print "_SDL_Quit\n";
print "_SDL_LockSO\n";
