/* $Id: gg.h,v 1.15 1999/04/30 19:09:18 marcus Exp $
******************************************************************************
  
   LibGG - API header file
  
   Copyright (C) 1998 Marcus Sundberg		[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   
******************************************************************************
*/

#ifndef _GGI_GG_H
#define _GGI_GG_H

#include <stdio.h>
#include <stdlib.h>
#include <ggi/errors.h>
#include <ggi/system.h>

/*
******************************************************************************
 Initialize/Deinitialize library
******************************************************************************
*/

int ggInit(void);

int ggExit(void);


/*
******************************************************************************
 Functions for adding and removing cleanup callbacks
******************************************************************************
*/

typedef void (ggcleanup_func)(void *);

int ggRegisterCleanup(ggcleanup_func *func, void *arg);

int ggUnregisterCleanup(ggcleanup_func *func, void *arg);

/* Try to force _exit() when a handler is triggered */
void ggCleanupForceExit(void);


/*
******************************************************************************
 Misc functions
******************************************************************************
*/

/* Get the users "home" directory, or whatever the equivalent is under the
   system we are running on. */
const char *ggGetUserDir(void);


/*
******************************************************************************
 Configuration file handling
******************************************************************************
*/

int ggLoadConfig(const char *file, void **confret);

void ggFreeConfig(void *conf);

const char *ggMatchConfig(const void *conf, const char *name,
			  const char *version);

/*
******************************************************************************
 Dynamic module loading
******************************************************************************
*/

#ifdef _WIN32
typedef HMODULE gg_module;
#else
typedef void *gg_module;
#endif

#define GG_MODULE_GLOBAL 1

#ifdef _WIN32
#define GG_MODULE_NULL NULL /* FIXME ??? */
#else
#define GG_MODULE_NULL NULL
#endif 

/* Dynamicly load file */
gg_module ggLoadModule(const char *filename, int flags);

/* Try to match name in conf and load the resulting filename */
gg_module ggMLoadModule(const void *conf, const char *name, 
			const char *version, int flags);

/* Get Address of symbol in module */
void *ggGetSymbolAddress(gg_module module, const char *symbol);

/* Unload a module and free resources */
void ggFreeModule(gg_module module);


/*
******************************************************************************
 Parsing functions
******************************************************************************
*/

/* Read the first matching option from an option file into the corresponding
   result entry */
int ggGetFileOpt(FILE *fp, const char **optnames, char **results, int ressize);

char *ggParseTarget(const char *str, char *target, int max);

#define MAX_OPTION_NAME    32
#define MAX_OPTION_RESULT  256

typedef struct gg_option
{
	char name[MAX_OPTION_NAME];
	char result[MAX_OPTION_RESULT];
} gg_option;

char *ggParseOptions(const char *str, gg_option *optlist, int count);


/*
******************************************************************************
 Debug output
******************************************************************************
*/

void ggDPrintf(int sync, const char *subsys, const char *form, ...);

/*
******************************************************************************
 Mutex locking
******************************************************************************
*/

void *ggLockCreate(void);

int ggLockDestroy(void *lock);

int ggLock(void *lock);

int ggUnlock(void *lock);

int ggTryLock(void *lock);

#endif /* _GGI_GG_H */
