/* $Id: visual.c,v 1.11 1998/11/19 01:06:30 marcus Exp $
******************************************************************************

   SVGAlib target vgagl helper: initialization

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <ggi/internal/ggi-dl.h>
#include "vgaglvis.h"

int GGIdlinit(ggi_visual *visual,const char *args,void *argptr)
{
	if (args==NULL
		|| strncmp(args,"sVgALIb",7) != 0)
		return GGI_DL_ERROR;
	
	gl_setcontextvga(vga_getcurrentmode());

	/* Generic drawing
	 */
	visual->opdraw->drawpixel_nc=GGI_vgagl_drawpixel_nc;
	visual->opdraw->drawpixel=GGI_vgagl_drawpixel;
	visual->opdraw->putpixel_nc=GGI_vgagl_putpixel_nc;
	visual->opdraw->putpixel=GGI_vgagl_putpixel;
	visual->opdraw->getpixel=GGI_vgagl_getpixel;

	visual->opdraw->drawhline_nc=GGI_vgagl_drawhline_nc;
	visual->opdraw->drawhline=GGI_vgagl_drawhline;
	visual->opdraw->gethline=GGI_vgagl_gethline;
	visual->opdraw->puthline=GGI_vgagl_puthline;

	visual->opdraw->drawvline_nc=GGI_vgagl_drawvline_nc;
	visual->opdraw->drawvline=GGI_vgagl_drawvline;
	visual->opdraw->getvline=GGI_vgagl_getvline;
	visual->opdraw->putvline=GGI_vgagl_putvline;
	
	visual->opdraw->drawbox=GGI_vgagl_drawbox;
	visual->opdraw->putbox=GGI_vgagl_putbox;
	visual->opdraw->getbox=GGI_vgagl_getbox;
	visual->opdraw->fillscreen=GGI_vgagl_fillscreen;

	/* 
	visual->opdraw->putc=GGI_vgagl_putc;
	visual->opdraw->getcharsize=GGI_vgagl_getcharsize;
	visual->opdraw->drawline=GGI_vgagl_drawline;
	visual->opdraw->crossblit=GGI_vgagl_crossblit;
	*/

	return GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}

#include <ggi/internal/ggidlinit.h>
